/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefixInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssEditPrefixesListPanel {
    private final ListTableModel<CssPrefixInfo> myPrefixesModel;
    private final TableView<CssPrefixInfo> myPrefixesTableView;

    public CssEditPrefixesListPanel() {
        ColumnInfo[] columns = new ColumnInfo[CssPrefix.values().length + 1];
        columns[0] = new PropertyColumn();
        CssPrefix[] values = CssPrefix.values();
        for (int i = 0; i < values.length; ++i) {
            columns[i + 1] = new PrefixColumnInfo(values[i]);
        }
        this.myPrefixesModel = new ListTableModel(columns, new ArrayList(), 0);
        this.myPrefixesModel.setSortable(true);
        this.myPrefixesTableView = new TableView(this.myPrefixesModel);
        this.myPrefixesTableView.setAutoCreateRowSorter(true);
        this.myPrefixesTableView.setBorder(null);
        this.myPrefixesTableView.setStriped(true);
        this.myPrefixesTableView.getRowSorter().toggleSortOrder(0);
        this.myPrefixesTableView.setVisibleRowCount(5);
        new TableViewSpeedSearch<CssPrefixInfo>(this.myPrefixesTableView){

            protected String getItemText(@NotNull CssPrefixInfo element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element.getPropertyName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/emmet/configuration/CssEditPrefixesListPanel$1", "getItemText"));
            }
        };
    }

    public void setEnabled(boolean value) {
        this.myPrefixesTableView.setStriped(value);
        this.myPrefixesTableView.setEnabled(value);
    }

    public void setState(Set<CssPrefixInfo> prefixInfos) {
        this.myPrefixesModel.setItems((List)Lists.newArrayList(prefixInfos));
    }

    public Set<CssPrefixInfo> getState() {
        return Sets.newHashSet((Iterable)this.myPrefixesModel.getItems());
    }

    public JPanel createMainComponent() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myPrefixesTableView);
        decorator.disableUpDownActions();
        JPanel panel = decorator.createPanel();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.stopEditing((JTable)CssEditPrefixesListPanel.this.myPrefixesTableView);
                String propertyName = Messages.showInputDialog((Component)CssEditPrefixesListPanel.this.myPrefixesTableView, (String)CssBundle.message((String)"dialog.message.property.name", (Object[])new Object[0]), (String)CssBundle.message((String)"dialog.title.new.css.property", (Object[])new Object[0]), null);
                if (propertyName != null && !propertyName.isEmpty()) {
                    List items = CssEditPrefixesListPanel.this.myPrefixesModel.getItems();
                    for (CssPrefixInfo state : items) {
                        if (!propertyName.equals(state.getPropertyName())) continue;
                        CssEditPrefixesListPanel.this.myPrefixesTableView.clearSelection();
                        CssEditPrefixesListPanel.this.myPrefixesTableView.addSelection((Object)state);
                        this.scrollToSelection();
                        return;
                    }
                    CssPrefixInfo newPrefixInfo = new CssPrefixInfo(propertyName, new CssPrefix[0]);
                    CssEditPrefixesListPanel.this.myPrefixesModel.addRow((Object)newPrefixInfo);
                    CssEditPrefixesListPanel.this.myPrefixesTableView.clearSelection();
                    CssEditPrefixesListPanel.this.myPrefixesTableView.addSelection((Object)newPrefixInfo);
                    this.scrollToSelection();
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)CssEditPrefixesListPanel.this.myPrefixesTableView, true));
            }

            private void scrollToSelection() {
                int selectedRow = CssEditPrefixesListPanel.this.myPrefixesTableView.getSelectedRow();
                if (selectedRow >= 0) {
                    CssEditPrefixesListPanel.this.myPrefixesTableView.scrollRectToVisible(CssEditPrefixesListPanel.this.myPrefixesTableView.getCellRect(selectedRow, 0, true));
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.stopEditing((JTable)CssEditPrefixesListPanel.this.myPrefixesTableView);
                CssPrefixInfo selectedObject = (CssPrefixInfo)CssEditPrefixesListPanel.this.myPrefixesTableView.getSelectedObject();
                int selectedRow = CssEditPrefixesListPanel.this.myPrefixesTableView.getSelectedRow();
                int index = CssEditPrefixesListPanel.this.myPrefixesModel.indexOf((Object)selectedObject);
                if (0 <= index && index < CssEditPrefixesListPanel.this.myPrefixesModel.getRowCount()) {
                    CssEditPrefixesListPanel.this.myPrefixesModel.removeRow(index);
                    if (selectedRow < CssEditPrefixesListPanel.this.myPrefixesTableView.getRowCount()) {
                        CssEditPrefixesListPanel.this.myPrefixesTableView.setRowSelectionInterval(selectedRow, selectedRow);
                    } else if (selectedRow > 0) {
                        CssEditPrefixesListPanel.this.myPrefixesTableView.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                    }
                }
                CssEditPrefixesListPanel.this.myPrefixesTableView.getParent().repaint();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)CssEditPrefixesListPanel.this.myPrefixesTableView, true));
            }
        });
        return panel;
    }

    private class PrefixColumnInfo
    extends ColumnInfo<CssPrefixInfo, Boolean> {
        private final CssPrefix myPrefix;
        private final BooleanTableCellRenderer myCellRenderer;

        @Nullable
        public TableCellRenderer getRenderer(CssPrefixInfo state) {
            return this.myCellRenderer;
        }

        PrefixColumnInfo(CssPrefix prefix) {
            super(prefix.getText());
            this.myCellRenderer = new BooleanTableCellRenderer();
            this.myPrefix = prefix;
        }

        @Nullable
        public TableCellEditor getEditor(CssPrefixInfo prefixInfo) {
            JBCheckBox box = new JBCheckBox();
            box.setHorizontalAlignment(0);
            return new DefaultCellEditor((JCheckBox)box);
        }

        public boolean isCellEditable(CssPrefixInfo prefixInfo) {
            return CssEditPrefixesListPanel.this.myPrefixesTableView.isEnabled();
        }

        public final Class<Boolean> getColumnClass() {
            return Boolean.class;
        }

        public final void setValue(CssPrefixInfo prefixInfo, Boolean aValue) {
            prefixInfo.setValue(this.myPrefix, aValue);
        }

        @Nullable
        public final Boolean valueOf(CssPrefixInfo state) {
            return state.getValue(this.myPrefix);
        }
    }

    private static class PropertyColumn
    extends ColumnInfo<CssPrefixInfo, String> {
        PropertyColumn() {
            super(CssBundle.message((String)"column.info.property", (Object[])new Object[0]));
        }

        @Nullable
        public String valueOf(CssPrefixInfo prefixInfo) {
            return prefixInfo.getPropertyName();
        }
    }
}

