/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerErrorUtil;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.ResponseItemCallbackTemplate;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0017\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/docker/agent/progress/PromisingSerializedItemsCallback;", "RI", "Lcom/github/dockerjava/api/model/ResponseItem;", "Lcom/intellij/docker/agent/progress/ResponseItemCallbackTemplate;", "result", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "(Ljava/util/concurrent/CompletableFuture;)V", "myChannel", "myIsClosed", "", "closeChannel", "", "onComplete", "onError", "throwable", "", "onNext", "item", "(Lcom/github/dockerjava/api/model/ResponseItem;)V", "onStart", "stream", "Ljava/io/Closeable;", "sendResponseItem", "Lcom/intellij/docker/agent/progress/DockerResponseItem$Impl;", "signalClosed", "wrapAgentItem", "Lcom/intellij/docker/agent/progress/DockerResponseItem$Builder;", "agentItem", "(Lcom/github/dockerjava/api/model/ResponseItem;)Lcom/intellij/docker/agent/progress/DockerResponseItem$Builder;", "wrapError", "intellij.clouds.docker.agent.impl.rt"})
public class PromisingSerializedItemsCallback<RI extends ResponseItem>
extends ResponseItemCallbackTemplate<RI> {
    private volatile boolean myIsClosed;
    private BlockingQueue<byte[]> myChannel;
    private final CompletableFuture<BlockingQueue<byte[]>> result;

    @NotNull
    protected DockerResponseItem.Builder wrapAgentItem(@NotNull RI agentItem) {
        Intrinsics.checkParameterIsNotNull(agentItem, (String)"agentItem");
        return DockerResponseItem.Companion.fromAgentItem(agentItem);
    }

    public void onStart(@NotNull Closeable stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        this.myChannel = new LinkedBlockingQueue();
        BlockingQueue<byte[]> blockingQueue = this.myChannel;
        if (blockingQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myChannel");
        }
        this.result.complete(blockingQueue);
    }

    public void onNext(@Nullable RI item) {
        if (item != null && !this.myIsClosed) {
            DockerResponseItem.Impl impl = this.wrapAgentItem(item).build();
            this.sendResponseItem(impl);
        }
    }

    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        DockerResponseItem.Impl impl = this.wrapError(throwable);
        if (impl != null) {
            DockerResponseItem.Impl impl2 = impl;
            boolean bl = false;
            boolean bl2 = false;
            DockerResponseItem.Impl it = impl2;
            boolean bl3 = false;
            this.sendResponseItem(it);
        }
        super.onError(throwable);
        this.closeChannel();
    }

    public void onComplete() {
        super.onComplete();
        this.closeChannel();
    }

    @Nullable
    protected DockerResponseItem.Impl wrapError(@NotNull Throwable throwable) {
        DockerResponseItem.Impl impl;
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        Throwable throwable2 = throwable;
        if (!(throwable2 instanceof DockerException)) {
            throwable2 = null;
        }
        DockerException dockerException = (DockerException)throwable2;
        if (dockerException != null) {
            DockerException dockerException2 = dockerException;
            boolean bl = false;
            boolean bl2 = false;
            DockerException it = dockerException2;
            boolean bl3 = false;
            DockerResponseItem.Builder builder = new DockerResponseItem.Builder();
            String string = DockerErrorUtil.extractDockerErrorMessage((Exception)((Exception)((Object)it)));
            if (string == null) {
                string = it.getMessage();
            }
            impl = builder.withError(0, string).build();
        } else {
            impl = null;
        }
        return impl;
    }

    private final void sendResponseItem(DockerResponseItem.Impl item) {
        try {
            byte[] bytes = item.toByteArray();
            BlockingQueue<byte[]> blockingQueue = this.myChannel;
            if (blockingQueue == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myChannel");
            }
            blockingQueue.add(bytes);
        }
        catch (IOException e) {
            this.closeChannel();
        }
    }

    private final byte[] signalClosed() {
        return new byte[0];
    }

    private final void closeChannel() {
        if (!this.myIsClosed) {
            BlockingQueue<byte[]> blockingQueue = this.myChannel;
            if (blockingQueue == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myChannel");
            }
            blockingQueue.add(this.signalClosed());
            this.myIsClosed = true;
        }
    }

    public PromisingSerializedItemsCallback(@NotNull CompletableFuture<BlockingQueue<byte[]>> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        this.result = result;
    }
}

