/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.InspectContainerCmdExec;
import com.github.dockerjava.core.exec.StartContainerCmdExec;
import com.github.dockerjava.core.util.CertificateUtils;
import com.google.common.base.Preconditions;
import com.intellij.docker.agent.fix.FixedCreateContainerCmdExecWithAutoRemove;
import com.intellij.docker.agent.fix.FixedHostConfig;
import com.intellij.docker.agent.netty.NettyDockerCmdExecFactoryCopy;
import com.intellij.docker.agent.netty.NettyWebTargetFixed;
import com.intellij.docker.agent.tty.ResizeContainerCmd;
import com.intellij.docker.agent.tty.ResizeContainerCmdExec;
import com.intellij.docker.agent.tty.ResizeExecCmd;
import com.intellij.docker.agent.tty.ResizeExecCmdExec;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDockerCmdExecNettyFactoryCopyImpl
extends NettyDockerCmdExecFactoryCopy {
    @Override
    protected NettyDockerCmdExecFactoryCopy.NettyInitializer createUnixDomainSocketInitializer() {
        if (Epoll.isAvailable()) {
            return new NettyDockerCmdExecFactoryCopy.UnixDomainSocketInitializer(this);
        }
        if (KQueue.isAvailable()) {
            return new KQueueDomainSocketInitializer();
        }
        throw new IllegalStateException("Neither Epoll nor KQueue support available for Unix domain socket connection", KQueue.unavailabilityCause());
    }

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        LocalDirectorySSLConfig sslConfigImpl;
        String certificatesPath;
        URI targetUri = (URI)Preconditions.checkNotNull((Object)dockerClientConfig.getDockerHost(), (Object)"Docker host is not specified");
        if ("tcp".equals(targetUri.getScheme()) && dockerClientConfig.getSSLConfig() instanceof LocalDirectorySSLConfig && !CertificateUtils.verifyCertificatesExist((String)(certificatesPath = (String)Preconditions.checkNotNull((Object)(sslConfigImpl = (LocalDirectorySSLConfig)dockerClientConfig.getSSLConfig()).getDockerCertPath(), (Object)"Certificates path is not specified")))) {
            throw new IllegalArgumentException("Can't locate certificate files under " + certificatesPath);
        }
        super.init(dockerClientConfig);
    }

    @Override
    protected WebTarget createBaseResource(String host) {
        return new NettyWebTargetFixed(this.getDockerClientConfig().getObjectMapper(), this.channelProvider, host);
    }

    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return new FixedStartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        NettyWebTargetFixed baseResourceImpl = (NettyWebTargetFixed)this.getBaseResource();
        String host = baseResourceImpl.getHost();
        return new FixedCreateContainerCmdExecWithAutoRemove(this.createBaseResource(host), baseResourceImpl, this.getDockerClientConfig());
    }

    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return new FixedInspectContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    public ResizeContainerCmd.Exec createResizeContainerCmdExec() {
        return new ResizeContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    public ResizeExecCmd.Exec createResizeExecCmdExec() {
        return new ResizeExecCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    public static class FixedInspectContainerResponse
    extends InspectContainerResponse {
        @JsonProperty(value="State")
        private FixedContainerState myFixedState;
        @JsonProperty(value="HostConfig")
        private FixedHostConfig myHostConfig;
        @JsonProperty(value="Node")
        private NodeCopy myNode;

        public FixedHostConfig getHostConfig() {
            return this.myHostConfig;
        }

        public FixedContainerState getState() {
            return this.myFixedState;
        }

        public NodeCopy getNode() {
            return this.myNode;
        }

        public class NodeCopy
        extends InspectContainerResponse.Node {
            public NodeCopy() {
                super((InspectContainerResponse)FixedInspectContainerResponse.this);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public class FixedContainerState
        extends InspectContainerResponse.ContainerState {
            @JsonProperty(value="ExitCode")
            private Long myFixedExitCode;

            public FixedContainerState() {
                super((InspectContainerResponse)FixedInspectContainerResponse.this);
            }

            public Integer getExitCode() {
                return this.myFixedExitCode == null ? null : Integer.valueOf(this.myFixedExitCode.intValue());
            }

            public Integer getSuperExitCode() {
                return super.getExitCode();
            }

            public Long getLongExitCode() {
                return this.myFixedExitCode;
            }
        }
    }

    private static class FixedInspectContainerCmdExec
    extends InspectContainerCmdExec {
        private static final Logger LOGGER = LoggerFactory.getLogger(InspectContainerCmdExec.class);

        FixedInspectContainerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
            super(baseResource, dockerClientConfig);
        }

        protected InspectContainerResponse execute(InspectContainerCmd command) {
            Long longExitCode;
            WebTarget webResource = this.getBaseResource().path(new String[]{"/containers/{id}/json"}).resolveTemplate("id", (Object)command.getContainerId());
            webResource = this.booleanQueryParam(webResource, "size", command.getSize());
            LOGGER.debug("GET: {}", (Object)webResource);
            FixedInspectContainerResponse result = (FixedInspectContainerResponse)((Object)webResource.request().accept(MediaType.APPLICATION_JSON).get((TypeReference)new TypeReference<FixedInspectContainerResponse>(){}));
            FixedInspectContainerResponse.FixedContainerState state = Optional.ofNullable(result).map(FixedInspectContainerResponse::getState).orElse(null);
            if (state != null && (longExitCode = state.getLongExitCode()) != null && (long)longExitCode.intValue() != longExitCode) {
                LOGGER.debug("Too big long exit code {} reduced to valid int value: {}", (Object)longExitCode, (Object)state.getExitCode());
            }
            return result;
        }
    }

    private static class FixedStartContainerCmdExec
    extends StartContainerCmdExec {
        private static final Logger LOGGER = LoggerFactory.getLogger(StartContainerCmdExec.class);

        FixedStartContainerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
            super(baseResource, dockerClientConfig);
        }

        protected Void execute(StartContainerCmd command) {
            WebTarget webResource = this.getBaseResource().path(new String[]{"/containers/{id}/start"}).resolveTemplate("id", (Object)command.getContainerId());
            LOGGER.trace("POST: {}", (Object)webResource);
            webResource.request().accept(MediaType.APPLICATION_JSON).post(null);
            return null;
        }
    }

    private static class KQueueDomainSocketInitializer
    implements NettyDockerCmdExecFactoryCopy.NettyInitializer {
        private volatile String mySocketPath;

        private KQueueDomainSocketInitializer() {
        }

        @Override
        public EventLoopGroup init(Bootstrap bootstrap, DockerClientConfig dockerClientConfig) {
            if (dockerClientConfig.getDockerHost().getPath() == null) {
                throw new IllegalStateException("Path must not be null");
            }
            this.mySocketPath = dockerClientConfig.getDockerHost().getPath();
            KQueueEventLoopGroup nioEventLoopGroup = new KQueueEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(threadPrefix));
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channel(KQueueDomainSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<KQueueDomainSocketChannel>(){

                protected void initChannel(KQueueDomainSocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{FixedDockerCmdExecNettyFactoryCopyImpl.newLoggingHandler()});
                    channel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                }
            });
            return nioEventLoopGroup;
        }

        @Override
        public DuplexChannel connect(Bootstrap bootstrap) throws InterruptedException {
            if (this.mySocketPath == null) {
                throw new IllegalStateException("socket path is not initialized");
            }
            if (!Files.exists(Paths.get(this.mySocketPath, new String[0]), new LinkOption[0])) {
                throw new RuntimeException("socket not found: " + this.mySocketPath);
            }
            DomainSocketAddress address = new DomainSocketAddress(this.mySocketPath);
            return (DuplexChannel)bootstrap.connect((SocketAddress)address).sync().channel();
        }
    }
}

