/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.compose.ComposeNavigatableHelper;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeStartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeServiceRuntime
extends DockerApplicationRuntime
implements DockerParentRuntime {
    private final DeploymentStatus myStatus;
    private final String myServiceName;
    private final Map<String, DockerApplicationRuntime> myContainers;

    public ComposeServiceRuntime(@NotNull ComposeApplicationRuntime parentRuntime, @NotNull String serviceName) {
        if (parentRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(0);
        }
        if (serviceName == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(1);
        }
        this(parentRuntime, serviceName, parentRuntime.getApplicationName() + ":" + serviceName);
    }

    protected ComposeServiceRuntime(@NotNull DockerParentRuntime parentRuntime, @NotNull String serviceName, @NotNull String displayName) {
        if (parentRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(2);
        }
        if (serviceName == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(4);
        }
        super(parentRuntime.asDockerRuntime().getRuntimeContext(), displayName, parentRuntime);
        this.myContainers = new TreeMap<String, DockerApplicationRuntime>();
        this.myServiceName = serviceName;
        this.myStatus = new DeploymentStatus(DockerCloudType.getInstance().getIcon(), serviceName, false);
    }

    @Override
    @NotNull
    public DockerApplicationRuntime asDockerRuntime() {
        ComposeServiceRuntime composeServiceRuntime = this;
        if (composeServiceRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(5);
        }
        return composeServiceRuntime;
    }

    @Override
    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatus;
    }

    @Override
    public void childAdded(@NotNull DockerApplicationRuntime child) {
        if (child == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(6);
        }
        this.myContainers.put(child.getApplicationName(), child);
    }

    @Override
    public void childRemoved(@NotNull DockerApplicationRuntime child) {
        if (child == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(7);
        }
        this.myContainers.remove(child.getApplicationName());
    }

    void addContainer(@NotNull DockerApplicationRuntime container) {
        if (container == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(8);
        }
        container.setParent(this);
    }

    @Nullable
    public DockerRuntimesManagerService.ComposeServiceStatus getContainerStatus() {
        if (this.myContainers.isEmpty()) {
            return null;
        }
        List statuses = this.myContainers.values().stream().map(DockerApplicationRuntime::getStatus).filter(Objects::nonNull).collect(Collectors.toList());
        if (statuses.isEmpty()) {
            return null;
        }
        return statuses.stream().anyMatch(DeploymentStatus.DEPLOYED::equals) ? DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED : DockerRuntimesManagerService.ComposeServiceStatus.STOPPED;
    }

    @NotNull
    public final String getServiceName() {
        String string = this.myServiceName;
        if (string == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public ComposeApplicationRuntime getParent() {
        ComposeApplicationRuntime parent = (ComposeApplicationRuntime)super.getParent();
        assert (parent != null);
        ComposeApplicationRuntime composeApplicationRuntime = parent;
        if (composeApplicationRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(10);
        }
        return composeApplicationRuntime;
    }

    @NotNull
    private RemoteDockerRuntime requireRuntimeHelper() throws ServerRuntimeException {
        ComposeApplicationRuntime parent = this.getParent();
        RemoteDockerRuntime helper = parent.getRuntimeHelper();
        if (helper == null) {
            throw new ServerRuntimeException("Can't find configuration for compose project `" + parent.getComposeProjectName() + "`");
        }
        RemoteDockerRuntime remoteDockerRuntime = helper;
        if (remoteDockerRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(11);
        }
        return remoteDockerRuntime;
    }

    public void scaleService(int number) throws ServerRuntimeException {
        number = Math.max(number, 0);
        ComposeApplicationRuntime parent = this.getParent();
        DockerComposeUpCliBuilder upCommand = ((DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(this.requireRuntimeHelper()).withFiles(parent.getComposeFilePaths())).withDetached(true).withServices(this.myServiceName).withServiceScaled(this.myServiceName, number);
        parent.executeCli(upCommand);
    }

    public void startService() throws ServerRuntimeException {
        ComposeApplicationRuntime parent = this.getParent();
        DockerComposeStartCliBuilder startCommand = ((DockerComposeStartCliBuilder)DockerComposeCliUtil.buildStartCommand(this.requireRuntimeHelper()).withFiles(parent.getComposeFilePaths())).withServices(this.myServiceName);
        parent.executeCli(startCommand);
    }

    public void stopService() throws ServerRuntimeException {
        ComposeApplicationRuntime parent = this.getParent();
        DockerComposeStopCliBuilder stopCommand = ((DockerComposeStopCliBuilder)DockerComposeCliUtil.buildStopCommand(this.requireRuntimeHelper()).withFiles(parent.getComposeFilePaths())).withServices(this.myServiceName);
        parent.executeCli(stopCommand);
    }

    @Override
    @Nullable
    protected DockerApplicationRuntime.DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        ComposeNavigatableHelper helper;
        if (project == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(12);
        }
        if ((helper = ComposeNavigatableHelper.getInstance()) == null) {
            return this.getParent().computeRuntimeNavigatable(project);
        }
        final PsiElement composeService = this.getParent().getComposeFiles().stream().map(file2 -> helper.findComposeService(project, (File)file2, this.getServiceName())).filter(Objects::nonNull).reduce((prev, next) -> next).orElse(null);
        return composeService == null ? null : new DockerApplicationRuntime.DockerRuntimeNavigatable(){

            @Override
            @NotNull
            public Navigatable getNavigatable() {
                Navigatable navigatable = ComposeServiceRuntime.toNavigatable(composeService);
                if (navigatable == null) {
                    1.$$$reportNull$$$0(0);
                }
                return navigatable;
            }

            @Override
            @Nullable
            public VirtualFile getVirtualFile() {
                return PsiUtilCore.getVirtualFile((PsiElement)composeService);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/runtimes/ComposeServiceRuntime$1", "getNavigatable"));
            }
        };
    }

    private static Navigatable toNavigatable(@NotNull PsiElement psi) {
        if (psi == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(13);
        }
        if (psi instanceof Navigatable) {
            return (Navigatable)psi;
        }
        return Optional.of(psi.getContainingFile()).map(PsiFile::getVirtualFile).map(vFile -> PsiNavigationSupport.getInstance().createNavigatable(psi.getProject(), vFile, psi.getTextOffset())).orElse(null);
    }

    public CloudNotifier getCloudNotifier() {
        return ComposeApplicationRuntime.COMPOSE_NOTIFIER;
    }

    @Override
    public String toString() {
        return "@" + Integer.toHexString(this.hashCode()) + " id: " + this.getApplicationName() + ", [SRV]";
    }

    public DockerApplicationRuntime[] getContainers() {
        return this.myContainers.values().toArray(new DockerApplicationRuntime[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRuntime";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeServiceRuntime";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeServiceRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "asDockerRuntime";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRuntimeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "childAdded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "childRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addContainer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeRuntimeNavigatable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toNavigatable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

