/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry.search;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellij.docker.registry.search.DockerHubRepository;
import com.intellij.docker.registry.search.DockerOauthHelper;
import com.intellij.docker.registry.search.DockerSearch;
import com.intellij.docker.registry.search.DockerSearch$DockerSearchResultImpl$WhenMappings;
import com.intellij.docker.registry.search.DockerSearchContext;
import com.intellij.docker.registry.search.DockerSearchResult;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import icons.DockerIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000  2\u00020\u0001:\u0004 !\"#B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00060\u00142\u0006\u0010\u0016\u001a\u00020\u0017J$\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00060\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00060\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017J\u0014\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00060\u0014H\u0002J\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00060\u00142\u0006\u0010\u001e\u001a\u00020\u0017J\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00060\u00142\u0006\u0010\u001b\u001a\u00020\u0017R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\tR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/intellij/docker/registry/search/DockerSearch;", "", "context", "Lcom/intellij/docker/registry/search/DockerSearchContext;", "(Lcom/intellij/docker/registry/search/DockerSearchContext;)V", "_libraryImages", "", "Lcom/intellij/docker/registry/search/DockerHubRepository;", "get_libraryImages", "()Ljava/util/List;", "libraryImages", "getLibraryImages", "libraryImages$delegate", "Lkotlin/Lazy;", "oauth", "Lcom/intellij/docker/registry/search/DockerOauthHelper;", "getOauth", "()Lcom/intellij/docker/registry/search/DockerOauthHelper;", "oauth$delegate", "listImageTags", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/registry/search/DockerSearchResult;", "image", "", "imageFqn", "oauthToken", "listImagesV1", "prefix", "listLibraryImages", "listRepositoriesInNamespace", "account", "searchForCompletions", "Companion", "DockerSearchResultImpl", "SearchResultV1", "TagListV2", "intellij.clouds.docker"})
public final class DockerSearch {
    private final Lazy oauth$delegate;
    private final Lazy libraryImages$delegate;
    private final DockerSearchContext context;
    private static final Lazy LOG$delegate;
    public static final Companion Companion;

    private final DockerOauthHelper getOauth() {
        Lazy lazy = this.oauth$delegate;
        DockerSearch dockerSearch = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DockerOauthHelper)lazy.getValue();
    }

    private final List<DockerHubRepository> getLibraryImages() {
        Lazy lazy = this.libraryImages$delegate;
        DockerSearch dockerSearch = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<DockerHubRepository> get_libraryImages() {
        return this.getLibraryImages();
    }

    @NotNull
    public final CompletableFuture<List<DockerSearchResult>> searchForCompletions(@NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        CharSequence charSequence = prefix;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return this.listLibraryImages();
        }
        if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)":", (boolean)false, (int)2, null)) {
            String image = StringsKt.substringBeforeLast$default((String)prefix, (String)":", null, (int)2, null);
            return this.listImageTags(image);
        }
        if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)"/", (boolean)false, (int)2, null)) {
            String namespace = StringsKt.substringBeforeLast$default((String)prefix, (String)"/", null, (int)2, null);
            return this.listRepositoriesInNamespace(namespace);
        }
        return this.listImagesV1(prefix);
    }

    @NotNull
    public final CompletableFuture<List<DockerSearchResult>> listImageTags(@NotNull String image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        CharSequence charSequence = image;
        boolean bl = false;
        if (charSequence.length() == 0 || StringsKt.contains$default((CharSequence)image, (CharSequence)":", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)image, (CharSequence)"@", (boolean)false, (int)2, null)) {
            return DockerSearch.Companion.emptyListLater();
        }
        String imageFqn = StringsKt.contains$default((CharSequence)image, (CharSequence)"/", (boolean)false, (int)2, null) ? image : "library/" + image;
        CompletionStage completionStage = DockerOauthHelper.obtainTokenLater$intellij_clouds_docker$default(this.getOauth(), imageFqn, null, 2, null).thenCompose(new Function<T, CompletionStage<U>>(this, imageFqn){
            final /* synthetic */ DockerSearch this$0;
            final /* synthetic */ String $imageFqn;

            @NotNull
            public final CompletableFuture<List<DockerSearchResult>> apply(DockerOauthHelper.OauthToken it) {
                return DockerSearch.access$listImageTags(this.this$0, this.$imageFqn, it.getToken());
            }
            {
                this.this$0 = dockerSearch;
                this.$imageFqn = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"oauth.obtainTokenLater(i\u2026imageFqn, it.token)\n    }");
        return completionStage;
    }

    private final CompletableFuture<List<DockerSearchResult>> listImageTags(String imageFqn, String oauthToken) {
        Request request;
        Request request2 = request = new Request.Builder().url("https://registry-1.docker.io/v2/" + imageFqn + "/tags/list").addHeader("Accept", "application/json").addHeader("Authorization", "Bearer " + oauthToken).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
        return DockerSearch.Companion.onBadResponseCode(this.context.executeLater$intellij_clouds_docker(request2, (Function1)new Function1<ResponseBody, List<? extends DockerSearchResult>>(this, imageFqn){
            final /* synthetic */ DockerSearch this$0;
            final /* synthetic */ String $imageFqn;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<DockerSearchResult> invoke(@NotNull ResponseBody it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DockerSearchContext dockerSearchContext = DockerSearch.access$getContext$p(this.this$0);
                String string = it.string();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.string()");
                Object object = (TagListV2)dockerSearchContext.parseJSON$intellij_clouds_docker(string, Reflection.getOrCreateKotlinClass(TagListV2.class));
                if (object == null || (object = ((TagListV2)object).getTags()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object tagList = object;
                Iterable $this$map$iv = (Iterable)tagList;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    DockerSearchResult dockerSearchResult = new DockerSearchResultImpl(this.$imageFqn + ':' + (String)it2, null, DockerSearchResult.Kind.TAG);
                    collection.add(dockerSearchResult);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = dockerSearch;
                this.$imageFqn = string;
                super(1);
            }
        }), listImageTags.3.INSTANCE);
    }

    @NotNull
    public final CompletableFuture<List<DockerSearchResult>> listImagesV1(@Nullable String prefix) {
        HttpUrl url;
        CharSequence charSequence = prefix;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return this.listLibraryImages();
        }
        if (prefix.length() < 2) {
            CompletionStage completionStage = this.listLibraryImages().thenApply(new Function<T, U>(prefix){
                final /* synthetic */ String $prefix;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<DockerSearchResult> apply(List<? extends DockerSearchResult> list) {
                    void $this$filterTo$iv$iv;
                    List<? extends DockerSearchResult> list2 = list;
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"list");
                    Iterable $this$filter$iv = list2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        DockerSearchResult it = (DockerSearchResult)element$iv$iv;
                        boolean bl = false;
                        if (!StringsKt.contains$default((CharSequence)it.getLookupText(), (CharSequence)this.$prefix, (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$prefix = string;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"listLibraryImages().then\u2026Text.contains(prefix) } }");
            return completionStage;
        }
        HttpUrl httpUrl = url = HttpUrl.parse((String)"https://registry.hub.docker.com/v1/search").newBuilder().addQueryParameter("q", prefix).addQueryParameter("n", "100").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"url");
        return DockerSearch.Companion.onBadResponseCode(this.context.executeLater$intellij_clouds_docker(DockerSearch.Companion.request(httpUrl), (Function1)new Function1<ResponseBody, List<? extends DockerSearchResult>>(this){
            final /* synthetic */ DockerSearch this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<DockerSearchResult> invoke(@NotNull ResponseBody it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String response = it.string();
                DockerSearchContext dockerSearchContext = DockerSearch.access$getContext$p(this.this$0);
                String string = response;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response");
                Object object = (SearchResultV1.SinglePage)dockerSearchContext.parseJSON$intellij_clouds_docker(string, Reflection.getOrCreateKotlinClass(SearchResultV1.SinglePage.class));
                if (object == null || (object = ((SearchResultV1.SinglePage)object).getResults()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object v1Results = object;
                Iterable $this$map$iv = (Iterable)v1Results;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    SearchResultV1 searchResultV1 = (SearchResultV1)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    DockerSearchResult dockerSearchResult = it2.toDockerSearchResult();
                    collection.add(dockerSearchResult);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = dockerSearch;
                super(1);
            }
        }), listImagesV1.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<List<DockerSearchResult>> listLibraryImages() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getLibraryImages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DockerHubRepository dockerHubRepository = (DockerHubRepository)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DockerSearchResult dockerSearchResult = it.toDockerSearchResult();
            collection.add(dockerSearchResult);
        }
        CompletableFuture<List<DockerSearchResult>> completableFuture = CompletableFuture.completedFuture((List)destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.comple\u2026toDockerSearchResult() })");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<List<DockerSearchResult>> listRepositoriesInNamespace(@NotNull String account) {
        HttpUrl url;
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        CharSequence charSequence = account;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return DockerSearch.Companion.emptyListLater();
        }
        String namespace = StringsKt.removeSuffix((String)account, (CharSequence)"/");
        if (StringsKt.contains$default((CharSequence)namespace, (CharSequence)"/", (boolean)false, (int)2, null)) {
            return DockerSearch.Companion.emptyListLater();
        }
        HttpUrl httpUrl = url = HttpUrl.parse((String)("https://hub.docker.com/v2/repositories/" + namespace + '/')).newBuilder().addQueryParameter("page_size", "200").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpUrl, (String)"url");
        return DockerSearch.Companion.onBadResponseCode(this.context.executeLater$intellij_clouds_docker(DockerSearch.Companion.request(httpUrl), (Function1)new Function1<ResponseBody, List<? extends DockerSearchResult>>(this){
            final /* synthetic */ DockerSearch this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<DockerSearchResult> invoke(@NotNull ResponseBody it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String response = it.string();
                DockerSearchContext dockerSearchContext = DockerSearch.access$getContext$p(this.this$0);
                String string = response;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response");
                Object object = (DockerHubRepository.SinglePage)dockerSearchContext.parseJSON$intellij_clouds_docker(string, Reflection.getOrCreateKotlinClass(DockerHubRepository.SinglePage.class));
                if (object == null || (object = ((DockerHubRepository.SinglePage)object).getPageContents()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object images = object;
                Iterable $this$map$iv = (Iterable)images;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    DockerHubRepository dockerHubRepository = (DockerHubRepository)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    DockerSearchResult dockerSearchResult = it2.toDockerSearchResult();
                    collection.add(dockerSearchResult);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = dockerSearch;
                super(1);
            }
        }), listRepositoriesInNamespace.2.INSTANCE);
    }

    public DockerSearch(@NotNull DockerSearchContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.oauth$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DockerOauthHelper>(this){
            final /* synthetic */ DockerSearch this$0;

            @NotNull
            public final DockerOauthHelper invoke() {
                return new DockerOauthHelper(null, DockerSearch.access$getContext$p(this.this$0), 1, null);
            }
            {
                this.this$0 = dockerSearch;
                super(0);
            }
        }));
        this.libraryImages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<DockerHubRepository>>(this){
            final /* synthetic */ DockerSearch this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<DockerHubRepository> invoke() {
                void var1_3;
                boolean bl = false;
                List result = new ArrayList<E>();
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new String[]{"/hub/docker-hub-library.page1.json", "/hub/docker-hub-library.page2.json"});
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    DockerHubRepository.SinglePage next = (DockerHubRepository.SinglePage)DockerSearch.access$getContext$p(this.this$0).parseJSONResource$intellij_clouds_docker(it, Reflection.getOrCreateKotlinClass(DockerHubRepository.SinglePage.class));
                    Object object = next;
                    result.addAll(object != null && (object = ((DockerHubRepository.SinglePage)object).getPageContents()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
                }
                return var1_3;
            }
            {
                this.this$0 = dockerSearch;
                super(0);
            }
        }));
    }

    public /* synthetic */ DockerSearch(DockerSearchContext dockerSearchContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerSearchContext = new DockerSearchContext(null, null, 3, null);
        }
        this(dockerSearchContext);
    }

    public DockerSearch() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    }

    public static final /* synthetic */ CompletableFuture access$listImageTags(DockerSearch $this, String imageFqn, String oauthToken) {
        return $this.listImageTags(imageFqn, oauthToken);
    }

    public static final /* synthetic */ DockerSearchContext access$getContext$p(DockerSearch $this) {
        return $this.context;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/registry/search/DockerSearch$TagListV2;", "", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "tags", "", "getTags", "()Ljava/util/List;", "setTags", "(Ljava/util/List;)V", "intellij.clouds.docker"})
    private static final class TagListV2 {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="tags")
        @Nullable
        private List<String> tags;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final List<String> getTags() {
            return this.tags;
        }

        public final void setTags(@Nullable List<String> list) {
            this.tags = list;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR \u0010\u0010\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\bR\u001e\u0010\u0013\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/registry/search/DockerSearch$SearchResultV1;", "", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "isOfficial", "", "()Z", "setOfficial", "(Z)V", "isTrusted", "setTrusted", "name", "getName", "setName", "starCount", "", "getStarCount", "()I", "setStarCount", "(I)V", "toDockerSearchResult", "Lcom/intellij/docker/registry/search/DockerSearchResult;", "SinglePage", "intellij.clouds.docker"})
    private static final class SearchResultV1 {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="star_count")
        private int starCount;
        @JsonProperty(value="is_official")
        private boolean isOfficial;
        @JsonProperty(value="is_trusted")
        private boolean isTrusted;
        @JsonProperty(value="description")
        @Nullable
        private String description;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        public final int getStarCount() {
            return this.starCount;
        }

        public final void setStarCount(int n) {
            this.starCount = n;
        }

        public final boolean isOfficial() {
            return this.isOfficial;
        }

        public final void setOfficial(boolean bl) {
            this.isOfficial = bl;
        }

        public final boolean isTrusted() {
            return this.isTrusted;
        }

        public final void setTrusted(boolean bl) {
            this.isTrusted = bl;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        @NotNull
        public final DockerSearchResult toDockerSearchResult() {
            String string = this.name;
            if (string == null) {
                string = "";
            }
            return new DockerSearchResultImpl(string, this.description, DockerSearchResult.Kind.IMAGE);
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR \u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/docker/registry/search/DockerSearch$SearchResultV1$SinglePage;", "", "()V", "page", "", "getPage", "()I", "setPage", "(I)V", "pageSize", "getPageSize", "setPageSize", "pagesCount", "getPagesCount", "setPagesCount", "query", "", "getQuery", "()Ljava/lang/String;", "setQuery", "(Ljava/lang/String;)V", "results", "", "Lcom/intellij/docker/registry/search/DockerSearch$SearchResultV1;", "getResults", "()Ljava/util/List;", "setResults", "(Ljava/util/List;)V", "totalCount", "getTotalCount", "setTotalCount", "intellij.clouds.docker"})
        public static final class SinglePage {
            @JsonProperty(value="num_pages")
            private int pagesCount;
            @JsonProperty(value="num_results")
            private int totalCount;
            @JsonProperty(value="page")
            private int page;
            @JsonProperty(value="page_size")
            private int pageSize;
            @JsonProperty(value="query")
            @Nullable
            private String query;
            @JsonProperty(value="results")
            @Nullable
            private List<SearchResultV1> results;

            public final int getPagesCount() {
                return this.pagesCount;
            }

            public final void setPagesCount(int n) {
                this.pagesCount = n;
            }

            public final int getTotalCount() {
                return this.totalCount;
            }

            public final void setTotalCount(int n) {
                this.totalCount = n;
            }

            public final int getPage() {
                return this.page;
            }

            public final void setPage(int n) {
                this.page = n;
            }

            public final int getPageSize() {
                return this.pageSize;
            }

            public final void setPageSize(int n) {
                this.pageSize = n;
            }

            @Nullable
            public final String getQuery() {
                return this.query;
            }

            public final void setQuery(@Nullable String string) {
                this.query = string;
            }

            @Nullable
            public final List<SearchResultV1> getResults() {
                return this.results;
            }

            public final void setResults(@Nullable List<SearchResultV1> list) {
                this.results = list;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/registry/search/DockerSearch$DockerSearchResultImpl;", "Lcom/intellij/docker/registry/search/DockerSearchResult;", "lookupText", "", "description", "kind", "Lcom/intellij/docker/registry/search/DockerSearchResult$Kind;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/docker/registry/search/DockerSearchResult$Kind;)V", "getDescription", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getKind", "()Lcom/intellij/docker/registry/search/DockerSearchResult$Kind;", "getLookupText", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clouds.docker"})
    public static final class DockerSearchResultImpl
    implements DockerSearchResult {
        @NotNull
        private final String lookupText;
        @Nullable
        private final String description;
        @NotNull
        private final DockerSearchResult.Kind kind;

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon;
            switch (DockerSearch$DockerSearchResultImpl$WhenMappings.$EnumSwitchMapping$0[this.getKind().ordinal()]) {
                case 1: {
                    Icon icon2 = DockerIcons.SingleImage;
                    icon = icon2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"DockerIcons.SingleImage");
                    break;
                }
                case 2: {
                    Icon icon3 = DockerIcons.SingleImage;
                    icon = icon3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"DockerIcons.SingleImage");
                    break;
                }
                case 3: {
                    Icon icon4 = AllIcons.Nodes.Tag;
                    icon = icon4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Nodes.Tag");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return icon;
        }

        @Override
        @NotNull
        public String getLookupText() {
            return this.lookupText;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public DockerSearchResult.Kind getKind() {
            return this.kind;
        }

        public DockerSearchResultImpl(@NotNull String lookupText, @Nullable String description, @NotNull DockerSearchResult.Kind kind) {
            Intrinsics.checkParameterIsNotNull((Object)lookupText, (String)"lookupText");
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            this.lookupText = lookupText;
            this.description = description;
            this.kind = kind;
        }

        @NotNull
        public final String component1() {
            return this.getLookupText();
        }

        @Nullable
        public final String component2() {
            return this.getDescription();
        }

        @NotNull
        public final DockerSearchResult.Kind component3() {
            return this.getKind();
        }

        @NotNull
        public final DockerSearchResultImpl copy(@NotNull String lookupText, @Nullable String description, @NotNull DockerSearchResult.Kind kind) {
            Intrinsics.checkParameterIsNotNull((Object)lookupText, (String)"lookupText");
            Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
            return new DockerSearchResultImpl(lookupText, description, kind);
        }

        public static /* synthetic */ DockerSearchResultImpl copy$default(DockerSearchResultImpl dockerSearchResultImpl, String string, String string2, DockerSearchResult.Kind kind, int n, Object object) {
            if ((n & 1) != 0) {
                string = dockerSearchResultImpl.getLookupText();
            }
            if ((n & 2) != 0) {
                string2 = dockerSearchResultImpl.getDescription();
            }
            if ((n & 4) != 0) {
                kind = dockerSearchResultImpl.getKind();
            }
            return dockerSearchResultImpl.copy(string, string2, kind);
        }

        @NotNull
        public String toString() {
            return "DockerSearchResultImpl(lookupText=" + this.getLookupText() + ", description=" + this.getDescription() + ", kind=" + (Object)((Object)this.getKind()) + ")";
        }

        public int hashCode() {
            String string = this.getLookupText();
            String string2 = this.getDescription();
            DockerSearchResult.Kind kind = this.getKind();
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (kind != null ? ((Object)((Object)kind)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DockerSearchResultImpl)) break block3;
                    DockerSearchResultImpl dockerSearchResultImpl = (DockerSearchResultImpl)object;
                    if (!Intrinsics.areEqual((Object)this.getLookupText(), (Object)dockerSearchResultImpl.getLookupText()) || !Intrinsics.areEqual((Object)this.getDescription(), (Object)dockerSearchResultImpl.getDescription()) || !Intrinsics.areEqual((Object)((Object)this.getKind()), (Object)((Object)dockerSearchResultImpl.getKind()))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b0\n\"\u0004\b\u0000\u0010\fH\u0002J,\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/registry/search/DockerSearch$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "emptyListLater", "Ljava/util/concurrent/CompletableFuture;", "", "T", "onBadResponseCode", "onBadResponseValue", "Lkotlin/Function0;", "request", "Lokhttp3/Request;", "Lokhttp3/HttpUrl;", "intellij.clouds.docker"})
    public static final class Companion {
        private final <T> CompletableFuture<List<T>> emptyListLater() {
            CompletableFuture<List<T>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(emptyList())");
            return completableFuture;
        }

        private final Request request(@NotNull HttpUrl $this$request) {
            Request request = new Request.Builder().url($this$request).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Builder().url(this).build()");
            return request;
        }

        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        private final <T> CompletableFuture<T> onBadResponseCode(@NotNull CompletableFuture<T> $this$onBadResponseCode, Function0<? extends T> onBadResponseValue) {
            CompletionStage completionStage = $this$onBadResponseCode.exceptionally(new Function<Throwable, T>(onBadResponseValue){
                final /* synthetic */ Function0 $onBadResponseValue;

                public final T apply(Throwable ex) {
                    Throwable throwable = ex;
                    if (!(throwable instanceof DockerSearchContext.BadResponseException)) {
                        if (throwable instanceof CompletionException) {
                            throw ex;
                        }
                        if (throwable instanceof Error) {
                            throw ex;
                        }
                        throw (Throwable)new CompletionException(ex);
                    }
                    com.intellij.docker.registry.search.DockerSearch$Companion.access$getLOG$p(DockerSearch.Companion).debug(ex);
                    return (T)this.$onBadResponseValue.invoke();
                }
                {
                    this.$onBadResponseValue = function0;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"this.exceptionally { ex \u2026ion(ex)\n        }\n      }");
            return completionStage;
        }

        private Companion() {
        }

        public static final /* synthetic */ Logger access$getLOG$p(Companion $this) {
            return $this.getLOG();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

