/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.DockerRepoTagsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerSingletonDeploymentSourceType
extends SingletonDeploymentSourceType {
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9_.-]*");
    @Nls
    protected static final String NAME_PIECE_UNKNOWN = "<unknown>";

    protected DockerSingletonDeploymentSourceType(@NotNull String id, @Nls @NotNull String presentableName, @NotNull Icon icon) {
        if (id == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(2);
        }
        super(id, presentableName, icon);
    }

    @Nullable
    public String suggestConfigurationName(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public abstract String getPresentableDeploymentName(@NotNull DockerDeploymentConfiguration var1, @Nullable DockerApplicationRuntime var2);

    @NotNull
    public static String getPresentableContainerNamePiece(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerApplicationRuntime runtime) {
        if (configuration == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(4);
        }
        String containerName = runtime != null ? runtime.getContainerName() : configuration.getContainerName();
        String string = StringUtil.isEmpty((String)containerName) ? NAME_PIECE_UNKNOWN : containerName;
        if (string == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void checkDeploymentConfiguration(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        if (project == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(7);
        }
    }

    public static void checkImageTagFormat(@NotNull DockerDeploymentConfiguration configuration, boolean atMaxOne, boolean allowDigest) throws RuntimeConfigurationException {
        String[] allTags;
        if (configuration == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(8);
        }
        if ((allTags = configuration.getSeparateImageTags()).length == 0) {
            return;
        }
        LinkedList<DockerRepoTag> validTags = new LinkedList<DockerRepoTag>();
        boolean allValid = true;
        for (String nextTag : allTags) {
            DockerRepoTag parsedTag = DockerRepoTag.fromString((String)nextTag);
            DockerRepoTag validTag = DockerRepoTagsKt.validDockerRepoTagFromString((String)nextTag);
            if (!allowDigest) {
                validTag.setDigest(null);
            }
            allValid &= parsedTag.getFullyQualifiedReference().equals(validTag.getFullyQualifiedReference());
            validTags.add(validTag);
        }
        if (atMaxOne && validTags.size() > 1) {
            throw new RuntimeConfigurationWarning(DockerBundle.message("SingletonDeploymentSourceType.error.image.tag.atMaxOne", new Object[0]), () -> configuration.setAllImageTagsJoined(((DockerRepoTag)validTags.get(0)).getFullyQualifiedReference()));
        }
        if (!allValid) {
            String fixedJoin = StringUtil.join(validTags, DockerRepoTag::getFullyQualifiedReference, (String)", ");
            throw new RuntimeConfigurationWarning(DockerBundle.message("SingletonDeploymentSourceType.error.image.tag.format", new Object[0]), () -> configuration.setAllImageTagsJoined(fixedJoin));
        }
    }

    protected static void checkContainerNameFormat(@NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        String containerName;
        if (configuration == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmptyOrSpaces((String)(containerName = configuration.getContainerName()))) {
            return;
        }
        if (!CONTAINER_NAME_PATTERN.matcher(containerName = containerName.trim()).matches()) {
            String withoutBadStart = containerName.replaceAll("^[^a-zA-Z0-9]+", "");
            String fixed = withoutBadStart.replaceAll("[^a-zA-Z0-9_.-]+", "_");
            RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning(DockerBundle.message("SingletonDeploymentSourceType.error.container.name.format", new Object[0]));
            if (!fixed.isEmpty() && CONTAINER_NAME_PATTERN.matcher(fixed).matches()) {
                warning.setQuickFix(() -> configuration.setContainerName(fixed));
            }
            throw warning;
        }
    }

    @NotNull
    protected static String lastTwoSegments(@NotNull String systemIndependentPath) {
        if (systemIndependentPath == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(10);
        }
        String SEPARATOR = "/";
        int lastSegmentStart = systemIndependentPath.lastIndexOf("/");
        if (lastSegmentStart <= 0) {
            String string = systemIndependentPath;
            if (string == null) {
                DockerSingletonDeploymentSourceType.$$$reportNull$$$0(11);
            }
            return string;
        }
        int nextToLast = systemIndependentPath.lastIndexOf("/", lastSegmentStart - 1);
        String string = nextToLast < 0 ? systemIndependentPath : systemIndependentPath.substring(nextToLast + "/".length());
        if (string == null) {
            DockerSingletonDeploymentSourceType.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerSingletonDeploymentSourceType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemIndependentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerSingletonDeploymentSourceType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableContainerNamePiece";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "lastTwoSegments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableContainerNamePiece";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkImageTagFormat";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkContainerNameFormat";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lastTwoSegments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

