/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.ContainerActionBase;
import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.exec.ExecCommand;
import com.intellij.docker.exec.ExecCommandManager;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.docker.view.details.LoggingHandlerTab;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecInContainerAction
extends ContainerActionBase {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DockerActionUtils.LoggingActionHelper helper;
        if (e == null) {
            ExecInContainerAction.$$$reportNull$$$0(0);
        }
        if ((helper = DockerActionUtils.getLoggingActionHelper(e)) == null || helper.node.getDetails() == null) {
            return;
        }
        ListPopup popup = new Case(helper).createPopup();
        popup.showInBestPositionFor(e.getDataContext());
    }

    @Override
    protected boolean isEnabled(DeploymentNode node) {
        Deployment deployment = ApplicationActionUtils.getDeployment((DeploymentNode)node);
        return deployment != null && deployment.getStatus() == DeploymentStatus.DEPLOYED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/action/ExecInContainerAction", "actionPerformed"));
    }

    private static class Case {
        private final DockerActionUtils.LoggingActionHelper myHelper;
        private static final InputValidator VALIDATOR = new InputValidator(){

            public boolean checkInput(String inputString) {
                return this.hasSomething(inputString);
            }

            public boolean canClose(String inputString) {
                return this.hasSomething(inputString);
            }

            private boolean hasSomething(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString);
            }
        };

        Case(DockerActionUtils.LoggingActionHelper helper) {
            this.myHelper = helper;
        }

        public ListPopup createPopup() {
            ArrayList commands = new ArrayList(ContainerUtil.map(ExecCommandManager.getInstance(this.myHelper.project).getImageCommands(this.myHelper.applicationRuntime.getImageId()), Optional::ofNullable));
            commands.add(Optional.empty());
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Optional<ExecCommand>>(DockerBundle.message("ExecInContainerAction.ListPopup.title", new Object[0]), commands){

                public Icon getIconFor(Optional<ExecCommand> value) {
                    return null;
                }

                @NotNull
                public String getTextFor(Optional<ExecCommand> value) {
                    String string = value.map(ExecCommand::getCommand).orElse(DockerBundle.message("ExecInContainerAction.ListPopup.textFor.create", new Object[0]));
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep<?> onChosen(Optional<ExecCommand> selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> this.createAndRunExecSession(selectedValue.orElse(null)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/action/ExecInContainerAction$Case$2", "getTextFor"));
                }
            });
        }

        private void createAndRunExecSession(@Nullable ExecCommand storedExecCommand) {
            String command;
            if (storedExecCommand == null) {
                command = Messages.showInputDialog((Project)this.myHelper.project, (String)DockerBundle.message("ExecInContainerAction.Case.Dialog.message", new Object[0]), (String)DockerBundle.message("ExecInContainerAction.Case.Dialog.title", new Object[0]), null, null, (InputValidator)VALIDATOR);
                if (StringUtil.isEmptyOrSpaces((String)command)) {
                    return;
                }
                ExecCommandManager.getInstance(this.myHelper.project).addCommand(this.myHelper.applicationRuntime.getImageId(), command);
            } else {
                command = storedExecCommand.getCommand();
            }
            if (StringUtil.isEmptyOrSpaces((String)command)) {
                return;
            }
            ITabManager tabManager = this.myHelper.node.getDetailsTabs();
            if (tabManager == null) {
                return;
            }
            String title = Case.getLogTitle(command);
            LoggingHandlerTab.Immediate tab = new LoggingHandlerTab.Immediate(tabManager, title, true, title);
            tabManager.addTab(tab);
            Content content = ((DockerDetailsTab)tab).createContent();
            Runnable requestFocus = () -> tabManager.getContentManager().setSelectedContent(content, true);
            this.myHelper.applicationRuntime.exec(this.myHelper.project, command, title, () -> UIUtil.invokeLaterIfNeeded((Runnable)requestFocus));
        }

        @Nls
        @NotNull
        private static String getLogTitle(@NotNull String command) {
            if (command == null) {
                Case.$$$reportNull$$$0(0);
            }
            String string = DockerBundle.message("ExecInContainerAction.tab.title", command);
            if (string == null) {
                Case.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/action/ExecInContainerAction$Case";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/action/ExecInContainerAction$Case";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLogTitle";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

