/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.IntelliJLogSettings;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.machine.DockerConnectionInfo;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineException;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.RegistryAuthCallback;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.docker.runtimes.DockerRuntimesCache;
import com.intellij.docker.runtimes.DockerRuntimesManagerImpl;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerServerRuntimeInstance
extends CloudServerRuntimeInstance<DockerDeploymentConfiguration, DockerAgent, DockerCloudConfiguration> {
    public static final Topic<DockerServerListener> EVENTS_TOPIC = Topic.create((String)"docker events", DockerServerListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_CHILDREN);
    private static final Logger LOG = Logger.getInstance(DockerServerRuntimeInstance.class);
    private static final String SPECIFICS_MODULE_NAME = "intellij.clouds.docker.agent.impl.rt";
    private static final String SPECIFICS_JAR_PATH = "specifics/dockerSpecifics.jar";
    private DockerRuntimesCache myRuntimesCache;

    public DockerServerRuntimeInstance(@NotNull DockerCloudConfiguration configuration, @NotNull ServerTaskExecutor taskExecutor, @NotNull List<File> libraryFiles) throws Exception {
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(0);
        }
        if (taskExecutor == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(1);
        }
        if (libraryFiles == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(2);
        }
        super((CloudAgentConfigBase)configuration, taskExecutor, libraryFiles, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, DockerAgent.class, "com.intellij.docker.agent.DockerAgentImpl");
    }

    public AgentTaskExecutor getDockerAgentTaskExecutor() {
        return super.getAgentTaskExecutor();
    }

    public void connect(final ServerConnector.ConnectionCallback<DockerDeploymentConfiguration> callback) {
        try {
            DockerServerRuntimeInstance.updateDockerConnectionParameters((DockerCloudConfiguration)this.getConfiguration());
        }
        catch (DockerMachineException e) {
            callback.errorOccurred(e.getMessage());
        }
        CloudAgentLogger agentLogger = DockerServerRuntimeInstance.createAgentLogger();
        this.getAgentTaskExecutor().execute(() -> {
            ((DockerAgent)this.getAgent()).setLogSettings(IntelliJLogSettings.collect());
            ((DockerAgent)this.getAgent()).connect((DockerAgentConfig)this.getConfiguration(), agentLogger, (CloudAgentErrorHandler)this.getAgentTaskExecutor());
            this.myRuntimesCache = this.getRuntimesManager().serverConnected(this);
            return null;
        }, (CallbackWrapper)new CallbackWrapper<Void>(){

            public void onSuccess(Void result) {
                ((DockerAgent)DockerServerRuntimeInstance.this.getAgent()).attachEventListener(x$0 -> DockerServerRuntimeInstance.this.onDockerEvent(x$0));
                callback.connected((ServerRuntimeInstance)DockerServerRuntimeInstance.this);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    private static void updateDockerConnectionParameters(@NotNull DockerCloudConfiguration configuration) {
        String machineName;
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)(machineName = configuration.getMachine()))) {
            DockerConnectionInfo connectionInfo = DockerMachine.currentDockerMachine().getDockerConnectionInfo(machineName);
            configuration.setApiUrl(connectionInfo.getApiUrl());
            configuration.setCertificatesPath(connectionInfo.getCertificatesPath());
        }
    }

    public void deploy(@NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(4);
        }
        if (logManager == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(6);
        }
        this.getTaskExecutor().submit(() -> {
            DockerSingletonDeploymentSourceType sourceType = (DockerSingletonDeploymentSourceType)task.getSource().getType();
            if (sourceType instanceof DockerComposeDeploymentSourceType) {
                ComposeDeploymentRuntime composeDeploymentRuntime = this.myRuntimesCache.createComposeRuntime(task, logManager);
                composeDeploymentRuntime.deploy(callback);
            } else {
                String displayName = sourceType.getPresentableDeploymentName((DockerDeploymentConfiguration)task.getConfiguration(), null);
                DockerDeploymentRuntime deploymentRuntime = this.myRuntimesCache.createDeploymentRuntime(task, logManager);
                deploymentRuntime.deploy(callback, displayName);
            }
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getRuntimesManager().serverDisconnected(this);
        this.myRuntimesCache = null;
        this.getTaskExecutor().submit(() -> ((DockerAgent)this.getAgent()).disconnect());
    }

    private boolean isConnected() {
        return this.myRuntimesCache != null;
    }

    private void onDockerEvent(DockerEvent agentEvent) {
        if (this.isConnected()) {
            ((DockerServerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EVENTS_TOPIC)).onDockerEvent(this, agentEvent);
        }
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, @NotNull DockerDeploymentConfiguration configuration) {
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(8);
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName(null, source, configuration);
        if (string == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getRuntimeDeploymentName(@NotNull DeploymentRuntime deploymentRuntime, @NotNull DeploymentSource source, @NotNull DockerDeploymentConfiguration configuration) {
        if (deploymentRuntime == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(10);
        }
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(11);
        }
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(12);
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName((DockerApplicationRuntime)deploymentRuntime, source, configuration);
        if (string == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static String doGetDeploymentName(@Nullable DockerApplicationRuntime applicationRuntime, @NotNull DeploymentSource source, @NotNull DockerDeploymentConfiguration configuration) {
        String result;
        DeploymentSourceType type;
        if (source == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(14);
        }
        if (configuration == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(15);
        }
        if ((type = source.getType()) instanceof DockerSingletonDeploymentSourceType) {
            result = ((DockerSingletonDeploymentSourceType)type).getPresentableDeploymentName(configuration, applicationRuntime);
        } else {
            String namePiece = DockerSingletonDeploymentSourceType.getPresentableContainerNamePiece(configuration, applicationRuntime);
            result = namePiece + " Artifact: " + source.getPresentableName();
        }
        return result;
    }

    public void imageRegistryAuth(DockerRegistry registry, RegistryAuthCallback callback) {
        this.getTaskExecutor().submit(() -> {
            try {
                this.getAgentTaskExecutor().execute(() -> {
                    ((DockerAgent)this.getAgent()).imageRegistryAuth(registry.getAuthConfig());
                    return null;
                });
                callback.succeeded();
            }
            catch (ServerRuntimeException e) {
                callback.errorOccurred(e.getMessage());
            }
        });
    }

    public List<CloudApplicationRuntime> getApplications() throws ServerRuntimeException {
        return (List)this.getAgentTaskExecutor().execute(() -> {
            DockerAgentApplication[] agentApps = Optional.ofNullable(((DockerAgent)this.getAgent()).getApplications()).orElse(DockerAgentApplication.EMPTY_ARRAY);
            return this.myRuntimesCache.refreshStructure(agentApps);
        });
    }

    @NotNull
    public CompletableFuture<DockerApplicationRuntime> findRuntimeLater(@NotNull String id, boolean containerNotImage) {
        if (id == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(16);
        }
        CompletableFuture<DockerApplicationRuntime> promise = new CompletableFuture<DockerApplicationRuntime>();
        this.getTaskExecutor().submit(() -> {
            try {
                DockerApplicationRuntime result = (DockerApplicationRuntime)((Object)((Object)this.getAgentTaskExecutor().execute(() -> {
                    DockerAgentApplication app = containerNotImage ? ((DockerAgent)this.getAgent()).findContainer(id) : (DockerAgentApplication)Stream.of(((DockerAgent)this.getAgent()).getImages(null)).filter(next -> id.equalsIgnoreCase(next.getImageId())).findFirst().orElse(null);
                    return app == null ? null : this.myRuntimesCache.createRuntimeForExternalUse(app);
                })));
                promise.complete(result);
            }
            catch (ServerRuntimeException e) {
                promise.completeExceptionally(e);
            }
        });
        CompletableFuture<DockerApplicationRuntime> completableFuture = promise;
        if (completableFuture == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(17);
        }
        return completableFuture;
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication applicationIdentity) {
        throw new UnsupportedOperationException("should not be called, super.getApplications is overridden");
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    @NotNull
    private DockerRuntimesManagerImpl getRuntimesManager() {
        DockerRuntimesManagerImpl dockerRuntimesManagerImpl = (DockerRuntimesManagerImpl)DockerRuntimesManagerService.getInstance().findOrCreateManagerFor((DockerCloudConfiguration)this.getConfiguration());
        if (dockerRuntimesManagerImpl == null) {
            DockerServerRuntimeInstance.$$$reportNull$$$0(18);
        }
        return dockerRuntimesManagerImpl;
    }

    @NotNull
    private static CloudAgentLogger createAgentLogger() {
        return new CloudAgentLogger(){

            public void debugEx(Exception e) {
                LOG.debug((Throwable)e);
            }

            public void debug(String message) {
                LOG.debug(message);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerServerRuntimeInstance";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentRuntime";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerServerRuntimeInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeDeploymentName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findRuntimeLater";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimesManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDockerConnectionParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deploy";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentName";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeDeploymentName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGetDeploymentName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRuntimeLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DockerServerListener {
        public void onDockerEvent(@NotNull DockerServerRuntimeInstance var1, @NotNull DockerEvent var2);
    }
}

