/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant.actions;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantBox;
import com.jetbrains.plugins.vagrant.VagrantBoxManager;
import com.jetbrains.plugins.vagrant.VagrantBundle;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantProjectSettings;
import com.jetbrains.plugins.vagrant.actions.VagrantActionBase;
import com.jetbrains.plugins.vagrant.actions.VagrantTask;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VagrantInitInProjectAction
extends VagrantActionBase {
    @Override
    protected String commandName() {
        return "init";
    }

    @Override
    protected void createVagrantTask(@NotNull Project project, Consumer<VagrantTask> taskRunner) {
        String vagrantPath;
        if (project == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmpty((String)(vagrantPath = VagrantManager.getInstance(project).getVagrantExecutable(true)))) {
            VirtualFile[] roots = ProjectRootManager.getInstance((Project)project).getContentRoots();
            if (roots.length == 1) {
                this.createForRoot(project, vagrantPath, roots[0].getPath(), taskRunner);
            } else if (roots.length > 1) {
                this.selectRoot(project, vagrantPath, roots, taskRunner);
            }
        }
    }

    private void selectRoot(final Project project, final String vagrantPath, VirtualFile[] roots, final Consumer<VagrantTask> taskConsumer) {
        BaseListPopupStep<VirtualFile> sdkHomesStep = new BaseListPopupStep<VirtualFile>(VagrantBundle.message("vagrant.select.folder.for.instance", new Object[0]), (List)Lists.newArrayList((Object[])roots)){

            @NotNull
            public String getTextFor(VirtualFile value) {
                String string = value.getPath();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile root, boolean finalChoice) {
                ApplicationManager.getApplication().invokeLater(() -> VagrantInitInProjectAction.this.createForRoot(project, vagrantPath, root.getPath(), (Consumer<VagrantTask>)taskConsumer));
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction$1", "getTextFor"));
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
        popup.showInFocusCenter();
    }

    private void selectBoxName(final @NotNull Project project, final @NotNull String executable, final @NotNull String root, @NotNull List<VagrantBox> boxes, @NotNull VagrantBoxManager boxManager) {
        if (project == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(1);
        }
        if (executable == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(2);
        }
        if (root == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(3);
        }
        if (boxes == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(4);
        }
        if (boxManager == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(5);
        }
        if (boxes.size() == 0) {
            FutureResult<VagrantBox> futureBox = boxManager.add();
            if (futureBox != null) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        VagrantBox box = (VagrantBox)futureBox.get();
                        if (box != null) {
                            this.init(box, project, executable, root);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        } else if (boxes.size() == 1) {
            this.init(boxes.get(0), project, executable, root);
        } else {
            BaseListPopupStep<VagrantBox> sdkHomesStep = new BaseListPopupStep<VagrantBox>(VagrantBundle.message("vagrant.select.box", new Object[0]), boxes){

                @NotNull
                public String getTextFor(VagrantBox value) {
                    String string = value.getName();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(VagrantBox box, boolean finalChoice) {
                    VagrantInitInProjectAction.this.init(box, project, executable, root);
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction$2", "getTextFor"));
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)sdkHomesStep);
            popup.showInFocusCenter();
        }
    }

    private void init(@NotNull VagrantBox box, @NotNull Project project, @NotNull String executable, @NotNull String root) {
        if (box == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(7);
        }
        if (executable == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(8);
        }
        if (root == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(9);
        }
        this.performTask(project, VagrantInitInProjectAction.createInitTask(project, executable, root, this.commandName(), box.getName()));
    }

    private void createForRoot(Project project, String executable, String root, Consumer<VagrantTask> vagrantTaskConsumer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            VagrantBoxManager boxManager = new VagrantBoxManager(project);
            boxManager.setVagrantPath(executable);
            List vagrantBoxes = boxManager.listItems();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (vagrantBoxes != null) {
                    this.selectBoxName(project, executable, root, vagrantBoxes, boxManager);
                } else {
                    vagrantTaskConsumer.consume((Object)VagrantInitInProjectAction.createInitTask(project, executable, root, this.commandName()));
                }
            });
        });
    }

    private static VagrantTask createInitTask(@NotNull Project project, @NotNull String executable, @NotNull String root, String ... command) {
        if (project == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(10);
        }
        if (executable == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(11);
        }
        if (root == null) {
            VagrantInitInProjectAction.$$$reportNull$$$0(12);
        }
        VagrantTask task = VagrantTask.create(project, executable, root, command);
        task.setAfterCompletion(() -> {
            VagrantProjectSettings.getInstance(project).setInstanceFolder(root);
            VirtualFile rootFile = LocalFileSystem.getInstance().findFileByPath(root);
            if (rootFile != null) {
                rootFile.refresh(true, false);
            }
        });
        return task;
    }

    @Override
    protected boolean isEnabled(Project project) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "box";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/vagrant/actions/VagrantInitInProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVagrantTask";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "selectBoxName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createInitTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

