/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerLanguage;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCompositeElement;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileAddOrCopyCommand;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileFileOrUrl;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileParametersInJsonForm;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFilePathSegment;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileStringLiteral;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileVariableRefFull;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileVariableRefSimple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DockerFileAddOrCopySemanticInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DockerFileAddOrCopySemanticInspection.$$$reportNull$$$0(0);
        }
        if (holder.getFile() instanceof DockerPsiFile) {
            return new AddCopyInspector(holder, isOnTheFly);
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            DockerFileAddOrCopySemanticInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileAddOrCopySemanticInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAddOrCopySemanticInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddCopyInspector
    extends DockerFileInspectorBase {
        AddCopyInspector(@NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
            if (problemsHolder == null) {
                AddCopyInspector.$$$reportNull$$$0(0);
            }
            super(problemsHolder, isOnTheFly);
        }

        @Override
        public void visitAddOrCopyCommand(@NotNull DockerFileAddOrCopyCommand cmd) {
            DockerFileParametersInJsonForm jsonForm;
            if (cmd == null) {
                AddCopyInspector.$$$reportNull$$$0(1);
            }
            if ((jsonForm = cmd.getParametersInJsonForm()) != null) {
                this.requireJsonTargetEndsWithSlash(jsonForm.getStringLiteralList());
            } else {
                this.requireFileTargetEndsWithSlash(cmd.getFileOrUrlList());
            }
        }

        private void requireJsonTargetEndsWithSlash(@NotNull List<DockerFileStringLiteral> jsonParams) {
            if (jsonParams == null) {
                AddCopyInspector.$$$reportNull$$$0(2);
            }
            if (jsonParams.size() <= 2) {
                return;
            }
            DockerFileStringLiteral targetParam = jsonParams.get(jsonParams.size() - 1);
            this.requireEndsWithSlash(targetParam, targetParam, new LocalQuickFix[]{new AddSlashStringPartQuickFix(targetParam)});
        }

        private void requireFileTargetEndsWithSlash(@NotNull List<DockerFileFileOrUrl> files) {
            if (files == null) {
                AddCopyInspector.$$$reportNull$$$0(3);
            }
            if (files.size() <= 2) {
                return;
            }
            DockerFileFileOrUrl target = files.get(files.size() - 1);
            List<DockerFilePathSegment> segments = target.getPathSegmentList();
            if (segments.isEmpty()) {
                return;
            }
            DockerFilePathSegment lastSegment = segments.get(segments.size() - 1);
            this.requireEndsWithSlash(lastSegment, target, new LocalQuickFix[]{new AddSlashSegmentQuickFix(target)});
        }

        private void requireEndsWithSlash(DockerPsiCompositeElement toCheck, DockerPsiCompositeElement toHighlight, LocalQuickFix ... fixes) {
            PsiElement lastChild;
            if (fixes == null) {
                AddCopyInspector.$$$reportNull$$$0(4);
            }
            if (AddCopyInspector.isQuote(lastChild = toCheck.getLastChild())) {
                lastChild = lastChild.getPrevSibling();
            }
            if (lastChild == null) {
                return;
            }
            if (lastChild instanceof DockerFileVariableRefFull || lastChild instanceof DockerFileVariableRefSimple) {
                return;
            }
            if (!lastChild.getText().endsWith("/")) {
                this.registerProblem(Arrays.asList(toHighlight.getFirstChild(), toHighlight.getLastChild()), DockerBundle.message((String)"DockerFileAddOrCopySemanticInspection.error.target.must.be.folder", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, fixes);
            }
        }

        private static boolean isQuote(PsiElement psi) {
            return psi != null && psi.getNode().getElementType() == DockerTokenTypes.QUOTE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmd";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonParams";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAddOrCopySemanticInspection$AddCopyInspector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAddOrCopyCommand";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requireJsonTargetEndsWithSlash";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requireFileTargetEndsWithSlash";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requireEndsWithSlash";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class AddSlashStringPartQuickFix
        extends AddSlashQuickFixBase {
            AddSlashStringPartQuickFix(@NotNull DockerFileStringLiteral literal) {
                if (literal == null) {
                    AddSlashStringPartQuickFix.$$$reportNull$$$0(0);
                }
                super((PsiElement)literal);
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    AddSlashStringPartQuickFix.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    AddSlashStringPartQuickFix.$$$reportNull$$$0(2);
                }
                if (startElement == null) {
                    AddSlashStringPartQuickFix.$$$reportNull$$$0(3);
                }
                if (endElement == null) {
                    AddSlashStringPartQuickFix.$$$reportNull$$$0(4);
                }
                assert (endElement instanceof DockerFileStringLiteral);
                DockerFileStringLiteral literal = (DockerFileStringLiteral)endElement;
                PsiElement slash = AddSlashStringPartQuickFix.createSlashStringPart(project);
                PsiElement lastQuote = literal.getLastChild();
                if (lastQuote == null || !AddCopyInspector.isQuote(lastQuote)) {
                    literal.add(slash);
                } else {
                    literal.addBefore(slash, lastQuote);
                }
            }

            private static PsiElement createSlashStringPart(@NotNull Project project) {
                if (project == null) {
                    AddSlashStringPartQuickFix.$$$reportNull$$$0(5);
                }
                DockerFileAddOrCopyCommand command = AddSlashStringPartQuickFix.parseAddCommand(project, "ADD [\"a\", \"/\"]");
                return Optional.of(command).map(DockerFileAddOrCopyCommand::getParametersInJsonForm).map(DockerFileParametersInJsonForm::getStringLiteralList).map(ContainerUtil::getLastItem).map(PsiElement::getLastChild).map(PsiElement::getPrevSibling).orElseThrow(() -> new IllegalStateException());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAddOrCopySemanticInspection$AddCopyInspector$AddSlashStringPartQuickFix";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "invoke";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createSlashStringPart";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class AddSlashSegmentQuickFix
        extends AddSlashQuickFixBase {
            AddSlashSegmentQuickFix(@NotNull DockerFileFileOrUrl file) {
                if (file == null) {
                    AddSlashSegmentQuickFix.$$$reportNull$$$0(0);
                }
                super((PsiElement)file);
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    AddSlashSegmentQuickFix.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    AddSlashSegmentQuickFix.$$$reportNull$$$0(2);
                }
                if (startElement == null) {
                    AddSlashSegmentQuickFix.$$$reportNull$$$0(3);
                }
                if (endElement == null) {
                    AddSlashSegmentQuickFix.$$$reportNull$$$0(4);
                }
                assert (endElement instanceof DockerFileFileOrUrl);
                DockerFileFileOrUrl subj = (DockerFileFileOrUrl)endElement;
                PsiElement slash = AddSlashSegmentQuickFix.createSlashSegment(project);
                subj.addAfter(slash, subj.getLastChild());
            }

            private static PsiElement createSlashSegment(@NotNull Project project) {
                if (project == null) {
                    AddSlashSegmentQuickFix.$$$reportNull$$$0(5);
                }
                DockerFileAddOrCopyCommand command = AddSlashSegmentQuickFix.parseAddCommand(project, "ADD a b/");
                DockerFileFileOrUrl lastSegment = (DockerFileFileOrUrl)ContainerUtil.getLastItem(command.getFileOrUrlList());
                assert (lastSegment != null);
                return lastSegment.getLastChild();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAddOrCopySemanticInspection$AddCopyInspector$AddSlashSegmentQuickFix";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "invoke";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createSlashSegment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static abstract class AddSlashQuickFixBase
        extends LocalQuickFixOnPsiElement {
            AddSlashQuickFixBase(@NotNull PsiElement subject) {
                if (subject == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(0);
                }
                super(subject);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = this.getText();
                if (string == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getText() {
                String string = DockerBundle.message((String)"DockerFileAddOrCopySemanticInspection.error.quick.fix", (Object[])new Object[0]);
                if (string == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            protected static DockerFileAddOrCopyCommand parseAddCommand(@NotNull Project project, @NotNull String text) {
                if (project == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(3);
                }
                if (text == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(4);
                }
                DockerPsiFile dockerFile = AddSlashQuickFixBase.createFromText(project, text);
                assert (dockerFile.getFirstChild() instanceof DockerFileAddOrCopyCommand) : "Add command expected: " + dockerFile.getFirstChild();
                DockerFileAddOrCopyCommand dockerFileAddOrCopyCommand = (DockerFileAddOrCopyCommand)dockerFile.getFirstChild();
                if (dockerFileAddOrCopyCommand == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(5);
                }
                return dockerFileAddOrCopyCommand;
            }

            private static DockerPsiFile createFromText(@NotNull Project project, @NotNull String text) {
                if (project == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(6);
                }
                if (text == null) {
                    AddSlashQuickFixBase.$$$reportNull$$$0(7);
                }
                return (DockerPsiFile)PsiFileFactory.getInstance((Project)project).createFileFromText((Language)DockerLanguage.INSTANCE, (CharSequence)text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "subject";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileAddOrCopySemanticInspection$AddCopyInspector$AddSlashQuickFixBase";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAddOrCopySemanticInspection$AddCopyInspector$AddSlashQuickFixBase";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseAddCommand";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "parseAddCommand";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "createFromText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

