/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompositeElementDescriptor
implements CssElementDescriptor {
    @NotNull
    private final Collection<? extends CssElementDescriptor> myDescriptors;
    @NotNull
    private final CssElementDescriptor myDescriptorFromLatestSpec;

    @Nullable
    public static CssElementDescriptor create(@NotNull Collection<? extends CssElementDescriptor> descriptors) {
        if (descriptors == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(0);
        }
        if (descriptors.isEmpty()) {
            return null;
        }
        if (descriptors.size() == 1) {
            return (CssElementDescriptor)ContainerUtil.getFirstItem(descriptors);
        }
        return new CssCompositeElementDescriptor(descriptors);
    }

    private CssCompositeElementDescriptor(@NotNull Collection<? extends CssElementDescriptor> descriptors) {
        if (descriptors == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(1);
        }
        assert (descriptors.size() > 0);
        this.myDescriptors = descriptors;
        CssElementDescriptor descriptorFromLatestSpec = CssDescriptorsUtil.getDescriptorFromLatestSpec(descriptors);
        assert (descriptorFromLatestSpec != null);
        this.myDescriptorFromLatestSpec = descriptorFromLatestSpec;
    }

    @Override
    @NotNull
    public CssElementDescriptor.CssVersion getCssVersion() {
        CssElementDescriptor.CssVersion result = CssElementDescriptor.CssVersion.UNKNOWN;
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            CssElementDescriptor.CssVersion version = cssElementDescriptor.getCssVersion();
            if (result != CssElementDescriptor.CssVersion.UNKNOWN && result.value() <= version.value()) continue;
            result = version;
        }
        CssElementDescriptor.CssVersion cssVersion = result;
        if (cssVersion == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(2);
        }
        return cssVersion;
    }

    @Override
    public BrowserVersion @NotNull [] getBrowsers() {
        TreeSet<BrowserVersion> browsers = new TreeSet<BrowserVersion>(BrowserVersion.COMPARATOR);
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            BrowserVersion[] descriptorBrowsers = cssElementDescriptor.getBrowsers();
            if (descriptorBrowsers.length == 0) {
                if (BrowserVersion.EMPTY_ARRAY == null) {
                    CssCompositeElementDescriptor.$$$reportNull$$$0(3);
                }
                return BrowserVersion.EMPTY_ARRAY;
            }
            Collections.addAll(browsers, descriptorBrowsers);
        }
        BrowserVersion[] browserVersionArray = browsers.toArray(BrowserVersion.EMPTY_ARRAY);
        if (browserVersionArray == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(4);
        }
        return browserVersionArray;
    }

    @Override
    public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
        if (contextType == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(5);
        }
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            if (!cssElementDescriptor.isAllowedInContextType(contextType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myDescriptorFromLatestSpec.getId();
        if (string == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myDescriptorFromLatestSpec.getPresentableName();
        if (string == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescriptorFromLatestSpec.getPresentableName();
        if (string == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        return this.myDescriptorFromLatestSpec.getDocumentationString(context);
    }

    @Override
    @NotNull
    public String getElementTypeName() {
        String string = this.myDescriptorFromLatestSpec.getElementTypeName();
        if (string == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    public String getSpecificationUrl() {
        return this.myDescriptorFromLatestSpec.getSpecificationUrl();
    }

    @Override
    public CssContextType @NotNull [] getAllowedContextTypes() {
        TreeSet<? super CssContextType> contextTypes = new TreeSet<CssContextType>(CssContextType.COMPARATOR);
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            Collections.addAll(contextTypes, cssElementDescriptor.getAllowedContextTypes());
        }
        CssContextType[] cssContextTypeArray = contextTypes.toArray(CssContextType.EMPTY_ARRAY);
        if (cssContextTypeArray == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(10);
        }
        return cssContextTypeArray;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myDescriptorFromLatestSpec.getIcon();
    }

    @NotNull
    public CssElementDescriptor getDescriptorFromLatestSpec() {
        CssElementDescriptor cssElementDescriptor = this.myDescriptorFromLatestSpec;
        if (cssElementDescriptor == null) {
            CssCompositeElementDescriptor.$$$reportNull$$$0(11);
        }
        return cssElementDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssCompositeElementDescriptor)) {
            return false;
        }
        CssCompositeElementDescriptor that = (CssCompositeElementDescriptor)o;
        return this.myDescriptors.equals(that.myDescriptors);
    }

    public int hashCode() {
        return this.myDescriptors.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTypeName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedContextTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorFromLatestSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedInContextType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

