/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public class JBHtmlEditorKit
extends HTMLEditorKit {
    private static final Logger LOG = Logger.getInstance(JBHtmlEditorKit.class);
    private static final ViewFactory ourViewFactory;
    private static final StyleSheet ourCommonStyle;
    private static final StyleSheet ourNoGapsBetweenParagraphsStyle;
    private final StyleSheet style;
    private final HyperlinkListener myHyperlinkListener;
    private final boolean myDisableLinkedCss;

    @Override
    public Cursor getDefaultCursor() {
        return null;
    }

    public JBHtmlEditorKit() {
        this(true);
    }

    public JBHtmlEditorKit(boolean noGapsBetweenParagraphs) {
        this(noGapsBetweenParagraphs, false);
    }

    public JBHtmlEditorKit(boolean noGapsBetweenParagraphs, boolean disableLinkedCss) {
        this.myDisableLinkedCss = disableLinkedCss;
        this.style = JBHtmlEditorKit.createStyleSheet();
        if (noGapsBetweenParagraphs) {
            this.style.addStyleSheet(ourNoGapsBetweenParagraphsStyle);
        }
        this.myHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                Element element = e.getSourceElement();
                if (element == null) {
                    return;
                }
                if (element.getName().equals("img")) {
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    this.setUnderlined(true, element);
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    this.setUnderlined(false, element);
                }
            }

            private void setUnderlined(boolean underlined, @NotNull Element element) {
                AttributeSet attributes;
                Object attribute;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((attribute = (attributes = element.getAttributes()).getAttribute(HTML.Tag.A)) instanceof MutableAttributeSet) {
                    MutableAttributeSet a = (MutableAttributeSet)attribute;
                    a.addAttribute(CSS.Attribute.TEXT_DECORATION, underlined ? "underline" : "none");
                    ((StyledDocument)element.getDocument()).setCharacterAttributes(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), a, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/ui/JBHtmlEditorKit$1", "setUnderlined"));
            }
        };
    }

    @Override
    public StyleSheet getStyleSheet() {
        return this.style;
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        StyleSheetCompressionThreshold ss = new StyleSheetCompressionThreshold();
        ss.addStyleSheet(styles);
        HTMLDocument doc = this.myDisableLinkedCss ? new HTMLDocumentNoLinkedCss(ss) : new HTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    public static StyleSheet createStyleSheet() {
        StyleSheet style = new StyleSheet();
        style.addStyleSheet(StartupUiUtil.isUnderDarcula() ? (StyleSheet)UIManager.getDefaults().get("StyledEditorKit.JBDefaultStyle") : StartupUiUtil.getDefaultHtmlKitCss());
        style.addStyleSheet(ourCommonStyle);
        return style;
    }

    @Override
    public void install(final JEditorPane pane) {
        super.install(pane);
        pane.addPropertyChangeListener("editorKit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                pane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                pane.removePropertyChangeListener(this);
            }
        });
        pane.addHyperlinkListener(this.myHyperlinkListener);
        List<HTMLEditorKit.LinkController> listeners1 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseListeners());
        List<HTMLEditorKit.LinkController> listeners2 = JBHtmlEditorKit.filterLinkControllerListeners(pane.getMouseMotionListeners());
        if (listeners1.size() == 1 && listeners1.equals(listeners2)) {
            HTMLEditorKit.LinkController oldLinkController = listeners1.get(0);
            pane.removeMouseListener(oldLinkController);
            pane.removeMouseMotionListener(oldLinkController);
            MouseExitSupportLinkController newLinkController = new MouseExitSupportLinkController();
            pane.addMouseListener(newLinkController);
            pane.addMouseMotionListener(newLinkController);
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return ourViewFactory;
    }

    @NotNull
    private static List<HTMLEditorKit.LinkController> filterLinkControllerListeners(Object @NotNull [] listeners) {
        if (listeners == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.mapNotNull((Object[])listeners, o -> (HTMLEditorKit.LinkController)ObjectUtils.tryCast((Object)o, HTMLEditorKit.LinkController.class));
        if (list == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void deinstall(@NotNull JEditorPane c) {
        if (c == null) {
            JBHtmlEditorKit.$$$reportNull$$$0(2);
        }
        c.removeHyperlinkListener(this.myHyperlinkListener);
        super.deinstall(c);
    }

    static {
        ourCommonStyle = StartupUiUtil.createStyleSheet("code { font-size: 100%; }small { font-size: small; }a { text-decoration: none;}ul { margin-left-ltr: 12; margin-right-rtl: 12; }ol { margin-left-ltr: 22; margin-right-rtl: 22; }");
        ourNoGapsBetweenParagraphsStyle = StartupUiUtil.createStyleSheet("p { margin-top: 0; }");
        StartupUiUtil.configureHtmlKitStylesheet();
        ourViewFactory = new JBHtmlFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBHtmlEditorKit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLinkControllerListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterLinkControllerListeners";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deinstall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HTMLDocumentNoLinkedCss
    extends HTMLDocument {
        private HTMLDocumentNoLinkedCss(StyleSheet styles) {
            super(styles);
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int pos) {
            return new CallbackWrapper(super.getReader(pos));
        }

        @Override
        public HTMLEditorKit.ParserCallback getReader(int pos, int popDepth, int pushDepth, HTML.Tag insertTag) {
            return new CallbackWrapper(super.getReader(pos, popDepth, pushDepth, insertTag));
        }

        private static class CallbackWrapper
        extends HTMLEditorKit.ParserCallback {
            private final HTMLEditorKit.ParserCallback delegate;
            private int depth;

            private CallbackWrapper(HTMLEditorKit.ParserCallback delegate) {
                this.delegate = delegate;
            }

            @Override
            public void flush() throws BadLocationException {
                this.delegate.flush();
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleText(data, pos);
            }

            @Override
            public void handleComment(char[] data, int pos) {
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleComment(data, pos);
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.LINK) {
                    ++this.depth;
                }
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleStartTag(t, a, pos);
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t == HTML.Tag.LINK) {
                    --this.depth;
                }
                LOG.assertTrue(this.depth >= 0);
                if (this.depth > 0) {
                    return;
                }
                this.delegate.handleEndTag(t, pos);
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.LINK) {
                    return;
                }
                this.delegate.handleSimpleTag(t, a, pos);
            }

            @Override
            public void handleError(String errorMsg, int pos) {
                this.delegate.handleError(errorMsg, pos);
            }

            @Override
            public void handleEndOfLineString(String eol) {
                this.delegate.handleEndOfLineString(eol);
            }
        }
    }

    public static class JBHtmlFactory
    extends HTMLEditorKit.HTMLFactory {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public View create(Element elem) {
            AttributeSet attrs = elem.getAttributes();
            if (!"img".equals(elem.getName())) return super.create(elem);
            String src = (String)attrs.getAttribute(HTML.Attribute.SRC);
            if (src == null) return super.create(elem);
            if (!src.startsWith("data:image")) return super.create(elem);
            if (!src.contains("base64")) return super.create(elem);
            String[] split = src.split(",");
            if (split.length != 2) return super.create(elem);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(split[1]));){
                BufferedImage image = ImageIO.read(bis);
                if (image == null) return super.create(elem);
                MyBufferedImageView myBufferedImageView = new MyBufferedImageView(elem, image);
                return myBufferedImageView;
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.debug((Throwable)e);
            }
            return super.create(elem);
        }

        private static class MyBufferedImageView
        extends View {
            private static final int DEFAULT_BORDER = 0;
            private final BufferedImage myBufferedImage;
            private final int width;
            private final int height;
            private final int border;
            private final float vAlign;

            private MyBufferedImageView(Element elem, BufferedImage myBufferedImage) {
                super(elem);
                this.myBufferedImage = myBufferedImage;
                int width = this.getIntAttr(HTML.Attribute.WIDTH, -1);
                int height = this.getIntAttr(HTML.Attribute.HEIGHT, -1);
                if (width < 0 && height < 0) {
                    this.width = myBufferedImage.getWidth();
                    this.height = myBufferedImage.getHeight();
                } else if (width < 0) {
                    this.width = height * this.getAspectRatio();
                    this.height = height;
                } else if (height < 0) {
                    this.width = width;
                    this.height = width / this.getAspectRatio();
                } else {
                    this.width = width;
                    this.height = height;
                }
                this.border = this.getIntAttr(HTML.Attribute.BORDER, 0);
                Object alignment = elem.getAttributes().getAttribute(HTML.Attribute.ALIGN);
                float vAlign = 1.0f;
                if (alignment != null) {
                    if ("top".equals(alignment = alignment.toString())) {
                        vAlign = 0.0f;
                    } else if ("middle".equals(alignment)) {
                        vAlign = 0.5f;
                    }
                }
                this.vAlign = vAlign;
            }

            private int getAspectRatio() {
                return this.myBufferedImage.getWidth() / this.myBufferedImage.getHeight();
            }

            private int getIntAttr(HTML.Attribute name, int defaultValue) {
                AttributeSet attr = this.getElement().getAttributes();
                if (attr.isDefined(name)) {
                    String val = (String)attr.getAttribute(name);
                    if (val == null) {
                        return defaultValue;
                    }
                    try {
                        return Math.max(0, Integer.parseInt(val));
                    }
                    catch (NumberFormatException x) {
                        return defaultValue;
                    }
                }
                return defaultValue;
            }

            @Override
            public float getPreferredSpan(int axis) {
                switch (axis) {
                    case 0: {
                        return this.width + 2 * this.border;
                    }
                    case 1: {
                        return this.height + 2 * this.border;
                    }
                }
                throw new IllegalArgumentException("Invalid axis: " + axis);
            }

            @Override
            public String getToolTipText(float x, float y, Shape allocation) {
                return (String)super.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
            }

            @Override
            public void paint(Graphics g, Shape a) {
                Rectangle bounds = a.getBounds();
                g.drawImage(this.myBufferedImage, bounds.x + this.border, bounds.y + this.border, this.width, this.height, null);
            }

            @Override
            public Shape modelToView(int pos, Shape a, Position.Bias b) {
                int p0 = this.getStartOffset();
                int p1 = this.getEndOffset();
                if (pos >= p0 && pos <= p1) {
                    Rectangle r = a.getBounds();
                    if (pos == p1) {
                        r.x += r.width;
                    }
                    r.width = 0;
                    return r;
                }
                return null;
            }

            @Override
            public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
                Rectangle alloc = (Rectangle)a;
                if (x < (float)(alloc.x + alloc.width)) {
                    bias[0] = Position.Bias.Forward;
                    return this.getStartOffset();
                }
                bias[0] = Position.Bias.Backward;
                return this.getEndOffset();
            }

            @Override
            public float getAlignment(int axis) {
                if (axis == 1) {
                    return this.vAlign;
                }
                return super.getAlignment(axis);
            }
        }
    }

    private static class MouseExitSupportLinkController
    extends HTMLEditorKit.LinkController {
        private MouseExitSupportLinkController() {
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MouseExitSupportLinkController.$$$reportNull$$$0(0);
            }
            this.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), -1, -1, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/JBHtmlEditorKit$MouseExitSupportLinkController", "mouseExited"));
        }
    }

    private static class StyleSheetCompressionThreshold
    extends StyleSheet {
        private StyleSheetCompressionThreshold() {
        }

        @Override
        protected int getCompressionThreshold() {
            return -1;
        }
    }
}

