/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.Lists;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.BaseJSTokenTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsPsiUtils {
    private JsPsiUtils() {
    }

    @Nullable
    public static PsiElement getMethodNameLeafElement(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression referenceExpression;
        if (callExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(0);
        }
        return (referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null ? referenceExpression.getReferenceNameElement() : null;
    }

    @NotNull
    private static String getStringValue(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(1);
        }
        if (literalExpression instanceof JSStringTemplateExpression) {
            String string = StringUtil.unquoteString((String)literalExpression.getText(), (char)'`');
            if (string == null) {
                JsPsiUtils.$$$reportNull$$$0(2);
            }
            return string;
        }
        String text = StringUtil.unquoteString((String)StringUtil.notNullize((String)literalExpression.getText()));
        return JsPsiUtils.unescapeBackslashes(text);
    }

    @NotNull
    public static String unescapeBackslashes(@NotNull String str) {
        if (str == null) {
            JsPsiUtils.$$$reportNull$$$0(3);
        }
        if (!StringUtil.containsChar((String)str, (char)'\\')) {
            String string = str;
            if (string == null) {
                JsPsiUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean backslash = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (backslash) {
                if (ch == 'u') {
                    if (JsPsiUtils.appendCodePoint(result, str, i + 1, 4)) {
                        i += 4;
                    } else {
                        result.append('\\').append(ch);
                    }
                } else if (ch == 'x') {
                    if (JsPsiUtils.appendCodePoint(result, str, i + 1, 2)) {
                        i += 2;
                    } else {
                        result.append('\\').append(ch);
                    }
                } else {
                    JsPsiUtils.appendEscapedChar(result, ch);
                }
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            JsPsiUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void appendEscapedChar(@NotNull StringBuilder result, char ch) {
        if (result == null) {
            JsPsiUtils.$$$reportNull$$$0(6);
        }
        if (ch == '0') {
            result.append('\u0000');
        } else if (ch == '\'') {
            result.append('\'');
        } else if (ch == '\"') {
            result.append('\"');
        } else if (ch == '\\') {
            result.append('\\');
        } else if (ch == 'n') {
            result.append('\n');
        } else if (ch == 'r') {
            result.append('\r');
        } else if (ch == 'v') {
            result.append('v');
        } else if (ch == 't') {
            result.append('\t');
        } else if (ch == 'b') {
            int l = result.length();
            if (l > 0) {
                result.setLength(l - 1);
            }
        } else if (ch == 'f') {
            result.append('\f');
        } else {
            result.append(ch);
        }
    }

    private static boolean appendCodePoint(@NotNull StringBuilder result, @NotNull String str, int from, int cnt) {
        if (result == null) {
            JsPsiUtils.$$$reportNull$$$0(7);
        }
        if (str == null) {
            JsPsiUtils.$$$reportNull$$$0(8);
        }
        if (from + cnt <= str.length()) {
            String s = str.substring(from, from + cnt);
            try {
                int code = Integer.parseInt(s, 16);
                result.append((char)code);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public static String extractStringValue(@Nullable JSExpression expr) {
        if (expr == null) {
            return null;
        }
        JSLiteralExpression jsLiteralExpr = (JSLiteralExpression)ObjectUtils.tryCast((Object)expr, JSLiteralExpression.class);
        if (jsLiteralExpr != null && jsLiteralExpr.isQuotedLiteral()) {
            return JsPsiUtils.getStringValue(jsLiteralExpr);
        }
        return expr.getText();
    }

    @Nullable
    private static JSExpression extractInitExpression(@NotNull JSReferenceExpression jsReferenceExpression) {
        JSElement scopeElement;
        if (jsReferenceExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(9);
        }
        if ((scopeElement = JsPsiUtils.getNearestContainingScopeElement((JSElement)jsReferenceExpression)) == null) {
            return null;
        }
        String refName = jsReferenceExpression.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return null;
        }
        List<JSStatement> statements = JsPsiUtils.getTopLevelStatementsOf(scopeElement);
        int maxOffset = jsReferenceExpression.getTextRange().getStartOffset();
        JSExpression lastExpr = null;
        for (JSStatement statement : statements) {
            JSReferenceExpression refExpr;
            JSDefinitionExpression defExpr;
            JSAssignmentExpression assignmentExpr;
            JSExpressionStatement exprStmt;
            if (statement.getTextRange().getEndOffset() > maxOffset) break;
            JSVarStatement varStmt = (JSVarStatement)ObjectUtils.tryCast((Object)statement, JSVarStatement.class);
            if (varStmt != null) {
                JSVariable[] vars;
                for (JSVariable var : vars = (JSVariable[])ObjectUtils.notNull((Object)varStmt.getVariables(), (Object)JSVariable.EMPTY_ARRAY)) {
                    if (!refName.equals(var.getQualifiedName())) continue;
                    lastExpr = var.getInitializer();
                }
            }
            if ((exprStmt = (JSExpressionStatement)ObjectUtils.tryCast((Object)statement, JSExpressionStatement.class)) == null || (assignmentExpr = (JSAssignmentExpression)ObjectUtils.tryCast((Object)exprStmt.getExpression(), JSAssignmentExpression.class)) == null || (defExpr = (JSDefinitionExpression)ObjectUtils.tryCast((Object)assignmentExpr.getLOperand(), JSDefinitionExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)defExpr.getExpression(), JSReferenceExpression.class)) == null || refExpr.getQualifier() != null || !refName.equals(refExpr.getReferenceName())) continue;
            lastExpr = assignmentExpr.getROperand();
        }
        return lastExpr;
    }

    @Nullable
    public static JSObjectLiteralExpression extractObjectLiteralExpression(@Nullable JSExpression expression) {
        JSExpression initializer;
        if (expression == null) {
            return null;
        }
        JSObjectLiteralExpression jsObjectLiteralExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)expression, JSObjectLiteralExpression.class);
        if (jsObjectLiteralExpression != null) {
            return jsObjectLiteralExpression;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractObjectLiteralExpression(initializer);
        }
        return null;
    }

    @Nullable
    public static String extractNumberLiteral(@Nullable JSExpression jsExpression) {
        JSExpression initializer;
        if (jsExpression == null) {
            return null;
        }
        JSLiteralExpression jsLiteralExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)jsExpression, JSLiteralExpression.class);
        if (jsLiteralExpression != null && jsLiteralExpression.isNumericLiteral()) {
            return jsLiteralExpression.getText();
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)jsExpression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractNumberLiteral(initializer);
        }
        return null;
    }

    @Nullable
    public static JSFunctionExpression extractFunctionExpression(@Nullable JSExpression expression) {
        JSExpression initializer;
        if (expression == null) {
            return null;
        }
        JSFunctionExpression jsFunctionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)expression, JSFunctionExpression.class);
        if (jsFunctionExpression != null) {
            return jsFunctionExpression;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractFunctionExpression(initializer);
        }
        final Ref functionRef = Ref.create();
        expression.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                functionRef.set((Object)node);
                this.stopWalking();
            }
        });
        return (JSFunctionExpression)functionRef.get();
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            JsPsiUtils.$$$reportNull$$$0(10);
        }
        ArrayList statements = Lists.newArrayList();
        for (PsiElement child : jsFile.getChildren()) {
            JSElement element = (JSElement)ObjectUtils.tryCast((Object)child, JSElement.class);
            if (element == null) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder(element, statements);
        }
        ArrayList arrayList = statements;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFunctionExpression funcExpr) {
        JSBlockStatement block;
        if (funcExpr == null) {
            JsPsiUtils.$$$reportNull$$$0(12);
        }
        if ((block = funcExpr.getBlock()) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JsPsiUtils.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList statements = Lists.newArrayList();
        JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)block, statements);
        ArrayList arrayList = statements;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static void collectJsStatementsInExecutionOrder(@NotNull JSElement statement, @NotNull List<JSStatement> statements) {
        JSFunction function;
        block22: {
            block19: {
                JSCallExpression callExpression;
                JSExpression expressionOfStatement;
                block20: {
                    block21: {
                        if (statement == null) {
                            JsPsiUtils.$$$reportNull$$$0(15);
                        }
                        if (statements == null) {
                            JsPsiUtils.$$$reportNull$$$0(16);
                        }
                        function = null;
                        if (!(statement instanceof JSExpressionStatement)) break block19;
                        expressionOfStatement = ((JSExpressionStatement)statement).getExpression();
                        if (expressionOfStatement == null) {
                            return;
                        }
                        if (!(expressionOfStatement instanceof JSCallExpression)) break block20;
                        callExpression = (JSCallExpression)expressionOfStatement;
                        JSFunction unwrappedFunc = JsPsiUtils.unwrapCallExpression(callExpression);
                        if (unwrappedFunc != null) {
                            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)unwrappedFunc, statements);
                            return;
                        }
                        JSParenthesizedExpression parenthesizedExpression = JsPsiUtils.getParenthesizedExpression(callExpression);
                        if (parenthesizedExpression == null) break block21;
                        function = (JSFunction)ObjectUtils.tryCast((Object)parenthesizedExpression.getInnerExpression(), JSFunction.class);
                        break block22;
                    }
                    if (!JSAmdPsiUtil.isDefineCall((JSCallExpression)callExpression)) break block22;
                    JSExpression jSExpression = JSAmdPsiUtil.getModuleInitializer((JSCallExpression)callExpression);
                    function = (JSFunction)ObjectUtils.tryCast((Object)jSExpression, JSFunction.class);
                    break block22;
                }
                if (!(expressionOfStatement instanceof JSParenthesizedExpression) || (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)((JSParenthesizedExpression)expressionOfStatement).getInnerExpression(), JSCallExpression.class)) == null) break block22;
                function = (JSFunction)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSFunction.class);
                break block22;
            }
            if (statement instanceof JSVarStatement) {
                JSVarStatement varStatement = (JSVarStatement)statement;
                for (JSVariable jSVariable : varStatement.getStubSafeVariables()) {
                    JSFunction functionInitializer = (JSFunction)ObjectUtils.tryCast((Object)jSVariable.getInitializerOrStub(), JSFunction.class);
                    if (functionInitializer == null) continue;
                    JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)functionInitializer, statements);
                }
            }
        }
        if (function == null) {
            function = (JSFunction)ObjectUtils.tryCast((Object)statement, JSFunction.class);
        }
        if (function != null) {
            JSBlockStatement block = function.getBlock();
            if (block != null) {
                JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)block, statements);
            }
        } else if (statement instanceof JSBlockStatement) {
            JSSourceElement[] childStatements = ((JSBlockStatement)statement).getStatementListItems();
            for (JSVariable jSVariable : childStatements) {
                JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)jSVariable, statements);
            }
        } else if (statement instanceof JSStatement) {
            statements.add((JSStatement)statement);
        } else if (statement instanceof TypeScriptImplicitModule) {
            TypeScriptModule module = ((TypeScriptImplicitModule)statement).getRealModule();
            if (module != null) {
                JsPsiUtils.collectStatementsInsideModule(module, statements);
            }
        } else if (statement instanceof TypeScriptModule) {
            JsPsiUtils.collectStatementsInsideModule((TypeScriptModule)statement, statements);
        }
    }

    @Nullable
    private static JSFunction unwrapCallExpression(@NotNull JSCallExpression statement) {
        JSReferenceExpression methodExpression;
        if (statement == null) {
            JsPsiUtils.$$$reportNull$$$0(17);
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)(methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)statement.getMethodExpression(), JSReferenceExpression.class)), (String)"setTimeout")) {
            return (JSFunction)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])statement.getArguments()), JSFunction.class);
        }
        if (methodExpression != null && "forEach".equals(methodExpression.getReferenceName())) {
            return (JSFunction)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])statement.getArguments()), JSFunction.class);
        }
        return null;
    }

    private static void collectStatementsInsideModule(@NotNull TypeScriptModule tsm, @NotNull List<JSStatement> statements) {
        if (tsm == null) {
            JsPsiUtils.$$$reportNull$$$0(18);
        }
        if (statements == null) {
            JsPsiUtils.$$$reportNull$$$0(19);
        }
        for (PsiElement element : tsm.getChildren()) {
            if (!(element instanceof JSElement)) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)element, statements);
        }
    }

    private static JSParenthesizedExpression getParenthesizedExpression(JSCallExpression callExpression) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)methodExpression, JSReferenceExpression.class);
        if (referenceExpression != null && "call".equals(referenceExpression.getReferenceName())) {
            return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSParenthesizedExpression.class);
        }
        return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)methodExpression, JSParenthesizedExpression.class);
    }

    public static boolean isStringElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractStringValue(jsExpression) != null;
    }

    public static boolean isObjectElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractObjectLiteralExpression(jsExpression) != null;
    }

    public static boolean isFunctionExpressionElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractFunctionExpression(jsExpression) != null;
    }

    public static boolean isNumberElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractNumberLiteral(jsExpression) != null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static JSCallExpression toCallExpressionFromStatement(@Nullable JSStatement statement) {
        if (statement instanceof JSExpressionStatement) {
            JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), JSCallExpression.class);
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)returnStatement.getExpression(), JSCallExpression.class);
        }
        return null;
    }

    public static JSProperty @NotNull [] getProperties(@NotNull JSObjectLiteralExpression objectLiteralExpression) {
        if (objectLiteralExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(20);
        }
        JSProperty[] properties = objectLiteralExpression.getProperties();
        int cnt = 0;
        for (JSProperty property : properties) {
            if (property == null) continue;
            ++cnt;
        }
        if (cnt < properties.length) {
            JSProperty[] a = new JSProperty[cnt];
            int id = 0;
            for (JSProperty property : properties) {
                if (property == null) continue;
                a[id] = property;
                ++id;
            }
            if (a == null) {
                JsPsiUtils.$$$reportNull$$$0(21);
            }
            return a;
        }
        if (properties == null) {
            JsPsiUtils.$$$reportNull$$$0(22);
        }
        return properties;
    }

    public static boolean containsOffsetStrictly(@NotNull TextRange textRange, int offset) {
        if (textRange == null) {
            JsPsiUtils.$$$reportNull$$$0(23);
        }
        return textRange.getStartOffset() < offset && offset < textRange.getEndOffset();
    }

    public static JSExpression @NotNull [] getArguments(@Nullable JSArgumentList argumentList) {
        JSExpression[] expressions = null;
        if (argumentList != null) {
            expressions = argumentList.getArguments();
        }
        if (expressions == null) {
            expressions = JSExpression.EMPTY_ARRAY;
        }
        if (expressions == null) {
            JsPsiUtils.$$$reportNull$$$0(24);
        }
        return expressions;
    }

    public static JSExpression @NotNull [] getArguments(@NotNull JSCallExpression jsCallExpression) {
        if (jsCallExpression == null) {
            JsPsiUtils.$$$reportNull$$$0(25);
        }
        return JsPsiUtils.getArguments(jsCallExpression.getArgumentList());
    }

    @Nullable
    public static PsiElement getPropertyNamePsiElement(@NotNull JSProperty property) {
        if (property == null) {
            JsPsiUtils.$$$reportNull$$$0(26);
        }
        return (PsiElement)ObjectUtils.tryCast((Object)property.getFirstChild(), LeafPsiElement.class);
    }

    @Nullable
    public static String getPropertyName(@NotNull JSProperty property) {
        PsiElement testMethodNameDeclaration;
        if (property == null) {
            JsPsiUtils.$$$reportNull$$$0(27);
        }
        if ((testMethodNameDeclaration = JsPsiUtils.getPropertyNamePsiElement(property)) == null) {
            return null;
        }
        return StringUtil.unquoteString((String)testMethodNameDeclaration.getText());
    }

    public static boolean isElementOfType(@Nullable PsiElement psiElement, @NotNull IElementType type) {
        if (type == null) {
            JsPsiUtils.$$$reportNull$$$0(28);
        }
        if (psiElement instanceof ASTNode) {
            ASTNode node = (ASTNode)psiElement;
            return node.getElementType() == type;
        }
        return false;
    }

    @Nullable
    public static PsiElement getFunctionLeftBrace(@Nullable JSFunction function) {
        if (function == null) {
            return null;
        }
        JSBlockStatement block = function.getBlock();
        return block == null ? null : block.getFirstChild();
    }

    @Nullable
    public static Document getDocument(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            JsPsiUtils.$$$reportNull$$$0(29);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(psiFile);
    }

    @Nullable
    private static JSElement getNearestContainingScopeElement(@NotNull JSElement element) {
        if (element == null) {
            JsPsiUtils.$$$reportNull$$$0(30);
        }
        PsiElement parent = element.getParent();
        while (parent != null) {
            if (parent instanceof JSFunction) {
                return (JSFunction)parent;
            }
            if (parent instanceof PsiFile) {
                return (JSElement)ObjectUtils.tryCast((Object)parent, JSFile.class);
            }
            PsiElement newParent = parent.getParent();
            if (newParent == parent) break;
            parent = newParent;
        }
        return null;
    }

    @NotNull
    private static List<JSStatement> getTopLevelStatementsOf(@NotNull JSElement parent) {
        JSBlockStatement block;
        if (parent == null) {
            JsPsiUtils.$$$reportNull$$$0(31);
        }
        JSSourceElement[] elements = JSSourceElement.EMPTY_ARRAY;
        if (parent instanceof JSFile) {
            JSFile jsFile = (JSFile)parent;
            elements = jsFile.getStatements();
        } else if (parent instanceof JSFunction && (block = ((JSFunction)parent).getBlock()) != null) {
            elements = block.getStatementListItems();
        }
        ArrayList<JSStatement> out = new ArrayList<JSStatement>();
        for (JSSourceElement element : elements) {
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)element, out);
        }
        ArrayList<JSStatement> arrayList = out;
        if (arrayList == null) {
            JsPsiUtils.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    public static String wrapWithMostFrequentQuote(@NotNull JSFile jsFile, String stringLiteralValue) {
        if (jsFile == null) {
            JsPsiUtils.$$$reportNull$$$0(33);
        }
        QuoteCountingVisitor visitor = new QuoteCountingVisitor();
        visitor.visitFile((PsiFile)jsFile);
        char quoteChar = visitor.mySingleQuotes == visitor.myDoubleQuotes ? (char)'\'' : (visitor.mySingleQuotes < visitor.myDoubleQuotes ? (char)'\"' : '\'');
        String string = quoteChar + stringLiteralValue + quoteChar;
        if (string == null) {
            JsPsiUtils.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static boolean mightContainGlobalCall(@NotNull PsiFile file, @NotNull String globalName, boolean globalAsQualifier) {
        if (file == null) {
            JsPsiUtils.$$$reportNull$$$0(35);
        }
        if (globalName == null) {
            JsPsiUtils.$$$reportNull$$$0(36);
        }
        return JsPsiUtils.mightContainGlobalCall(file.getViewProvider().getContents(), globalName, globalAsQualifier);
    }

    public static boolean mightContainGlobalCall(@NotNull CharSequence fileContents, @NotNull String globalName, boolean globalAsQualifier) {
        if (fileContents == null) {
            JsPsiUtils.$$$reportNull$$$0(37);
        }
        if (globalName == null) {
            JsPsiUtils.$$$reportNull$$$0(38);
        }
        int ind = StringUtil.indexOf((CharSequence)fileContents, (CharSequence)globalName);
        while (ind >= 0) {
            char prevChar;
            char c = prevChar = ind > 0 ? (char)fileContents.charAt(ind - 1) : (char)' ';
            if (prevChar != '.' && prevChar != '_' && !Character.isLetterOrDigit(prevChar)) {
                char nextChar;
                int nextCharInd = ind + globalName.length();
                char c2 = nextChar = nextCharInd < fileContents.length() ? (char)fileContents.charAt(nextCharInd) : (char)'(';
                if (nextChar == '(' || Character.isWhitespace(nextChar)) {
                    return true;
                }
                if (globalAsQualifier && nextChar == '.') {
                    return true;
                }
            }
            ind = StringUtil.indexOf((CharSequence)fileContents, (CharSequence)globalName, (int)(ind + globalName.length() + 1));
        }
        return false;
    }

    @NotNull
    public static JSTestNamePattern buildPatternUsingResolve(@NotNull JSExpression expr) {
        JSExpression initializer;
        String literalValue;
        if (expr == null) {
            JsPsiUtils.$$$reportNull$$$0(39);
        }
        if ((literalValue = JsPsiUtils.getConstantLiteralValue((JSLiteralExpression)ObjectUtils.tryCast((Object)expr, JSLiteralExpression.class))) != null) {
            JSTestNamePattern jSTestNamePattern = JSTestNamePattern.literalPattern(literalValue);
            if (jSTestNamePattern == null) {
                JsPsiUtils.$$$reportNull$$$0(40);
            }
            return jSTestNamePattern;
        }
        JSTestNamePattern referencePattern = JsPsiUtils.getReferencePattern((JSReferenceExpression)ObjectUtils.tryCast((Object)expr, JSReferenceExpression.class));
        if (referencePattern != null) {
            JSTestNamePattern jSTestNamePattern = referencePattern;
            if (jSTestNamePattern == null) {
                JsPsiUtils.$$$reportNull$$$0(41);
            }
            return jSTestNamePattern;
        }
        JSTestNamePattern plusOperationPattern = JsPsiUtils.getPlusOperationPattern((JSBinaryExpression)ObjectUtils.tryCast((Object)expr, JSBinaryExpression.class));
        if (plusOperationPattern != null) {
            JSTestNamePattern jSTestNamePattern = plusOperationPattern;
            if (jSTestNamePattern == null) {
                JsPsiUtils.$$$reportNull$$$0(42);
            }
            return jSTestNamePattern;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            JSTestNamePattern jSTestNamePattern = JSTestNamePattern.literalPattern(JsPsiUtils.extractStringValue(initializer));
            if (jSTestNamePattern == null) {
                JsPsiUtils.$$$reportNull$$$0(43);
            }
            return jSTestNamePattern;
        }
        JSTestNamePattern templateStringPattern = JsPsiUtils.getTemplateStringPattern((JSStringTemplateExpression)ObjectUtils.tryCast((Object)expr, JSStringTemplateExpression.class));
        if (templateStringPattern != null) {
            JSTestNamePattern jSTestNamePattern = templateStringPattern;
            if (jSTestNamePattern == null) {
                JsPsiUtils.$$$reportNull$$$0(44);
            }
            return jSTestNamePattern;
        }
        JSTestNamePattern jSTestNamePattern = JSTestNamePattern.pattern(JSTestNamePattern.anyRange(expr.getText()));
        if (jSTestNamePattern == null) {
            JsPsiUtils.$$$reportNull$$$0(45);
        }
        return jSTestNamePattern;
    }

    @Nullable
    private static JSTestNamePattern getReferencePattern(@Nullable JSReferenceExpression referenceExpr) {
        String referenceName;
        if (referenceExpr != null && (referenceName = referenceExpr.getReferenceName()) != null) {
            String className;
            PsiElement resolvedQualifier;
            PsiElement resolvedElement;
            VirtualFile file;
            if (referenceExpr.getQualifier() == null && referenceName.equals("__filename") && (file = PsiUtilCore.getVirtualFile((PsiElement)referenceExpr)) != null) {
                return JSTestNamePattern.literalPattern(FileUtil.toSystemDependentName((String)file.getPath()));
            }
            if (referenceExpr.getQualifier() == null && referenceName.equals("__dirname")) {
                file = PsiUtilCore.getVirtualFile((PsiElement)referenceExpr);
                VirtualFile virtualFile = file = file == null ? null : file.getParent();
                if (file != null) {
                    return JSTestNamePattern.literalPattern(FileUtil.toSystemDependentName((String)file.getPath()));
                }
            }
            if ((resolvedElement = JsPsiUtils.resolveStrictly(referenceExpr)) instanceof JSClassBase || resolvedElement instanceof JSFunction) {
                return JSTestNamePattern.literalPattern(referenceName);
            }
            JSReferenceExpression qualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)referenceExpr.getQualifier(), JSReferenceExpression.class);
            if (referenceName.equals("name") && qualifier != null && (resolvedQualifier = JsPsiUtils.resolveStrictly(qualifier)) instanceof JSClassBase && (className = ((JSClassBase)resolvedQualifier).getName()) != null) {
                return JSTestNamePattern.literalPattern(className);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveStrictly(@NotNull JSReferenceExpression referenceExpr) {
        ResolveResult[] resolveResults;
        if (referenceExpr == null) {
            JsPsiUtils.$$$reportNull$$$0(46);
        }
        if ((resolveResults = referenceExpr.multiResolve(false)).length == 1 && JSResolveUtil.isResolveStrict((PsiReference)referenceExpr, (ResolveResult[])resolveResults)) {
            return resolveResults[0].getElement();
        }
        return null;
    }

    @Nullable
    private static String getConstantLiteralValue(@Nullable JSLiteralExpression literalExpr) {
        if (literalExpr == null) {
            return null;
        }
        if (literalExpr.isStringLiteral()) {
            return JsPsiUtils.unescapeBackslashes(StringUtil.unquoteString((String)StringUtil.notNullize((String)literalExpr.getText())));
        }
        if (literalExpr.isNumericLiteral()) {
            return Objects.requireNonNull(literalExpr.getText());
        }
        return null;
    }

    @Nullable
    private static JSTestNamePattern getPlusOperationPattern(@Nullable JSBinaryExpression binaryExpr) {
        IElementType operationType;
        if (binaryExpr != null && (operationType = binaryExpr.getOperationSign()) == BaseJSTokenTypes.PLUS) {
            JSExpression leftOperand = binaryExpr.getLOperand();
            JSExpression rightOperand = binaryExpr.getROperand();
            if (leftOperand != null && rightOperand != null) {
                JSTestNamePattern leftPattern = JsPsiUtils.buildPatternUsingResolve(leftOperand);
                JSTestNamePattern rightPattern = JsPsiUtils.buildPatternUsingResolve(rightOperand);
                return JSTestNamePattern.normalizeAndCreate(ContainerUtil.concat(leftPattern.getRanges(), rightPattern.getRanges()));
            }
        }
        return null;
    }

    @Nullable
    private static JSTestNamePattern getTemplateStringPattern(@Nullable JSStringTemplateExpression templateExpr) {
        if (templateExpr == null || !templateExpr.isQuotedLiteral()) {
            return null;
        }
        String templateText = templateExpr.getText();
        TextRange templateTextRange = templateExpr.getTextRange();
        if (templateText.length() < 2 || templateText.charAt(0) != templateText.charAt(templateText.length() - 1)) {
            return null;
        }
        ArrayList pairs = new ArrayList();
        pairs.addAll(ContainerUtil.map((Object[])templateExpr.getArguments(), expression -> new Pair(expression, (Object)expression.getTextRange().shiftLeft(templateTextRange.getStartOffset()))));
        pairs.addAll(ContainerUtil.map((Object[])templateExpr.getStringRanges(), textRange -> new Pair(null, textRange)));
        Collections.sort(pairs, Comparator.comparingInt(o -> ((TextRange)o.second).getStartOffset()));
        ArrayList<JSTestNamePattern.Range> ranges = new ArrayList<JSTestNamePattern.Range>();
        for (Pair pair : pairs) {
            if (pair.first == null) {
                if (((TextRange)pair.second).getLength() <= 0) continue;
                ranges.add(new JSTestNamePattern.Literal(((TextRange)pair.second).substring(templateText)));
                continue;
            }
            JSTestNamePattern childPattern = JsPsiUtils.buildPatternUsingResolve((JSExpression)pair.first);
            ranges.addAll(childPattern.getRanges());
        }
        return JSTestNamePattern.normalizeAndCreate(ranges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/util/JsPsiUtils";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsReferenceExpression";
                break;
            }
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcExpr";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsm";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteralExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCallExpression";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/util/JsPsiUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackslashes";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listStatementsInExecutionOrder";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStatementsOf";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithMostFrequentQuote";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatternUsingResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodNameLeafElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackslashes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedChar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendCodePoint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractInitExpression";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "listStatementsInExecutionOrder";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectJsStatementsInExecutionOrder";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unwrapCallExpression";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectStatementsInsideModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "containsOffsetStrictly";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getArguments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNamePsiElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isElementOfType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNearestContainingScopeElement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelStatementsOf";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithMostFrequentQuote";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "mightContainGlobalCall";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "buildPatternUsingResolve";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveStrictly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 24: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QuoteCountingVisitor
    extends JSRecursiveWalkingElementVisitor {
        private int myDoubleQuotes = 0;
        private int mySingleQuotes = 0;

        private QuoteCountingVisitor() {
        }

        public void visitJSLiteralExpression(JSLiteralExpression expr) {
            if (expr.isQuotedLiteral()) {
                CharSequence seq;
                LeafPsiElement firstChild = (LeafPsiElement)ObjectUtils.tryCast((Object)expr.getFirstChild(), LeafPsiElement.class);
                CharSequence charSequence = seq = firstChild != null ? firstChild.getChars() : expr.getText();
                if (StringUtil.startsWithChar((CharSequence)seq, (char)'\"')) {
                    ++this.myDoubleQuotes;
                } else {
                    ++this.mySingleQuotes;
                }
            }
        }
    }
}

