/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u001a\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00050\u00050\u0004*\u00020\u0007H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "", "()V", "getAccessibleRemoteUrls", "", "", "repository", "Lgit4idea/repo/GitRepository;", "getKnownGithubServers", "", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getPossibleRemoteUrlCoordinates", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "project", "Lcom/intellij/openapi/project/Project;", "getPossibleRepositories", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRemoteUrl", "server", "user", "repo", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "hasAccessibleRemotes", "", "havePossibleRemotes", "isRemoteUrlAccessible", "url", "getRemoteUrls", "kotlin.jvm.PlatformType", "Companion", "intellij.vcs.github"})
public final class GithubGitHelper {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)repoPath, (String)"repoPath");
        return this.getRemoteUrl(server, repoPath.getOwner(), repoPath.getRepository());
    }

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull String user, @NotNull String repo) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        GithubSettings githubSettings = GithubSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)githubSettings, (String)"GithubSettings.getInstance()");
        if (githubSettings.isCloneGitUsingSsh()) {
            String string2;
            String string3;
            StringBuilder stringBuilder;
            int n;
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append("git@").append(server.getHost()).append(':');
            String string5 = server.getSuffix();
            if (string5 != null) {
                string4 = string5;
                n = 1;
                stringBuilder = stringBuilder2;
                boolean bl = false;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string3 = string7;
                stringBuilder2 = stringBuilder;
                string2 = string3;
            } else {
                string2 = null;
            }
            string4 = string2;
            stringBuilder = stringBuilder2;
            n = 0;
            String string8 = string4;
            if (string8 == null) {
                string8 = "";
            }
            string3 = string8;
            string = stringBuilder.append(string3).append('/').append(user).append('/').append(repo).append(".git").toString();
        } else {
            String string9 = server.getSuffix();
            StringBuilder stringBuilder = new StringBuilder().append("https://").append(server.getHost());
            boolean bl = false;
            String string10 = string9;
            if (string10 == null) {
                string10 = "";
            }
            String string11 = string10;
            string = stringBuilder.append(string11).append('/').append(user).append('/').append(repo).append(".git").toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAccessibleRemoteUrls(@NotNull GitRepository repository) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Iterable iterable = this.getRemoteUrls(repository);
        GithubGitHelper githubGitHelper = this;
        boolean $i$f$filter = false;
        void var5_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p1 = (String)element$iv$iv;
            boolean bl = false;
            if (!githubGitHelper.isRemoteUrlAccessible(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasAccessibleRemotes(@NotNull GitRepository repository) {
        boolean bl;
        block3: {
            void $this$any$iv;
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Iterable iterable = this.getRemoteUrls(repository);
            GithubGitHelper githubGitHelper = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String p1 = (String)element$iv;
                    boolean bl2 = false;
                    if (!githubGitHelper.isRemoteUrlAccessible(p1)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isRemoteUrlAccessible(String url) {
        Object v0;
        block1: {
            Iterable iterable = GithubAuthenticationManager.Companion.getInstance().getAccounts();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                GithubAccount it = (GithubAccount)t;
                boolean bl3 = false;
                if (!it.getServer().matches(url)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<GHRepositoryCoordinates> getPossibleRepositories(@NotNull GitRepository repository) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Set<GithubServerPath> knownServers = this.getKnownGithubServers();
        Iterable $this$mapNotNull$iv = this.getRemoteUrls(repository);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GHRepositoryCoordinates gHRepositoryCoordinates;
            Object v0;
            boolean bl;
            Object object;
            String url;
            block6: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                url = (String)element$iv$iv;
                boolean bl3 = false;
                object = knownServers;
                bl = false;
                Iterable iterable2 = object;
                boolean bl4 = false;
                for (Object object2 : iterable2) {
                    GithubServerPath it = (GithubServerPath)object2;
                    boolean bl5 = false;
                    if (!it.matches(url)) continue;
                    v0 = object2;
                    break block6;
                }
                v0 = null;
            }
            GithubServerPath githubServerPath = v0;
            if (githubServerPath != null) {
                object = githubServerPath;
                bl = false;
                boolean bl6 = false;
                Object server = object;
                boolean bl7 = false;
                if (GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url) != null) {
                    Object object2;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Object it = object2;
                    boolean bl10 = false;
                    Object object3 = it;
                    Intrinsics.checkExpressionValueIsNotNull(object3, (String)"it");
                    gHRepositoryCoordinates = new GHRepositoryCoordinates((GithubServerPath)server, (GHRepositoryPath)object3);
                } else {
                    gHRepositoryCoordinates = null;
                }
            } else {
                gHRepositoryCoordinates = null;
            }
            if (gHRepositoryCoordinates == null) continue;
            GHRepositoryCoordinates gHRepositoryCoordinates2 = gHRepositoryCoordinates;
            boolean bl11 = false;
            boolean bl12 = false;
            GHRepositoryCoordinates it$iv$iv = gHRepositoryCoordinates2;
            boolean bl13 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<GitRemoteUrlCoordinates> getPossibleRemoteUrlCoordinates(@NotNull Project project) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitRepositoryManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        List list2 = ((GitRepositoryManager)object).getRepositories();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"project.service<GitRepos\u2026ryManager>().repositories");
        List repositories = list2;
        if (repositories.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set<GithubServerPath> knownServers = this.getKnownGithubServers();
        Iterable $this$flatMap$iv = repositories;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            GitRepository repo = (GitRepository)element$iv$iv;
            boolean bl = false;
            GitRepository gitRepository = repo;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repo");
            Collection collection = gitRepository.getRemotes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repo.remotes");
            Iterable $this$flatMap$iv2 = collection;
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$mapNotNullTo$iv$iv;
                GitRemote remote = (GitRemote)element$iv$iv2;
                boolean bl2 = false;
                GitRemote gitRemote = remote;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote, (String)"remote");
                List list3 = gitRemote.getUrls();
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"remote.urls");
                Iterable $this$mapNotNull$iv = list3;
                boolean $i$f$mapNotNull = false;
                Iterable iterable3 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    GitRemoteUrlCoordinates gitRemoteUrlCoordinates;
                    boolean bl3;
                    String url;
                    block9: {
                        Object element$iv$iv$iv;
                        Object element$iv$iv3 = element$iv$iv$iv = iterator.next();
                        boolean bl4 = false;
                        url = (String)element$iv$iv3;
                        boolean bl5 = false;
                        Iterable $this$any$iv = knownServers;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                GithubServerPath it = (GithubServerPath)element$iv;
                                boolean bl6 = false;
                                if (!it.matches(url)) continue;
                                bl3 = true;
                                break block9;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        String string = url;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
                        gitRemoteUrlCoordinates = new GitRemoteUrlCoordinates(string, remote, repo);
                    } else {
                        gitRemoteUrlCoordinates = null;
                    }
                    if (gitRemoteUrlCoordinates == null) continue;
                    GitRemoteUrlCoordinates gitRemoteUrlCoordinates2 = gitRemoteUrlCoordinates;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    GitRemoteUrlCoordinates it$iv$iv = gitRemoteUrlCoordinates2;
                    boolean bl9 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean havePossibleRemotes(@NotNull Project project) {
        boolean bl;
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GitRepositoryManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
            List list2 = ((GitRepositoryManager)object).getRepositories();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"project.service<GitRepos\u2026ryManager>().repositories");
            List repositories = list2;
            if (repositories.isEmpty()) {
                return false;
            }
            Set<GithubServerPath> knownServers = this.getKnownGithubServers();
            Iterable $this$any$iv = repositories;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block11: {
                        GitRepository repo = (GitRepository)element$iv;
                        boolean bl3 = false;
                        GitRepository gitRepository = repo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repo");
                        Iterable $this$any$iv2 = this.getRemoteUrls(gitRepository);
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                boolean bl4;
                                block10: {
                                    String url = (String)element$iv2;
                                    boolean bl5 = false;
                                    Iterable $this$any$iv3 = knownServers;
                                    boolean $i$f$any3 = false;
                                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                        bl4 = false;
                                    } else {
                                        for (Object element$iv3 : $this$any$iv3) {
                                            GithubServerPath it = (GithubServerPath)element$iv3;
                                            boolean bl6 = false;
                                            if (!it.matches(url)) continue;
                                            bl4 = true;
                                            break block10;
                                        }
                                        bl4 = false;
                                    }
                                }
                                if (!bl4) continue;
                                bl2 = true;
                                break block11;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<GithubServerPath> getKnownGithubServers() {
        Set registeredServers = SetsKt.mutableSetOf((Object[])new GithubServerPath[]{GithubServerPath.DEFAULT_SERVER});
        GithubServerPath githubServerPath = GithubAccountsMigrationHelper.Companion.getInstance().getOldServer$intellij_vcs_github();
        if (githubServerPath != null) {
            GithubServerPath githubServerPath2 = githubServerPath;
            boolean bl = false;
            boolean bl2 = false;
            GithubServerPath p1 = githubServerPath2;
            boolean bl3 = false;
            registeredServers.add(p1);
        }
        Iterable $this$mapTo$iv = GithubAuthenticationManager.Companion.getInstance().getAccounts();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            GithubAccount bl3 = (GithubAccount)item$iv;
            Collection collection = registeredServers;
            boolean bl = false;
            GithubServerPath githubServerPath3 = it.getServer();
            collection.add(githubServerPath3);
        }
        return registeredServers;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRemoteUrls(@NotNull GitRepository $this$getRemoteUrls) {
        void $this$mapTo$iv$iv;
        Collection collection = $this$getRemoteUrls.getRemotes();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"remotes");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitRemote gitRemote = (GitRemote)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            List list2 = v1.getUrls();
            collection2.add(list2);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    @Nullable
    public static final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @NotNull
    public static final GithubGitHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper$Companion;", "", "()V", "findGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
            GitRepository repository;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
            GitRepositoryManager manager = gitRepositoryManager;
            List list2 = manager.getRepositories();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"manager.repositories");
            List repositories = list2;
            if (repositories.size() == 0) {
                return null;
            }
            if (repositories.size() == 1) {
                return (GitRepository)repositories.get(0);
            }
            if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
                return repository;
            }
            return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
        }

        public static /* synthetic */ GitRepository findGitRepository$default(Companion companion, Project project, VirtualFile virtualFile, int n, Object object) {
            if ((n & 2) != 0) {
                virtualFile = null;
            }
            return companion.findGitRepository(project, virtualFile);
        }

        @JvmStatic
        @NotNull
        public final GithubGitHelper getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(GithubGitHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (GithubGitHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

