/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import icons.GithubIcons;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SizeRequirements;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ParagraphView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;", "Ljavax/swing/JEditorPane;", "body", "", "(Ljava/lang/String;)V", "()V", "setBody", "", "updateUI", "intellij.vcs.github"})
public final class HtmlEditorPane
extends JEditorPane {
    public final void setBody(@NotNull String body2) {
        Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
        CharSequence charSequence = body2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            this.setText("");
        } else {
            this.setText("<html><body>" + body2 + "</body></html>");
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        UISettings.Companion.setupComponentAntialiasing((JComponent)this);
    }

    public HtmlEditorPane() {
        this.setEditorKit((EditorKit)new JBHtmlEditorKit(true){

            @NotNull
            public ViewFactory getViewFactory() {
                return (ViewFactory)new JBHtmlEditorKit.JBHtmlFactory(){

                    @NotNull
                    public View create(@NotNull Element elem) {
                        View view;
                        Intrinsics.checkParameterIsNotNull((Object)elem, (String)"elem");
                        if (Intrinsics.areEqual((Object)"icon-inline", (Object)elem.getName())) {
                            Icon icon;
                            Icon icon2;
                            Object object = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                            if (object != null) {
                                Object object2 = object;
                                boolean bl = false;
                                boolean bl2 = false;
                                Object it = object2;
                                boolean bl3 = false;
                                Object object3 = it;
                                if (object3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                                }
                                icon2 = IconLoader.getIcon((String)((String)object3), GithubIcons.class);
                            } else {
                                icon2 = icon = null;
                            }
                            if (icon != null) {
                                return new InlineView(icon, elem, elem){
                                    final /* synthetic */ Icon $icon;
                                    final /* synthetic */ Element $elem;

                                    public float getPreferredSpan(int axis) {
                                        switch (axis) {
                                            case 0: {
                                                return (float)this.$icon.getIconWidth() + super.getPreferredSpan(axis);
                                            }
                                        }
                                        return super.getPreferredSpan(axis);
                                    }

                                    public void paint(@NotNull Graphics g, @NotNull Shape allocation) {
                                        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
                                        Intrinsics.checkParameterIsNotNull((Object)allocation, (String)"allocation");
                                        super.paint(g, allocation);
                                        this.$icon.paintIcon(null, g, allocation.getBounds().x, allocation.getBounds().y);
                                    }
                                    {
                                        this.$icon = $captured_local_variable$0;
                                        this.$elem = $captured_local_variable$1;
                                        super($super_call_param$2);
                                    }
                                };
                            }
                        }
                        if ((view = super.create(elem)) instanceof ParagraphView) {
                            return new ParagraphView(elem, elem){
                                final /* synthetic */ Element $elem;

                                @NotNull
                                protected SizeRequirements calculateMinorAxisRequirements(int axis, @Nullable SizeRequirements r) {
                                    int n;
                                    SizeRequirements r2 = r;
                                    if (r2 == null) {
                                        r2 = new SizeRequirements();
                                    }
                                    int n2 = r2.minimum = (int)this.layoutPool.getMinimumSpan(axis);
                                    int n3 = (int)this.layoutPool.getPreferredSpan(axis);
                                    SizeRequirements sizeRequirements = r2;
                                    boolean bl = false;
                                    sizeRequirements.preferred = n = Math.max(n2, n3);
                                    r2.maximum = Integer.MAX_VALUE;
                                    r2.alignment = 0.5f;
                                    return r2;
                                }
                                {
                                    this.$elem = $captured_local_variable$0;
                                    super($super_call_param$1);
                                }
                            };
                        }
                        View view2 = view;
                        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
                        return view2;
                    }
                };
            }
        });
        this.setEditable(false);
        this.setOpaque(false);
        this.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.setMargin((Insets)JBUI.emptyInsets());
        Caret caret = this.getCaret();
        if (caret == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.text.DefaultCaret");
        }
        DefaultCaret caret2 = (DefaultCaret)caret;
        caret2.setUpdatePolicy(1);
    }

    public HtmlEditorPane(@NotNull String body2) {
        Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
        this();
        this.setBody(body2);
    }
}

