/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.GithubIcons;
import java.awt.Color;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHGitRefName;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRAssignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRBaseRefChangedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRBaseRefForcePushedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefDeletedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefForcePushedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRHeadRefRestoredEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRLabeledEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRRenamedTitleEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewDismissedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewRequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRReviewUnrequestedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnassignedEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRUnlabeledEvent;
import org.jetbrains.plugins.github.pullrequest.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory$WhenMappings;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineMergedSimpleEvents;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\b\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;", "(Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;)V", "branchEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$BranchEventComponentFactory;", "complexEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$ComplexEventComponentFactory;", "simpleEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$SimpleEventComponentFactory;", "stateEventDelegate", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory;", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "throwUnknownType", "", "item", "BranchEventComponentFactory", "Companion", "ComplexEventComponentFactory", "EventComponentFactory", "SimpleEventComponentFactory", "StateEventComponentFactory", "intellij.vcs.github"})
public final class GHPRTimelineEventComponentFactoryImpl
implements GHPRTimelineEventComponentFactory<GHPRTimelineEvent> {
    private final SimpleEventComponentFactory simpleEventDelegate;
    private final StateEventComponentFactory stateEventDelegate;
    private final BranchEventComponentFactory branchEventDelegate;
    private final ComplexEventComponentFactory complexEventDelegate;
    private final GHAvatarIconsProvider avatarIconsProvider;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent event) {
        GHPRTimelineItemComponentFactory.Item item;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        GHPRTimelineEvent gHPRTimelineEvent = event;
        if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Simple) {
            item = this.simpleEventDelegate.createComponent((GHPRTimelineEvent.Simple)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.State) {
            item = this.stateEventDelegate.createComponent((GHPRTimelineEvent.State)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Branch) {
            item = this.branchEventDelegate.createComponent((GHPRTimelineEvent.Branch)event);
        } else if (gHPRTimelineEvent instanceof GHPRTimelineEvent.Complex) {
            item = this.complexEventDelegate.createComponent((GHPRTimelineEvent.Complex)event);
        } else {
            Void void_ = this.throwUnknownType(event);
            throw null;
        }
        return item;
    }

    private final Void throwUnknownType(GHPRTimelineEvent item) {
        throw (Throwable)new IllegalStateException("Unknown event type \"" + item.getClass().getCanonicalName() + '\"');
    }

    public GHPRTimelineEventComponentFactoryImpl(@NotNull GHAvatarIconsProvider avatarIconsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
        this.avatarIconsProvider = avatarIconsProvider;
        this.simpleEventDelegate = new SimpleEventComponentFactory();
        this.stateEventDelegate = new StateEventComponentFactory();
        this.branchEventDelegate = new BranchEventComponentFactory();
        this.complexEventDelegate = new ComplexEventComponentFactory();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00a2\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0004\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "T", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "eventItem", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "markerIcon", "Ljavax/swing/Icon;", "item", "titleHTML", "", "intellij.vcs.github"})
    private abstract class EventComponentFactory<T extends GHPRTimelineEvent>
    implements GHPRTimelineEventComponentFactory<T> {
        @NotNull
        protected final GHPRTimelineItemComponentFactory.Item eventItem(@NotNull GHPRTimelineEvent item, @Language(value="HTML") @NotNull String titleHTML) {
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            Intrinsics.checkParameterIsNotNull((Object)titleHTML, (String)"titleHTML");
            Icon icon = GithubIcons.Timeline;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"GithubIcons.Timeline");
            return this.eventItem(icon, item, titleHTML);
        }

        @NotNull
        protected final GHPRTimelineItemComponentFactory.Item eventItem(@NotNull Icon markerIcon, @NotNull GHPRTimelineEvent item, @Language(value="HTML") @NotNull String titleHTML) {
            Intrinsics.checkParameterIsNotNull((Object)markerIcon, (String)"markerIcon");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            Intrinsics.checkParameterIsNotNull((Object)titleHTML, (String)"titleHTML");
            return new GHPRTimelineItemComponentFactory.Item(markerIcon, GHPRTimelineItemComponentFactory.Companion.actionTitle(GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider, item.getActor(), titleHTML, item.getCreatedAt()), null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\u00062\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J(\u0010\u0017\u001a\u00020\u00062\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\bH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$SimpleEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "assigneesHTML", "", "assigned", "", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "unassigned", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "labelHTML", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "labelsHTML", "added", "removed", "renameHTML", "oldName", "newName", "reviewersHTML", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "intellij.vcs.github"})
    private final class SimpleEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Simple> {
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.Simple event) {
            GHPRTimelineItemComponentFactory.Item item;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            GHPRTimelineEvent.Simple simple = event;
            if (simple instanceof GHPRAssignedEvent) {
                item = this.eventItem(event, SimpleEventComponentFactory.assigneesHTML$default(this, CollectionsKt.listOf((Object)((GHPRAssignedEvent)event).getUser()), null, 2, null));
            } else if (simple instanceof GHPRUnassignedEvent) {
                item = this.eventItem(event, SimpleEventComponentFactory.assigneesHTML$default(this, null, CollectionsKt.listOf((Object)((GHPRUnassignedEvent)event).getUser()), 1, null));
            } else if (simple instanceof GHPRReviewRequestedEvent) {
                item = this.eventItem(event, SimpleEventComponentFactory.reviewersHTML$default(this, CollectionsKt.listOf((Object)((GHPRReviewRequestedEvent)event).getRequestedReviewer()), null, 2, null));
            } else if (simple instanceof GHPRReviewUnrequestedEvent) {
                item = this.eventItem(event, SimpleEventComponentFactory.reviewersHTML$default(this, null, CollectionsKt.listOf((Object)((GHPRReviewUnrequestedEvent)event).getRequestedReviewer()), 1, null));
            } else if (simple instanceof GHPRLabeledEvent) {
                item = this.eventItem(event, SimpleEventComponentFactory.labelsHTML$default(this, CollectionsKt.listOf((Object)((GHPRLabeledEvent)event).getLabel()), null, 2, null));
            } else if (simple instanceof GHPRUnlabeledEvent) {
                item = this.eventItem(event, SimpleEventComponentFactory.labelsHTML$default(this, null, CollectionsKt.listOf((Object)((GHPRUnlabeledEvent)event).getLabel()), 1, null));
            } else if (simple instanceof GHPRRenamedTitleEvent) {
                item = this.eventItem(event, this.renameHTML(((GHPRRenamedTitleEvent)event).getPreviousTitle(), ((GHPRRenamedTitleEvent)event).getCurrentTitle()));
            } else if (simple instanceof GHPRTimelineMergedSimpleEvents) {
                Object object;
                Object object2;
                boolean bl;
                boolean bl2;
                Companion companion;
                StringBuilder stringBuilder;
                Object object3;
                Companion companion2 = Companion;
                StringBuilder stringBuilder2 = Companion.appendParagraph(Companion.appendParagraph(Companion.appendParagraph(new StringBuilder(), this.labelsHTML((Collection<GHLabel>)((GHPRTimelineMergedSimpleEvents)event).getAddedLabels(), (Collection<GHLabel>)((GHPRTimelineMergedSimpleEvents)event).getRemovedLabels())), this.assigneesHTML((Collection<GHUser>)((GHPRTimelineMergedSimpleEvents)event).getAssignedPeople(), (Collection<GHUser>)((GHPRTimelineMergedSimpleEvents)event).getUnassignedPeople())), this.reviewersHTML((Collection<? extends GHPullRequestRequestedReviewer>)((GHPRTimelineMergedSimpleEvents)event).getAddedReviewers(), (Collection<? extends GHPullRequestRequestedReviewer>)((GHPRTimelineMergedSimpleEvents)event).getRemovedReviewers()));
                Pair<String, String> pair = ((GHPRTimelineMergedSimpleEvents)event).getRename();
                if (pair != null) {
                    object3 = pair;
                    stringBuilder = stringBuilder2;
                    companion = companion2;
                    bl2 = false;
                    bl = false;
                    Pair<String, String> it = object3;
                    boolean bl3 = false;
                    object2 = this.renameHTML((String)it.getFirst(), (String)it.getSecond());
                    companion2 = companion;
                    stringBuilder2 = stringBuilder;
                    object = object2;
                } else {
                    object = null;
                }
                object3 = object;
                stringBuilder = stringBuilder2;
                companion = companion2;
                bl2 = false;
                Object object4 = object3;
                if (object4 == null) {
                    object4 = "";
                }
                object2 = object4;
                StringBuilder builder = companion.appendParagraph(stringBuilder, object2);
                Icon icon = GithubIcons.Timeline;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"GithubIcons.Timeline");
                JComponent jComponent = GHPRTimelineItemComponentFactory.Companion.actionTitle(GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider, event.getActor(), "", event.getCreatedAt());
                String string = builder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
                object3 = new HtmlEditorPane(string);
                JComponent jComponent2 = jComponent;
                object2 = icon;
                bl2 = false;
                bl = false;
                Object $this$apply = object3;
                boolean bl4 = false;
                ((JComponent)$this$apply).setBorder((Border)JBUI.Borders.emptyLeft((int)28));
                ((JComponent)$this$apply).setForeground(UIUtil.getContextHelpForeground());
                Object object5 = object3;
                JComponent jComponent3 = (JComponent)object5;
                JComponent jComponent4 = jComponent2;
                Object object6 = object2;
                item = new GHPRTimelineItemComponentFactory.Item((Icon)object6, jComponent4, jComponent3);
            } else {
                Void void_ = GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw null;
            }
            return item;
        }

        private final String assigneesHTML(Collection<GHUser> assigned, Collection<GHUser> unassigned) {
            StringBuilder builder = new StringBuilder();
            Object object = assigned;
            boolean bl = false;
            if (!object.isEmpty()) {
                builder.append(CollectionsKt.joinToString$default((Iterable)assigned, null, (CharSequence)"assigned ", null, (int)0, null, (Function1)assigneesHTML.1.INSTANCE, (int)29, null));
            }
            object = unassigned;
            bl = false;
            if (!object.isEmpty()) {
                object = builder;
                bl = false;
                if (object.length() > 0) {
                    builder.append(" and ");
                }
                builder.append(CollectionsKt.joinToString$default((Iterable)unassigned, null, (CharSequence)"unassigned ", null, (int)0, null, (Function1)assigneesHTML.2.INSTANCE, (int)29, null));
            }
            String string = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            return string;
        }

        static /* synthetic */ String assigneesHTML$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.assigneesHTML(collection, collection2);
        }

        private final String reviewersHTML(Collection<? extends GHPullRequestRequestedReviewer> added, Collection<? extends GHPullRequestRequestedReviewer> removed) {
            StringBuilder builder = new StringBuilder();
            Object object = added;
            boolean bl = false;
            if (!object.isEmpty()) {
                builder.append(CollectionsKt.joinToString$default((Iterable)added, null, (CharSequence)"requested a review from ", null, (int)0, null, (Function1)reviewersHTML.1.INSTANCE, (int)29, null));
            }
            object = removed;
            bl = false;
            if (!object.isEmpty()) {
                object = builder;
                bl = false;
                if (object.length() > 0) {
                    builder.append(" and ");
                }
                builder.append(CollectionsKt.joinToString$default((Iterable)removed, null, (CharSequence)"removed review request from ", null, (int)0, null, (Function1)reviewersHTML.2.INSTANCE, (int)29, null));
            }
            String string = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            return string;
        }

        static /* synthetic */ String reviewersHTML$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.reviewersHTML(collection, collection2);
        }

        private final String labelsHTML(Collection<GHLabel> added, Collection<GHLabel> removed) {
            StringBuilder builder = new StringBuilder();
            Object object = added;
            boolean bl = false;
            if (!object.isEmpty()) {
                if (added.size() > 1) {
                    builder.append(CollectionsKt.joinToString$default((Iterable)added, null, (CharSequence)"added labels ", null, (int)0, null, (Function1)((Function1)new Function1<GHLabel, String>(this){
                        final /* synthetic */ SimpleEventComponentFactory this$0;

                        @NotNull
                        public final String invoke(@NotNull GHLabel it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return SimpleEventComponentFactory.access$labelHTML(this.this$0, it);
                        }
                        {
                            this.this$0 = simpleEventComponentFactory;
                            super(1);
                        }
                    }), (int)29, null));
                } else {
                    builder.append("added the ").append(this.labelHTML((GHLabel)CollectionsKt.first((Iterable)added))).append(" label");
                }
            }
            object = removed;
            bl = false;
            if (!object.isEmpty()) {
                object = builder;
                bl = false;
                if (object.length() > 0) {
                    builder.append(" and ");
                }
                if (removed.size() > 1) {
                    builder.append(CollectionsKt.joinToString$default((Iterable)removed, null, (CharSequence)"removed labels ", null, (int)0, null, (Function1)((Function1)new Function1<GHLabel, String>(this){
                        final /* synthetic */ SimpleEventComponentFactory this$0;

                        @NotNull
                        public final String invoke(@NotNull GHLabel it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return SimpleEventComponentFactory.access$labelHTML(this.this$0, it);
                        }
                        {
                            this.this$0 = simpleEventComponentFactory;
                            super(1);
                        }
                    }), (int)29, null));
                } else {
                    builder.append("removed the ").append(this.labelHTML((GHLabel)CollectionsKt.first((Iterable)removed))).append(" label");
                }
            }
            String string = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
            return string;
        }

        static /* synthetic */ String labelsHTML$default(SimpleEventComponentFactory simpleEventComponentFactory, Collection collection, Collection collection2, int n, Object object) {
            if ((n & 1) != 0) {
                collection = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                collection2 = CollectionsKt.emptyList();
            }
            return simpleEventComponentFactory.labelsHTML(collection, collection2);
        }

        private final String labelHTML(GHLabel label) {
            JBColor background = GithubUIUtil.INSTANCE.getLabelBackground(label);
            Color foreground = GithubUIUtil.INSTANCE.getLabelForeground((Color)background);
            return "<span style='color: #" + ColorUtil.toHex((Color)foreground) + "; background: #" + ColorUtil.toHex((Color)((Color)background)) + "'>\n                  &nbsp;" + StringUtil.escapeXmlEntities((String)label.getName()) + "&nbsp;</span>";
        }

        private final String renameHTML(String oldName, String newName) {
            return "renamed this from <b>" + oldName + "</b> to <b>" + newName + "</b>";
        }

        public static final /* synthetic */ String access$labelHTML(SimpleEventComponentFactory $this, GHLabel label) {
            return $this.labelHTML(label);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$State;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "intellij.vcs.github"})
    private final class StateEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.State> {
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.State event) {
            String string;
            Icon icon;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            switch (GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory$WhenMappings.$EnumSwitchMapping$0[event.getNewState().ordinal()]) {
                case 1: {
                    icon = GithubIcons.PullRequestClosed;
                    break;
                }
                case 2: {
                    icon = GithubIcons.PullRequestMerged;
                    break;
                }
                case 3: {
                    icon = GithubIcons.PullRequestOpen;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when (event.newState) {\n\u2026s.PullRequestOpen\n      }");
            Icon icon2 = icon;
            switch (GHPRTimelineEventComponentFactoryImpl$StateEventComponentFactory$WhenMappings.$EnumSwitchMapping$1[event.getNewState().ordinal()]) {
                case 1: {
                    string = "closed this";
                    break;
                }
                case 2: {
                    string = "merged this";
                    break;
                }
                case 3: {
                    string = "reopened this";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String text = string;
            return this.eventItem(icon2, event, text);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$BranchEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Branch;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "branchHTML", "", "name", "ref", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHGitRefName;", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "intellij.vcs.github"})
    private final class BranchEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Branch> {
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.Branch event) {
            GHPRTimelineItemComponentFactory.Item item;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            GHPRTimelineEvent.Branch branch = event;
            if (branch instanceof GHPRBaseRefChangedEvent) {
                item = this.eventItem(event, "changed the base branch");
            } else if (branch instanceof GHPRBaseRefForcePushedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                StringBuilder stringBuilder = new StringBuilder().append("force-pushed the ");
                String string = this.branchHTML(((GHPRBaseRefForcePushedEvent)event).getRef());
                if (string == null) {
                    string = "base";
                }
                item = this.eventItem(gHPRTimelineEvent, stringBuilder.append(string).append(" branch").toString());
            } else if (branch instanceof GHPRHeadRefForcePushedEvent) {
                GHPRTimelineEvent gHPRTimelineEvent = event;
                StringBuilder stringBuilder = new StringBuilder().append("force-pushed the ");
                String string = this.branchHTML(((GHPRHeadRefForcePushedEvent)event).getRef());
                if (string == null) {
                    string = "head";
                }
                item = this.eventItem(gHPRTimelineEvent, stringBuilder.append(string).append(" branch").toString());
            } else if (branch instanceof GHPRHeadRefDeletedEvent) {
                item = this.eventItem(event, "deleted the " + this.branchHTML(((GHPRHeadRefDeletedEvent)event).getHeadRefName()) + " branch");
            } else if (branch instanceof GHPRHeadRefRestoredEvent) {
                item = this.eventItem(event, "restored head branch");
            } else {
                Void void_ = GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw null;
            }
            return item;
        }

        private final String branchHTML(GHGitRefName ref) {
            String string;
            Object object = ref;
            if (object != null && (object = ((GHGitRefName)object).getName()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                string = this.branchHTML((String)it);
            } else {
                string = null;
            }
            return string;
        }

        private final String branchHTML(String name) {
            JBColor foreground = CurrentBranchComponent.TEXT_COLOR;
            Color color = UIUtil.getListBackground();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"UIUtil.getListBackground()");
            Color background = CurrentBranchComponent.Companion.getBranchPresentationBackground(color);
            return "<span style='color: #" + ColorUtil.toHex((Color)((Color)foreground)) + "; background: #" + ColorUtil.toHex((Color)background) + "'>\n                  &nbsp;<icon-inline src='GithubIcons.Branch'/>" + name + "&nbsp;</span>";
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$ComplexEventComponentFactory;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$EventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent$Complex;", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl;)V", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "event", "intellij.vcs.github"})
    private final class ComplexEventComponentFactory
    extends EventComponentFactory<GHPRTimelineEvent.Complex> {
        @Override
        @NotNull
        public GHPRTimelineItemComponentFactory.Item createComponent(@NotNull GHPRTimelineEvent.Complex event) {
            HtmlEditorPane htmlEditorPane;
            JComponent jComponent;
            Icon icon;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            GHPRTimelineEvent.Complex complex = event;
            if (complex instanceof GHPRReviewDismissedEvent) {
                Icon icon2 = GithubIcons.Timeline;
                icon = icon2;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"GithubIcons.Timeline");
                GHActor gHActor = ((GHPRReviewDismissedEvent)event).getReviewAuthor();
                jComponent = GHPRTimelineItemComponentFactory.Companion.actionTitle(GHPRTimelineEventComponentFactoryImpl.this.avatarIconsProvider, event.getActor(), "dismissed <b>" + (gHActor != null ? gHActor.getLogin() : null) + "</b>`s stale review", event.getCreatedAt());
                String string = ((GHPRReviewDismissedEvent)event).getDismissalMessageHTML();
                if (string != null) {
                    String string2 = string;
                    JComponent jComponent2 = jComponent;
                    Icon icon3 = icon;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    HtmlEditorPane htmlEditorPane2 = new HtmlEditorPane(it);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    HtmlEditorPane $this$apply = htmlEditorPane2;
                    boolean bl6 = false;
                    $this$apply.setBorder((Border)JBUI.Borders.emptyLeft((int)28));
                    HtmlEditorPane htmlEditorPane3 = htmlEditorPane2;
                    icon = icon3;
                    jComponent = jComponent2;
                    htmlEditorPane = htmlEditorPane3;
                } else {
                    htmlEditorPane = null;
                }
            } else {
                Void void_ = GHPRTimelineEventComponentFactoryImpl.this.throwUnknownType(event);
                throw null;
            }
            JComponent jComponent3 = htmlEditorPane;
            JComponent jComponent4 = jComponent;
            Icon icon4 = icon;
            return new GHPRTimelineItemComponentFactory.Item(icon4, jComponent4, jComponent3);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactoryImpl$Companion;", "", "()V", "appendParagraph", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "", "intellij.vcs.github"})
    public static final class Companion {
        private final StringBuilder appendParagraph(@NotNull StringBuilder $this$appendParagraph, String text) {
            CharSequence charSequence = text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                $this$appendParagraph.append("<p>").append(text).append("</p>");
            }
            return $this$appendParagraph;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

