/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineComponent;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\n\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineComponent;", "Ljavax/swing/JPanel;", "Lcom/intellij/util/ui/ComponentWithEmptyText;", "model", "Ljavax/swing/ListModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "itemComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "(Ljavax/swing/ListModel;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;)V", "emptyText", "org/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineComponent$emptyText$1", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineComponent$emptyText$1;", "timeLineColor", "Lcom/intellij/ui/JBColor;", "timeLineGap", "Lcom/intellij/util/ui/JBValue;", "kotlin.jvm.PlatformType", "timeLineValues", "Lcom/intellij/util/ui/JBValue$JBValueGroup;", "timeLineWidth", "timeLineX", "computeYEnd", "", "item", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "computeYStart", "getEmptyText", "Lcom/intellij/util/ui/StatusText;", "getPreferredSize", "Ljava/awt/Dimension;", "paintChildren", "", "g", "Ljava/awt/Graphics;", "paintComponent", "intellij.vcs.github"})
public final class GHPRTimelineComponent
extends JPanel
implements ComponentWithEmptyText {
    private final emptyText.1 emptyText;
    private final JBColor timeLineColor;
    private final JBValue.JBValueGroup timeLineValues;
    private final JBValue timeLineGap;
    private final JBValue timeLineWidth;
    private final JBValue timeLineX;
    private final ListModel<GHPRTimelineItem> model;
    private final GHPRTimelineItemComponentFactory itemComponentFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        super.paintChildren(g);
        Object object = this.getTreeLock();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"treeLock");
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            boolean bl3 = false;
            int lastIdx = this.getComponentCount() - 1;
            if (lastIdx < 0) {
                return;
            }
            Component component2 = this.getComponent(lastIdx);
            if (!(component2 instanceof GHPRTimelineItemComponentFactory.Item)) {
                component2 = null;
            }
            GHPRTimelineItemComponentFactory.Item item = (GHPRTimelineItemComponentFactory.Item)component2;
            if (item == null) {
                return;
            }
            GHPRTimelineItemComponentFactory.Item lastComp = item;
            int yEnd = this.computeYEnd(lastComp);
            Graphics2D cfr_ignored_0 = (Graphics2D)g;
            ((Graphics2D)g).setColor((Color)this.timeLineColor);
            JBValue jBValue = this.timeLineX;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBValue, (String)"timeLineX");
            double x = jBValue.getFloat();
            int n = this.getComponentCount() - 2;
            boolean bl4 = false;
            while (n >= 0) {
                void i2;
                Component component3 = this.getComponent((int)i2);
                if (!(component3 instanceof GHPRTimelineItemComponentFactory.Item)) {
                    component3 = null;
                }
                if ((GHPRTimelineItemComponentFactory.Item)component3 == null) {
                } else {
                    GHPRTimelineItemComponentFactory.Item comp;
                    int yStart = this.computeYStart(comp);
                    if (yStart < yEnd) {
                        Graphics2D graphics2D = (Graphics2D)g;
                        double d = yStart;
                        double d2 = yEnd;
                        JBValue jBValue2 = this.timeLineWidth;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jBValue2, (String)"timeLineWidth");
                        LinePainter2D.paint((Graphics2D)graphics2D, (double)x, (double)d, (double)x, (double)d2, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)jBValue2.getFloat());
                        yEnd = this.computeYEnd(comp);
                    }
                }
                --i2;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final int computeYStart(GHPRTimelineItemComponentFactory.Item item) {
        return item.getY() + (item.getMarker().getY() + item.getMarker().getHeight() - item.getMarker().getInsets().bottom) + this.timeLineGap.get();
    }

    private final int computeYEnd(GHPRTimelineItemComponentFactory.Item item) {
        return item.getY() + (item.getMarker().getY() + item.getMarker().getInsets().top) - this.timeLineGap.get();
    }

    @NotNull
    public StatusText getEmptyText() {
        return this.emptyText;
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        if (this.model.getSize() == 0 && !StringUtil.isEmpty((String)this.emptyText.getText())) {
            Dimension s = this.emptyText.getPreferredSize();
            JBInsets.addTo((Dimension)s, (Insets)this.getInsets());
            return s;
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        super.paintComponent(g);
        this.emptyText.paint(this, g);
    }

    /*
     * WARNING - void declaration
     */
    public GHPRTimelineComponent(@NotNull ListModel<GHPRTimelineItem> model2, @NotNull GHPRTimelineItemComponentFactory itemComponentFactory) {
        Intrinsics.checkParameterIsNotNull(model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)itemComponentFactory, (String)"itemComponentFactory");
        super((LayoutManager)new VerticalLayout(UI.scale((int)20)));
        this.model = model2;
        this.itemComponentFactory = itemComponentFactory;
        this.emptyText = new StatusText(this, this){
            final /* synthetic */ GHPRTimelineComponent this$0;

            protected boolean isStatusVisible() {
                return GHPRTimelineComponent.access$getModel$p(this.this$0).getSize() == 0;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.timeLineColor = new JBColor(ColorUtil.fromHex((String)"#F2F2F2"), ColorUtil.fromHex((String)"#3E3E3E"));
        this.timeLineValues = new JBValue.JBValueGroup();
        this.timeLineGap = this.timeLineValues.value((float)4);
        this.timeLineWidth = this.timeLineValues.value(2.0f);
        this.timeLineX = this.timeLineValues.value(9.0f);
        this.setOpaque(false);
        this.setBorder((Border)JBUI.Borders.emptyTop((int)6));
        this.model.addListDataListener(new ListDataListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void intervalRemoved(@NotNull ListDataEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                int n = e.getIndex1();
                int n2 = e.getIndex0();
                if (n >= n2) {
                    while (true) {
                        void i2;
                        this.remove((int)i2);
                        if (i2 == n2) break;
                        --i2;
                    }
                }
                this.revalidate();
                this.repaint();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void intervalAdded(@NotNull ListDataEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                int n = e.getIndex0();
                int n2 = e.getIndex1();
                if (n <= n2) {
                    while (true) {
                        void i2;
                        GHPRTimelineItemComponentFactory gHPRTimelineItemComponentFactory = itemComponentFactory;
                        Object e2 = model.getElementAt((int)i2);
                        Intrinsics.checkExpressionValueIsNotNull(e2, (String)"model.getElementAt(i)");
                        this.add(gHPRTimelineItemComponentFactory.createComponent((GHPRTimelineItem)e2), "fill_h", (int)i2);
                        if (i2 == n2) break;
                        ++i2;
                    }
                }
                this.revalidate();
                this.repaint();
            }

            @Override
            public void contentsChanged(@NotNull ListDataEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.validate();
                this.repaint();
            }
        });
        int n = 0;
        int n2 = this.model.getSize();
        while (n < n2) {
            void i2;
            GHPRTimelineItem gHPRTimelineItem = this.model.getElementAt((int)i2);
            Intrinsics.checkExpressionValueIsNotNull((Object)gHPRTimelineItem, (String)"model.getElementAt(i)");
            this.add(this.itemComponentFactory.createComponent(gHPRTimelineItem), "fill_h", (int)i2);
            ++i2;
        }
    }
}

