/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J#\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\bH\u0007J\b\u0010\u0016\u001a\u00020\bH\u0007J\b\u0010\u0017\u001a\u00020\bH\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/io/DigestUtil;", "", "()V", "sunSecurityProvider", "Ljava/security/Provider;", "calculateContentHash", "", "digest", "Ljava/security/MessageDigest;", "bytes", "offset", "", "length", "calculateMergedHash", "hashArrays", "", "(Ljava/security/MessageDigest;[[B)[B", "cloneDigest", "getMessageDigest", "algorithm", "", "md5", "sha1", "sha256", "updateContentHash", "", "path", "Ljava/nio/file/Path;", "intellij.platform.util.ex"})
public final class DigestUtil {
    private static final Provider sunSecurityProvider;
    public static final DigestUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final MessageDigest md5() {
        return INSTANCE.getMessageDigest("MD5");
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha1() {
        return INSTANCE.getMessageDigest("SHA-1");
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha256() {
        return INSTANCE.getMessageDigest("SHA-256");
    }

    @JvmStatic
    @NotNull
    public static final byte[] calculateContentHash(@NotNull MessageDigest digest, @NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return DigestUtil.calculateContentHash(digest, bytes, 0, bytes.length);
    }

    @JvmStatic
    @NotNull
    public static final byte[] calculateContentHash(@NotNull MessageDigest digest, @NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        MessageDigest cloned = INSTANCE.cloneDigest(digest);
        String string = String.valueOf(length);
        MessageDigest messageDigest = cloned;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        messageDigest.update(byArray2);
        string = "\u0000";
        messageDigest = cloned;
        charset = Charsets.UTF_8;
        bl = false;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byArray2 = byArray3;
        messageDigest.update(byArray2);
        cloned.update(bytes, offset, length);
        byte[] byArray4 = cloned.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"cloned.digest()");
        return byArray4;
    }

    @JvmStatic
    @NotNull
    public static final byte[] calculateMergedHash(@NotNull MessageDigest digest, @NotNull byte[][] hashArrays) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)hashArrays, (String)"hashArrays");
        MessageDigest cloned = INSTANCE.cloneDigest(digest);
        for (byte[] bytes : hashArrays) {
            cloned.update(bytes);
        }
        byte[] byArray = cloned.digest();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cloned.digest()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        byte[] buff = new byte[524288];
        try {
            Closeable closeable = PathKt.inputStream(path);
            boolean bl = false;
            Throwable throwable = null;
            try {
                int sz;
                InputStream iz = (InputStream)closeable;
                boolean bl2 = false;
                while ((sz = iz.read(buff)) > 0) {
                    digest.update(buff, 0, sz);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Faield to read " + path + ". " + e.getMessage(), e);
        }
    }

    private final MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, sunSecurityProvider);
        Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"MessageDigest.getInstanc\u2026thm, sunSecurityProvider)");
        return messageDigest;
    }

    /*
     * WARNING - void declaration
     */
    private final MessageDigest cloneDigest(MessageDigest digest) {
        void var2_2;
        try {
            Object object = digest.clone();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.MessageDigest");
            }
            MessageDigest clone = (MessageDigest)object;
            clone.reset();
        }
        catch (CloneNotSupportedException e) {
            throw (Throwable)new IllegalArgumentException("Message digest is not cloneable: " + digest);
        }
        return var2_2;
    }

    private DigestUtil() {
    }

    static {
        DigestUtil digestUtil;
        INSTANCE = digestUtil = new DigestUtil();
        Provider provider = Security.getProvider("SUN");
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"java.security.Security.getProvider(\"SUN\")");
        sunSecurityProvider = provider;
    }
}

