/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.DockerRepoTagsKt;
import com.intellij.docker.composeFile.DockerImageReferenceType;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.registry.search.DockerSearch;
import com.intellij.docker.registry.search.DockerSearchResult;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.SLRUMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J$\u0010 \u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010!0!0\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010$\u001a\n \"*\u0004\u0018\u00010!0!2\u0006\u0010%\u001a\u00020\bH\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lcom/intellij/docker/composeFile/DockerImageReferenceType;", "Lorg/jetbrains/yaml/meta/model/YamlReferenceType;", "typeName", "", "(Ljava/lang/String;)V", "cachedResults", "Lcom/intellij/util/containers/SLRUMap;", "", "Lcom/intellij/docker/registry/search/DockerSearchResult;", "search", "Lcom/intellij/docker/registry/search/DockerSearch;", "getSearch", "()Lcom/intellij/docker/registry/search/DockerSearch;", "search$delegate", "Lkotlin/Lazy;", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "getValueLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "insertedScalar", "completionContext", "Lorg/jetbrains/yaml/meta/model/CompletionContext;", "validateScalarValue", "", "scalarValue", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "wrapAll", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "kotlin.jvm.PlatformType", "list", "wrapSearchResult", "result", "Companion", "intellij.clouds.docker.compose"})
public class DockerImageReferenceType
extends YamlReferenceType {
    private final Lazy search$delegate;
    private final SLRUMap<String, List<DockerSearchResult>> cachedResults;
    public static final Companion Companion = new Companion(null);

    private final DockerSearch getSearch() {
        Lazy lazy = this.search$delegate;
        DockerImageReferenceType dockerImageReferenceType = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DockerSearch)lazy.getValue();
    }

    @NotNull
    public List<? extends LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        List<Object> list;
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)insertedScalar, (String)"insertedScalar");
                if (completionContext == null) {
                    List list2 = Collections.emptyList();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.emptyList()");
                    return list2;
                }
                String string = completionContext.getCompletionPrefix();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"completionContext.completionPrefix");
                String prefix = string;
                List list3 = (List)this.cachedResults.get((Object)prefix);
                if (list3 != null) {
                    List list4 = list3;
                    boolean bl = false;
                    boolean bl2 = false;
                    List it = list4;
                    boolean bl3 = false;
                    List list5 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"it");
                    return this.wrapAll(list5);
                }
                CompletableFuture promise = this.getSearch().searchForCompletions(prefix);
                Future future = promise;
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                list = (List)ApplicationUtil.runWithCheckCanceled((Future)future, (ProgressIndicator)progressManager.getProgressIndicator());
                if (list == null) break block5;
                List list6 = list;
                boolean bl = false;
                boolean bl4 = false;
                List it = list6;
                boolean bl5 = false;
                this.cachedResults.put((Object)prefix, it);
                list = this.wrapAll(it);
                if (list != null) break block6;
            }
            List list7 = Collections.emptyList();
            list = list7;
            Intrinsics.checkExpressionValueIsNotNull(list7, (String)"Collections.emptyList()");
        }
        return list;
    }

    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        Intrinsics.checkParameterIsNotNull((Object)valueScalar, (String)"valueScalar");
        String fullText = DockerImageReferenceType.Companion.unquoteTextValue(valueScalar);
        CharSequence charSequence = fullText;
        boolean bl = false;
        if (charSequence.length() == 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        DockerRepoTag dockerRepoTag = DockerRepoTag.fromString((String)StringsKt.substringBefore((String)fullText, (char)' ', (String)fullText));
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerRepoTag, (String)"DockerRepoTag.fromString\u2026ingBefore(' ', fullText))");
        DockerRepoTag parsedTag = dockerRepoTag;
        CharSequence charSequence2 = parsedTag.getDomain();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            Intrinsics.checkExpressionValueIsNotNull((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String string = parsedTag.getQualifiedRepository();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedTag.qualifiedRepository");
        String image = string;
        PsiReference[] psiReferenceArray = new PsiReference[1];
        PsiElement psiElement = (PsiElement)valueScalar;
        String string2 = valueScalar.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"valueScalar.text");
        psiReferenceArray[0] = (PsiReference)new WebReference(psiElement, DockerImageReferenceType.Companion.rangeOf(string2, image), "https://registry.hub.docker.com/r/" + image);
        return psiReferenceArray;
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        String text = DockerImageReferenceType.Companion.unquoteTextValue(scalarValue);
        if (StringsKt.isBlank((CharSequence)text)) {
            return;
        }
        CharSequence charSequence = text;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String trimmedReference = ((Object)StringsKt.trim((CharSequence)string)).toString();
        charSequence = trimmedReference;
        String string2 = "\\s+";
        boolean bl2 = false;
        string2 = new Regex(string2);
        bl2 = false;
        if (string2.containsMatchIn(charSequence)) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("DockerImageReferenceType.error.multiple", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        if (Intrinsics.areEqual((Object)text, (Object)trimmedReference) ^ true || !DockerRepoTagsKt.isValidRepoTag((String)trimmedReference)) {
            holder.registerProblem((PsiElement)scalarValue, DockerComposeBundle.message("DockerImageReferenceType.error.format", new Object[0]), new LocalQuickFix[0]);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupElementBuilder> wrapAll(List<? extends DockerSearchResult> list) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void next;
            DockerSearchResult dockerSearchResult = (DockerSearchResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LookupElementBuilder lookupElementBuilder = this.wrapSearchResult((DockerSearchResult)next);
            collection.add(lookupElementBuilder);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private final LookupElementBuilder wrapSearchResult(DockerSearchResult result) {
        return LookupElementBuilder.create((String)result.getLookupText()).withIcon(result.getIcon());
    }

    public DockerImageReferenceType(@NotNull String typeName) {
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        super(typeName);
        this.search$delegate = LazyKt.lazy((Function0)search.2.INSTANCE);
        this.cachedResults = new SLRUMap(10, 10);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\f\u0010\u000b\u001a\u00020\u0004*\u00020\fH\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/composeFile/DockerImageReferenceType$Companion;", "", "()V", "quote", "", "Lorg/jetbrains/yaml/psi/YAMLQuotedText;", "getQuote", "(Lorg/jetbrains/yaml/psi/YAMLQuotedText;)Ljava/lang/String;", "rangeOf", "Lcom/intellij/openapi/util/TextRange;", "subString", "unquoteTextValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "intellij.clouds.docker.compose"})
    public static final class Companion {
        private final TextRange rangeOf(@NotNull String $this$rangeOf, String subString) {
            TextRange textRange;
            int start = StringsKt.indexOf$default((CharSequence)$this$rangeOf, (String)subString, (int)0, (boolean)false, (int)6, null);
            if (start < 0) {
                TextRange textRange2 = TextRange.allOf((String)subString);
                textRange = textRange2;
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"TextRange.allOf(subString)");
            } else {
                textRange = new TextRange(start, start + subString.length());
            }
            return textRange;
        }

        private final String unquoteTextValue(@NotNull YAMLScalar $this$unquoteTextValue) {
            String string;
            if ($this$unquoteTextValue instanceof YAMLQuotedText) {
                String string2 = ((YAMLQuotedText)$this$unquoteTextValue).getTextValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.textValue");
                string = StringsKt.removeSurrounding((String)string2, (CharSequence)this.getQuote((YAMLQuotedText)$this$unquoteTextValue));
            } else {
                String string3 = $this$unquoteTextValue.getTextValue();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"this.textValue");
            }
            return string;
        }

        private final String getQuote(@NotNull YAMLQuotedText $this$quote) {
            return $this$quote.isSingleQuote() ? "'" : "\"";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

