/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.DockerRunLineMarkerProviderBase;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.v2.ComposeFileModel;
import com.intellij.docker.composeFile.model.v2.ComposeMetaTypeProvider;
import com.intellij.docker.debug.DockerBeforeRunTask;
import com.intellij.docker.debug.DockerBeforeRunTaskProvider;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.remoteDebug.RemoteServerRequestAdapterFactory;
import com.intellij.docker.runtimes.DockerRuntimesManagerService;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.UniqueNameGenerator;
import icons.DockerIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class ComposeFileRunLineMarkerProvider
extends DockerRunLineMarkerProviderBase {
    private final Map<Project, Refresher> myRefreshers = new HashMap<Project, Refresher>();

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement psi) {
        ASTNode node;
        if (psi == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((node = psi.getNode()) == null) {
            return null;
        }
        if (node.getElementType() != YAMLTokenTypes.SCALAR_KEY) {
            return null;
        }
        if (!(psi.getParent() instanceof YAMLKeyValue)) {
            return null;
        }
        if (!ComposeFileUtil.isFromComposeFile(psi)) {
            return null;
        }
        YAMLKeyValue keyValue = (YAMLKeyValue)psi.getParent();
        YamlMetaTypeProvider.MetaTypeProxy meta = ComposeMetaTypeProvider.getInstance().getKeyValueMetaType(keyValue);
        if (meta == null) {
            return null;
        }
        YamlMetaType type = meta.getMetaType();
        if (type instanceof ComposeFileModel.Markers.TopLevelServicesGroup) {
            return new AllServicesLineMarkerInfo(psi);
        }
        if (type instanceof ComposeFileModel.Markers.SingleComposeService) {
            this.setupRefresher(psi);
            return new ServiceLineMarkerInfo(psi, keyValue.getKeyText(), ComposeFileRunLineMarkerProvider.getServiceStatus(keyValue));
        }
        if (type instanceof ComposeFileModel.Markers.RemoteCommand) {
            ComposeFileModel.Markers.RemoteCommand typeImpl = (ComposeFileModel.Markers.RemoteCommand)type;
            String serviceName = typeImpl.getServiceName(keyValue);
            String command = typeImpl.buildCommandLine(keyValue);
            return command == null || serviceName == null ? null : DebugLineMarkerInfo.buildForCommandLine(psi, serviceName, command);
        }
        return null;
    }

    private void setupRefresher(@NotNull PsiElement psi) {
        Project project;
        if (psi == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (!this.myRefreshers.containsKey(project = psi.getProject())) {
            Disposer.register((Disposable)project, () -> this.myRefreshers.remove(project));
            this.myRefreshers.put(project, new Refresher(project));
        }
    }

    private static DockerComposeDeploymentSourceType COMPOSE() {
        return DockerComposeDeploymentSourceType.getInstance();
    }

    private static boolean isForAllServices(@NotNull DockerRunLineMarkerProviderBase.DockerRunConfig runConfig) {
        if (runConfig == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return runConfig.getDeploymentConfiguration().getServices().isEmpty();
    }

    private static boolean isForOnlyService(@NotNull DockerRunLineMarkerProviderBase.DockerRunConfig runConfig, @NotNull String serviceName) {
        List services;
        if (runConfig == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (serviceName == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return (services = runConfig.getDeploymentConfiguration().getServices()).size() == 1 && services.contains(serviceName);
    }

    @Nullable
    private static DockerRuntimesManagerService.ComposeServiceStatus getServiceStatus(@NotNull YAMLKeyValue service) {
        if (service == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        String serviceName = service.getKeyText();
        String projectName = ComposeFileUtil.getComposeProjectName((PsiElement)service);
        if (projectName == null) {
            return null;
        }
        return Optional.ofNullable(DockerRuntimesManagerService.getInstance().getActiveManager()).map(manager -> manager.findComposeServiceStatus(projectName, serviceName)).orElse(null);
    }

    @NotNull
    private static Icon getServiceActionIcon(@NotNull DockerRuntimesManagerService.ComposeServiceStatus status) {
        if (status == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        switch (status) {
            case DEPLOYED: {
                Icon icon = AllIcons.Actions.Restart;
                if (icon == null) {
                    ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(7);
                }
                return icon;
            }
            case FAILED: {
                Icon icon = AllIcons.RunConfigurations.TestState.Yellow2;
                if (icon == null) {
                    ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(8);
                }
                return icon;
            }
        }
        Icon icon = AllIcons.RunConfigurations.TestState.Run;
        if (icon == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(9);
        }
        return icon;
    }

    private static void setupOneComposeService(@NotNull DockerRunLineMarkerProviderBase.DockerRunConfig runConfig, @NotNull String service) {
        if (runConfig == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(10);
        }
        if (service == null) {
            ComposeFileRunLineMarkerProvider.$$$reportNull$$$0(11);
        }
        DockerDeploymentConfiguration deployConfig = runConfig.getDeploymentConfiguration();
        List services = deployConfig.getServices();
        services.clear();
        services.add(service);
        runConfig.getSettings().setName(ComposeFileRunLineMarkerProvider.COMPOSE().suggestConfigurationName(deployConfig));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceActionIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isForAllServices";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isForOnlyService";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getServiceStatus";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getServiceActionIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupOneComposeService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Refresher
    implements DockerRuntimesManagerService.DockerRuntimesListener,
    Disposable {
        private final Project myProject;
        private MessageBusConnection myBusConnection;

        Refresher(@NotNull Project project) {
            if (project == null) {
                Refresher.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            Disposer.register((Disposable)project, (Disposable)this);
            this.myBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            this.myBusConnection.subscribe(DockerRuntimesManagerService.DOCKER_RUNTIMES_MANAGER_TOPIC, (Object)this);
        }

        public void dispose() {
            if (this.myBusConnection != null) {
                this.myBusConnection.disconnect();
                this.myBusConnection = null;
            }
        }

        public void connectionChanged(@NotNull DockerRuntimesManagerService.DockerRuntimesManager manager, boolean nowConnected) {
            if (manager == null) {
                Refresher.$$$reportNull$$$0(1);
            }
            this.restartDaemon();
        }

        public void runtimesRefreshed(@NotNull DockerRuntimesManagerService.DockerRuntimesManager manager, @NotNull DockerRuntimesManagerService.DockerRuntimesListener.Delta delta) {
            if (manager == null) {
                Refresher.$$$reportNull$$$0(2);
            }
            if (delta == null) {
                Refresher.$$$reportNull$$$0(3);
            }
            this.restartDaemon();
        }

        private void restartDaemon() {
            if (!this.myProject.isDisposed()) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delta";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$Refresher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "connectionChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runtimesRefreshed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DebugExistingRunConfigAction
    extends DockerRunLineMarkerProviderBase.RunConfigActionBase {
        private final RunnerAndConfigurationSettings myRunConfig;

        DebugExistingRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull RunnerAndConfigurationSettings runConfig) {
            if (helper == null) {
                DebugExistingRunConfigAction.$$$reportNull$$$0(0);
            }
            if (runConfig == null) {
                DebugExistingRunConfigAction.$$$reportNull$$$0(1);
            }
            super(helper);
            this.myRunConfig = runConfig;
            this.getTemplatePresentation().setText(DockerComposeBundle.messagePointer("ComposeFileRunLineMarkerProvider.DebugExistingRunConfigAction.text", this.myRunConfig.getName()));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.StartDebugger);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DebugExistingRunConfigAction.$$$reportNull$$$0(2);
            }
            this.getHelper().executeConfiguration(this.myRunConfig);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfig";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$DebugExistingRunConfigAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CreateNewDebugRunConfigAction
    extends DockerRunLineMarkerProviderBase.RunConfigActionBase {
        private final RemoteServerRequestAdapterFactory myAdapterFactory;
        private final String myServiceName;
        private final RemoteServerRequestAdapterFactory.CommandLineAdjuster myAdjuster;
        private final String myBaseCommand;
        private final Supplier<? extends DockerRunLineMarkerProviderBase.DockerRunConfig> myDockerRunConfig;

        CreateNewDebugRunConfigAction(@NotNull DockerRunConfigurationCreator helper, @NotNull RemoteServerRequestAdapterFactory factory, @NotNull String serviceName, @NotNull RemoteServerRequestAdapterFactory.CommandLineAdjuster adjuster, @NotNull String baseCommand, @NotNull Supplier<? extends DockerRunLineMarkerProviderBase.DockerRunConfig> dockerRunConfig) {
            if (helper == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(1);
            }
            if (serviceName == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(2);
            }
            if (adjuster == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(3);
            }
            if (baseCommand == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(4);
            }
            if (dockerRunConfig == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(5);
            }
            super(helper);
            this.myAdapterFactory = factory;
            this.myServiceName = serviceName;
            this.myAdjuster = adjuster;
            this.myBaseCommand = baseCommand;
            this.myDockerRunConfig = dockerRunConfig;
            ConfigurationType type = this.myAdjuster.getConfigurationType();
            assert (type != null);
            this.getTemplatePresentation().setText(DockerComposeBundle.messagePointer("ComposeFileRunLineMarkerProvider.CreateNewDebugRunConfigAction.text", type.getDisplayName()));
            this.getTemplatePresentation().setIcon(AllIcons.Actions.StartDebugger);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CreateNewDebugRunConfigAction.$$$reportNull$$$0(6);
            }
            RunManager runManager = RunManager.getInstance((Project)this.getProject());
            ConfigurationType type = this.myAdjuster.getConfigurationType();
            assert (type != null);
            String name = CreateNewDebugRunConfigAction.chooseName(runManager, type);
            RunnerAndConfigurationSettings hostRunConfig = runManager.createConfiguration(name, type.getClass());
            DockerBeforeRunTaskProvider provider = DockerBeforeRunTaskProvider.getInstance((Project)this.getProject());
            DockerBeforeRunTask task = provider.createTask(hostRunConfig.getConfiguration());
            assert (task != null) : "For run configuration type: " + type;
            this.myAdapterFactory.bind(task.getRequest(), hostRunConfig.getConfiguration());
            task.setTargetRunConfig(this.getTargetRunConfig());
            task.setCustomCommand(null);
            task.setWaitForHealthCheck(false);
            ArrayList<DockerBeforeRunTask> tasks = new ArrayList<DockerBeforeRunTask>(hostRunConfig.getConfiguration().getBeforeRunTasks());
            tasks.add(task);
            hostRunConfig.getConfiguration().setBeforeRunTasks(tasks);
            this.getHelper().openForEditingAndExecute(hostRunConfig, DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.CreateNewDebugRunConfigAction.dialogTitle", type.getDisplayName()));
        }

        @Nullable
        private DockerBeforeRunTask.TargetRunConfig getTargetRunConfig() {
            DockerRunLineMarkerProviderBase.DockerRunConfig wrapper = this.myDockerRunConfig.get();
            return wrapper == null ? null : new DockerBeforeRunTask.TargetComposeRunConfig(wrapper.getConfig(), this.myServiceName);
        }

        private static String chooseName(RunManager runManager, ConfigurationType type) {
            Set existingNames = runManager.getConfigurationsList(type).stream().map(RunProfile::getName).collect(Collectors.toSet());
            String baseName = type.getDisplayName() + " with compose";
            return UniqueNameGenerator.generateUniqueName((String)baseName, (String)"", (String)"", next -> !existingNames.contains(next));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "adjuster";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseCommand";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dockerRunConfig";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$CreateNewDebugRunConfigAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DebugLineMarkerInfo
    extends MostlySingleActionLineMarkerInfo {
        private final RemoteServerRequestAdapterFactory myFactory;
        private final String myServiceName;
        private final RemoteServerRequestAdapterFactory.CommandLineAdjuster myAdjuster;
        private final String myBaseCommand;

        @Nullable
        static DebugLineMarkerInfo buildForCommandLine(@NotNull PsiElement psi, @NotNull String service, @NotNull String command) {
            RemoteServerRequestAdapterFactory factory;
            if (psi == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (service == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (command == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if ((factory = RemoteServerRequestAdapterFactory.findAdapterFactory((String)command)) == null) {
                return null;
            }
            RemoteServerRequestAdapterFactory.CommandLineAdjuster adjuster = factory.recognizeCommandLine(command);
            if (adjuster == null || adjuster.getConfigurationType() == null) {
                return null;
            }
            if (ComposeFileRunLineMarkerProvider.listAllDockerAccounts().isEmpty()) {
                return null;
            }
            return new DebugLineMarkerInfo(psi, service, factory, adjuster, command);
        }

        private DebugLineMarkerInfo(@NotNull PsiElement psi, @NotNull String serviceName, @NotNull RemoteServerRequestAdapterFactory factory, @NotNull RemoteServerRequestAdapterFactory.CommandLineAdjuster adjuster, @NotNull String baseCommand) {
            if (psi == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(3);
            }
            if (serviceName == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(4);
            }
            if (factory == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(5);
            }
            if (adjuster == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(6);
            }
            if (baseCommand == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(7);
            }
            super(psi, AllIcons.Actions.StartDebugger, DefaultDebugExecutor.getDebugExecutorInstance());
            this.myFactory = factory;
            this.myServiceName = serviceName;
            this.myAdjuster = adjuster;
            this.myBaseCommand = baseCommand;
        }

        @Override
        @Nullable
        protected ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            if (helper == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(8);
            }
            if (sourceFile == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(9);
            }
            DefaultActionGroup result = new DefaultActionGroup();
            List<RunnerAndConfigurationSettings> existings = this.findExistingDebugRunConfigs(helper, sourceFile);
            for (RunnerAndConfigurationSettings next : existings) {
                result.add((AnAction)new DebugExistingRunConfigAction(helper, next));
                result.add((AnAction)new DockerRunLineMarkerProviderBase.EditExistingRunConfig(helper, next));
            }
            RemoteServer firstDocker = (RemoteServer)ContainerUtil.getFirstItem((List)ComposeFileRunLineMarkerProvider.listAllDockerAccounts());
            if (firstDocker != null && existings.isEmpty()) {
                List dockerRunConfigs = DockerRunLineMarkerProviderBase.DockerRunConfig.dockerConfigs((Project)helper.getProject(), (VirtualFile)sourceFile, (DeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE());
                Supplier<DockerRunLineMarkerProviderBase.DockerRunConfig> dockerRunConfig = dockerRunConfigs.isEmpty() ? () -> {
                    RunnerAndConfigurationSettings config = helper.createConfiguration((DockerSingletonDeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE(), sourceFile, firstDocker);
                    helper.rememberConfiguration(config);
                    return DockerRunLineMarkerProviderBase.DockerRunConfig.wrapIfDocker((RunnerAndConfigurationSettings)config);
                } : () -> (DockerRunLineMarkerProviderBase.DockerRunConfig)ContainerUtil.getFirstItem((List)dockerRunConfigs);
                result.add((AnAction)new CreateNewDebugRunConfigAction(helper, this.myFactory, this.myServiceName, this.myAdjuster, this.myBaseCommand, dockerRunConfig));
            }
            return result;
        }

        private List<RunnerAndConfigurationSettings> findExistingDebugRunConfigs(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            ConfigurationType type;
            if (helper == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(10);
            }
            if (sourceFile == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(11);
            }
            if ((type = this.myAdjuster.getConfigurationType()) == null) {
                return Collections.emptyList();
            }
            RunManager runManager = RunManager.getInstance((Project)helper.getProject());
            LinkedList<RunnerAndConfigurationSettings> result = new LinkedList<RunnerAndConfigurationSettings>();
            for (RunnerAndConfigurationSettings next : runManager.getConfigurationSettingsList(type)) {
                DockerBeforeRunTask task = DebugLineMarkerInfo.findDockerBeforeRunTask(next.getConfiguration());
                if (task == null || !task.isForSourceFileAndType(sourceFile, (SingletonDeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE()) || !task.isForComposeService(this.myServiceName)) continue;
                result.add(next);
            }
            return result;
        }

        private static DockerBeforeRunTask findDockerBeforeRunTask(@NotNull RunConfiguration configuration) {
            List tasks;
            if (configuration == null) {
                DebugLineMarkerInfo.$$$reportNull$$$0(12);
            }
            return (tasks = configuration.getBeforeRunTasks().stream().map(task -> (DockerBeforeRunTask)ObjectUtils.tryCast((Object)task, DockerBeforeRunTask.class)).filter(Objects::nonNull).collect(Collectors.toList())).size() == 1 ? (DockerBeforeRunTask)tasks.get(0) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "adjuster";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseCommand";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$DebugLineMarkerInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildForCommandLine";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeAllActions";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findExistingDebugRunConfigs";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findDockerBeforeRunTask";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AllServicesLineMarkerInfo
    extends MostlySingleActionLineMarkerInfo {
        protected AllServicesLineMarkerInfo(@NotNull PsiElement psi) {
            if (psi == null) {
                AllServicesLineMarkerInfo.$$$reportNull$$$0(0);
            }
            super(psi, AllIcons.RunConfigurations.TestState.Run_run);
        }

        @Override
        @Nullable
        protected ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            if (helper == null) {
                AllServicesLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (sourceFile == null) {
                AllServicesLineMarkerInfo.$$$reportNull$$$0(2);
            }
            List foundConfigs = ContainerUtil.filter((Collection)DockerRunLineMarkerProviderBase.DockerRunConfig.dockerConfigs((Project)helper.getProject(), (VirtualFile)sourceFile, (DeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE()), rc -> ComposeFileRunLineMarkerProvider.isForAllServices(rc));
            LinkedList<DockerRunLineMarkerProviderBase.RunExistingRunConfig> knownsGroup = new LinkedList<DockerRunLineMarkerProviderBase.RunExistingRunConfig>();
            LinkedList<Object> unknownsGroup = new LinkedList<Object>();
            for (DockerRunLineMarkerProviderBase.DockerRunConfig nextFound : foundConfigs) {
                knownsGroup.add(new DockerRunLineMarkerProviderBase.RunExistingRunConfig(helper, nextFound));
            }
            List allAccounts = ComposeFileRunLineMarkerProvider.listAllDockerAccounts();
            if (allAccounts.isEmpty()) {
                DockerRunLineMarkerProviderBase.ConfigureNewRunConfig theOnlyAction = new DockerRunLineMarkerProviderBase.ConfigureNewRunConfig(helper, sourceFile, (DockerSingletonDeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE(), null);
                theOnlyAction.getTemplatePresentation().setIcon(DockerIcons.Docker);
                unknownsGroup.add(theOnlyAction);
            } else {
                List remainingServers = ComposeFileRunLineMarkerProvider.allServersExceptKnowns((List)foundConfigs);
                for (RemoteServer nextDocker : remainingServers) {
                    unknownsGroup.add(new DockerRunLineMarkerProviderBase.FireAsTemporaryRunConfigAction(helper, sourceFile, (DockerSingletonDeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE(), nextDocker));
                }
            }
            return ComposeFileRunLineMarkerProvider.combineActions((List)knownsGroup, (List)unknownsGroup);
        }

        @Override
        @Nullable
        public String getLineMarkerTooltip() {
            if (this.getActionIfTheOnly() != null) {
                return DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.AllServicesLineMarkerInfo.tooltip", new Object[0]);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$AllServicesLineMarkerInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeAllActions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ServiceLineMarkerInfo
    extends MostlySingleActionLineMarkerInfo {
        private final String myServiceName;
        @Nullable
        private final DockerRuntimesManagerService.ComposeServiceStatus myServiceStatus;

        ServiceLineMarkerInfo(@NotNull PsiElement psi, @NotNull String serviceName, @Nullable DockerRuntimesManagerService.ComposeServiceStatus serviceStatus) {
            if (psi == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (serviceName == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(1);
            }
            super(psi, serviceStatus == null ? AllIcons.RunConfigurations.TestState.Run : ComposeFileRunLineMarkerProvider.getServiceActionIcon(serviceStatus));
            this.myServiceName = serviceName;
            this.myServiceStatus = serviceStatus;
        }

        @Override
        @Nullable
        protected ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile) {
            if (helper == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if (sourceFile == null) {
                ServiceLineMarkerInfo.$$$reportNull$$$0(3);
            }
            List forThisService = ContainerUtil.filter((Collection)DockerRunLineMarkerProviderBase.DockerRunConfig.dockerConfigs((Project)helper.getProject(), (VirtualFile)sourceFile, (DeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE()), rc -> ComposeFileRunLineMarkerProvider.isForOnlyService(rc, this.myServiceName));
            LinkedList<DockerRunLineMarkerProviderBase.RunExistingRunConfig> knownsGroup = new LinkedList<DockerRunLineMarkerProviderBase.RunExistingRunConfig>();
            for (DockerRunLineMarkerProviderBase.DockerRunConfig nextFound : forThisService) {
                knownsGroup.add(new DockerRunLineMarkerProviderBase.RunExistingRunConfig(helper, nextFound));
            }
            LinkedList<Object> unknownsGroup = new LinkedList<Object>();
            List allAccounts = ComposeFileRunLineMarkerProvider.listAllDockerAccounts();
            if (allAccounts.isEmpty()) {
                ConfigureServiceRunConfig theOnlyAction = new ConfigureServiceRunConfig(helper, sourceFile, this.myServiceName, null);
                theOnlyAction.getTemplatePresentation().setIcon(DockerIcons.Docker);
                unknownsGroup.add((Object)theOnlyAction);
            } else {
                for (RemoteServer nextDocker : ComposeFileRunLineMarkerProvider.allServersExceptKnowns((List)forThisService)) {
                    unknownsGroup.add((Object)new UpOneServiceAsTemporaryAction(helper, sourceFile, this.myServiceName, (RemoteServer<DockerCloudConfiguration>)nextDocker));
                }
            }
            return ComposeFileRunLineMarkerProvider.combineActions((List)knownsGroup, (List)unknownsGroup);
        }

        @Override
        @Nullable
        public String getLineMarkerTooltip() {
            if (this.getActionIfTheOnly() != null) {
                return this.myServiceStatus == DockerRuntimesManagerService.ComposeServiceStatus.DEPLOYED ? DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.ServiceLineMarkerInfo.restart.tooltip", this.myServiceName) : DockerComposeBundle.message("ComposeFileRunLineMarkerProvider.ServiceLineMarkerInfo.up.tooltip", this.myServiceName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$ServiceLineMarkerInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeAllActions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MostlySingleActionLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final DockerRunConfigurationCreator myHelper;
        private final VirtualFile mySourceFile;

        MostlySingleActionLineMarkerInfo(@NotNull PsiElement psi, @NotNull Icon icon) {
            if (psi == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(1);
            }
            this(psi, icon, DefaultRunExecutor.getRunExecutorInstance());
        }

        MostlySingleActionLineMarkerInfo(@NotNull PsiElement psi, @NotNull Icon icon, @NotNull Executor executor) {
            if (psi == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(2);
            }
            if (icon == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(3);
            }
            if (executor == null) {
                MostlySingleActionLineMarkerInfo.$$$reportNull$$$0(4);
            }
            super(psi, psi.getTextRange(), icon, null, null, GutterIconRenderer.Alignment.CENTER);
            this.myHelper = new DockerRunConfigurationCreator(psi.getProject(), executor);
            this.mySourceFile = Optional.ofNullable(psi.getContainingFile()).map(PsiFile::getVirtualFile).orElse(null);
        }

        @Nullable
        public String getLineMarkerTooltip() {
            AnAction theOnly = this.getActionIfTheOnly();
            if (theOnly == null) {
                return null;
            }
            Presentation presentation = theOnly.getTemplatePresentation();
            return Optional.ofNullable(presentation.getDescription()).orElseGet(() -> ((Presentation)presentation).getText());
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return this.getActionIfTheOnly();
                }

                public boolean isNavigateAction() {
                    return true;
                }

                @Nullable
                public ActionGroup getPopupMenuActions() {
                    return this.computeAllActions(myHelper, mySourceFile);
                }
            };
        }

        @Nullable
        protected abstract ActionGroup computeAllActions(@NotNull DockerRunConfigurationCreator var1, @NotNull VirtualFile var2);

        @Nullable
        protected AnAction getActionIfTheOnly() {
            AnAction[] actions = Optional.ofNullable(this.computeAllActions(this.myHelper, this.mySourceFile)).map(ag -> ag.getChildren(null)).orElse(AnAction.EMPTY_ARRAY);
            return actions.length == 1 ? actions[0] : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psi";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$MostlySingleActionLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UpOneServiceAsTemporaryAction
    extends DockerRunLineMarkerProviderBase.FireAsTemporaryRunConfigAction {
        private final String myService;

        UpOneServiceAsTemporaryAction(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull String service, @NotNull RemoteServer<DockerCloudConfiguration> docker) {
            if (helper == null) {
                UpOneServiceAsTemporaryAction.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                UpOneServiceAsTemporaryAction.$$$reportNull$$$0(1);
            }
            if (service == null) {
                UpOneServiceAsTemporaryAction.$$$reportNull$$$0(2);
            }
            if (docker == null) {
                UpOneServiceAsTemporaryAction.$$$reportNull$$$0(3);
            }
            super(helper, sourceFile, (DockerSingletonDeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE(), docker);
            this.myService = service;
            this.getTemplatePresentation().setText(DockerComposeBundle.messagePointer("ComposeFileRunLineMarkerProvider.UpOneServiceAsTemporaryAction.text", docker.getName()));
        }

        protected void customize(DockerRunLineMarkerProviderBase.DockerRunConfig runConfig) {
            ComposeFileRunLineMarkerProvider.setupOneComposeService(runConfig, this.myService);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sourceFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "service";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "docker";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$UpOneServiceAsTemporaryAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConfigureServiceRunConfig
    extends DockerRunLineMarkerProviderBase.ConfigureNewRunConfig {
        private final String myService;

        ConfigureServiceRunConfig(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull String service, @Nullable RemoteServer<?> docker) {
            if (helper == null) {
                ConfigureServiceRunConfig.$$$reportNull$$$0(0);
            }
            if (sourceFile == null) {
                ConfigureServiceRunConfig.$$$reportNull$$$0(1);
            }
            if (service == null) {
                ConfigureServiceRunConfig.$$$reportNull$$$0(2);
            }
            super(helper, sourceFile, (DockerSingletonDeploymentSourceType)ComposeFileRunLineMarkerProvider.COMPOSE(), docker);
            this.myService = service;
        }

        protected void customizeRunConfig(@NotNull RunnerAndConfigurationSettings runnerAndSettings) {
            if (runnerAndSettings == null) {
                ConfigureServiceRunConfig.$$$reportNull$$$0(3);
            }
            super.customizeRunConfig(runnerAndSettings);
            DockerRunLineMarkerProviderBase.DockerRunConfig wrapper = DockerRunLineMarkerProviderBase.DockerRunConfig.wrapIfDocker((RunnerAndConfigurationSettings)runnerAndSettings);
            assert (wrapper != null) : "for " + runnerAndSettings;
            ComposeFileRunLineMarkerProvider.setupOneComposeService(wrapper, this.myService);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnerAndSettings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileRunLineMarkerProvider$ConfigureServiceRunConfig";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeRunConfig";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

