/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionExStubElementType;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlTableKeyElementType<T extends SqlDefinition>
extends SqlDefinitionExStubElementType<SqlTableKeyStub<T>, T> {
    public static NotNullFunction<String, SqlTableKeyElementType<?>> factory(@NotNull SqlReferenceElementType referenceType) {
        if (referenceType == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(0);
        }
        return name -> new SqlTableKeyElementType(referenceType, (String)name);
    }

    protected SqlTableKeyElementType(@NotNull SqlReferenceElementType refType, @NonNls @NotNull String debugName) {
        if (refType == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(1);
        }
        if (debugName == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(2);
        }
        super(debugName, refType);
    }

    @Override
    @NotNull
    public SqlTableKeyStub<T> createStub(@NotNull T psi, StubElement parentStub) {
        if (psi == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(3);
        }
        SqlKIFKImpl impl = (SqlKIFKImpl)((Object)psi);
        String tableName = impl.getTableName();
        Iterable columnNames = impl.getColumnsRef().names();
        String keyText = tableName == null ? null : SqlTableKeyElementType.tableColumnList(tableName, columnNames);
        SqlNameElement nameElement = impl.getNameElement();
        return new SqlTableKeyStub(parentStub, this, SqlTableKeyElementType.asStringRef((PsiElement)nameElement), SqlTableKeyElementType.buildProperties(psi), keyText == null ? null : StringRef.fromString((String)keyText));
    }

    @Override
    public void serialize(@NotNull SqlTableKeyStub<T> stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(4);
        }
        if (dataStream == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(5);
        }
        super.serialize(stub, dataStream);
        dataStream.writeName(stub.getKeyText());
    }

    @Override
    @NotNull
    public SqlTableKeyStub<T> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlTableKeyElementType.$$$reportNull$$$0(6);
        }
        return new SqlTableKeyStub(parentStub, this, dataStream.readName(), SqlTableKeyElementType.loadProperties(parentStub, dataStream), dataStream.readName());
    }

    static String tableColumnList(String tableName, Iterable<String> columnNames) {
        if (Iterables.isEmpty(columnNames)) {
            return tableName;
        }
        return tableName + "(" + StringUtil.join(columnNames, (String)",") + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/stubs/SqlTableKeyElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "factory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

