/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAsExpressionImpl
extends SqlDefinitionImpl
implements SqlAsExpression,
SqlLocalDefinition {
    public SqlAsExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    public SqlType getSqlType() {
        SqlExpression expression = this.getExpression();
        if (expression == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlAsExpressionImpl.$$$reportNull$$$0(1);
            }
            return sqlPrimitiveType;
        }
        SqlType type = expression.getSqlType();
        List<SqlDefinition> aliases = this.getColumnAliasList();
        if (aliases.isEmpty()) {
            if (type instanceof SqlTableType) {
                if (this.getParent() instanceof SqlSelectClause) {
                    SqlTableType tableType = (SqlTableType)type;
                    SqlType sqlType = tableType.getColumnCount() == 1 ? tableType.getColumnType(0) : type;
                    if (sqlType == null) {
                        SqlAsExpressionImpl.$$$reportNull$$$0(2);
                    }
                    return sqlType;
                }
                SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType(type, (PsiElement)expression, (PsiElement)this).aliasByDefs(this.getName(), (PsiElement)this, aliases);
                if (sqlTableType == null) {
                    SqlAsExpressionImpl.$$$reportNull$$$0(3);
                }
                return sqlTableType;
            }
            SqlType sqlType = type;
            if (sqlType == null) {
                SqlAsExpressionImpl.$$$reportNull$$$0(4);
            }
            return sqlType;
        }
        SqlTableType tableType = SqlTableTypeBase.ensureTableType(type, (PsiElement)expression, (PsiElement)this);
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDbms().isPostgres()) {
            aliases = SqlTableTypeBase.expand(aliases, tableType.getColumnCount());
        }
        SqlTableType sqlTableType = tableType.aliasByDefs(this.getName(), (PsiElement)this, aliases);
        if (sqlTableType == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(5);
        }
        return sqlTableType;
    }

    @Nullable
    public PsiElement getDefinitionScope() {
        PsiElement context = this.getContext();
        if (context instanceof SqlDeclareStatement) {
            return this.getTopmostBlockStatement();
        }
        if (PsiUtilCore.getElementType((PsiElement)context) == SqlCompositeElementTypes.SQL_REFERENCING_CLAUSE && SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDbms().isPostgres()) {
            return this.getTopmostBlockStatement();
        }
        if (context instanceof SqlSelectClause && SqlAsExpressionImpl.areAnyContextEnlargersUpwards(context)) {
            return this.getTopmostBlockStatement();
        }
        return PsiTreeUtil.getContextOfType((PsiElement)this, SqlStatement.class, (boolean)true);
    }

    private static boolean areAnyContextEnlargersUpwards(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(6);
        }
        for (PsiElement tmp = element2; tmp != null; tmp = tmp.getContext()) {
            if (tmp instanceof SqlSelectClause || tmp instanceof SqlSetOperatorExpression || tmp instanceof SqlJoinExpression) continue;
            if (tmp instanceof SqlQueryExpression && PsiTreeUtil.getNextSiblingOfType((PsiElement)((SqlQueryExpression)tmp).getSelectClause(), SqlSelectIntoNewTableClauseImpl.class) != null) {
                return true;
            }
            if (tmp instanceof SqlCreateTableStatement) {
                return true;
            }
            if (tmp instanceof SqlStatement) {
                return false;
            }
            if (tmp instanceof SqlFunctionCallExpression) {
                return false;
            }
            if (!(tmp instanceof SqlBinaryExpression)) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement scope = this.getDefinitionScope();
        return new LocalSearchScope((PsiElement)(scope == null ? this.getContainingFile() : scope));
    }

    protected SqlBlockStatementImpl getTopmostBlockStatement() {
        SqlBlockStatementImpl next;
        SqlBlockStatementImpl answer = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{SqlBlockStatementImpl.class});
        while ((next = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)answer, (Class[])new Class[]{SqlBlockStatementImpl.class})) != null) {
            answer = next;
        }
        return answer;
    }

    @NotNull
    public List<SqlDefinition> getColumnAliasList() {
        SqlColumnAliasListImpl columnAliasList = this.findChildByClass(SqlColumnAliasListImpl.class);
        List<Object> list = columnAliasList != null ? columnAliasList.getColumnAliasList() : Collections.emptyList();
        if (list == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlAsExpression((SqlAsExpression)this);
    }

    @Nullable
    public SqlIdentifier getNameElement() {
        return this.findChildByClass(SqlIdentifier.class);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
        if (objectKind == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(8);
        }
        return objectKind;
    }

    @Nullable
    public PsiReference getReference() {
        return SqlImplUtil.getReference((PsiElement)this, this.getNameElement());
    }

    @Nullable
    public SqlExpression getExpression() {
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Variable;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        SqlReferenceExpression asExpression;
        boolean isChild;
        if (processor == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(11);
        }
        if (isChild = PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)place, (boolean)true)) {
            if (place.getParent() instanceof SqlReferenceList && this.getLastChild() == place.getParent()) {
                return processor.execute(place, state);
            }
            if (this.getNode().getElementType() == SqlCompositeElementTypes.SQL_NAMED_QUERY_DEFINITION && !processor.execute((PsiElement)this, state)) {
                return false;
            }
        }
        return !((asExpression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getExpression(), SqlReferenceExpression.class)) != null && this.getColumnAliasList().isEmpty() && !PsiTreeUtil.isContextAncestor((PsiElement)asExpression, (PsiElement)place, (boolean)false) ? asExpression != lastParent && !SqlImplUtil.processQualifier(asExpression, processor, state, place) : !isChild && !SqlImplUtil.processDeclarationsInType((SqlExpression)this, processor, state, place));
    }

    public short getPosition() {
        return (Short)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcPosition(this), (Object[])new Object[]{SqlImplUtil.sqlParent((PsiElement)this)}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlAsExpressionImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlAsExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliasList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "areAnyContextEnlargersUpwards";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

