/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.JoinConditionInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/intentions/SqlConvertJoinOnToNaturalIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "getTargetElement", "Lcom/intellij/sql/psi/SqlJoinConditionClause;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlConvertJoinOnToNaturalIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace ON with NATURAL JOIN";
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.getTargetElement(element2) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        SqlJoinConditionClause sqlJoinConditionClause = this.getTargetElement(element2);
        if (sqlJoinConditionClause == null) {
            return;
        }
        JoinUtilsKt.convertToNaturalJoin(project, (SqlClause)sqlJoinConditionClause);
    }

    private final SqlJoinConditionClause getTargetElement(PsiElement element2) {
        JoinConditionInfo<SqlJoinConditionClause> joinConditionInfo = JoinUtilsKt.getJoinOnInfo(element2);
        if (joinConditionInfo == null) {
            return null;
        }
        JoinConditionInfo<SqlJoinConditionClause> info = joinConditionInfo;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(element)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlJoinConditionClause sqlJoinConditionClause = info.getClause();
        boolean bl = false;
        boolean bl2 = false;
        SqlJoinConditionClause it2 = sqlJoinConditionClause;
        boolean bl3 = false;
        return dialect.supportsNaturalJoin() && JoinUtilsKt.canBeNaturalJoin(info.getColumnRefs(), info.getLeftTableRef(), info.getRightTableRef(), dialect) ? sqlJoinConditionClause : null;
    }
}

