/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/intentions/SqlConvertInToEqualityIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "getTargetExpression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlConvertInToEqualityIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace IN expression with equality checks";
    }

    private final SqlBinaryExpression getTargetExpression(PsiElement element2) {
        Object v4;
        block2: {
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(element)");
            Dbms dbms = sqlLanguageDialectEx.getDbms();
            Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(element).dbms");
            if (dbms.isCassandra()) {
                return null;
            }
            JBIterable jBIterable = SqlImplUtil.sqlParents(element2).filter(SqlBinaryExpression.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil\n      .sqlPa\u2026ryExpression::class.java)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBinaryExpression it2 = (SqlBinaryExpression)element$iv;
                boolean bl = false;
                SqlBinaryExpression sqlBinaryExpression = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlBinaryExpression, (String)"it");
                if (!(Intrinsics.areEqual((Object)sqlBinaryExpression.getOpSign(), (Object)SqlCommonKeywords.SQL_IN) && it2.getLOperand() instanceof SqlReferenceExpression && it2.getROperand() instanceof SqlParenthesizedExpression)) continue;
                v4 = element$iv;
                break block2;
            }
            v4 = null;
        }
        return v4;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.getTargetExpression(element2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        SqlBinaryExpression sqlBinaryExpression = this.getTargetExpression(element2);
        if (sqlBinaryExpression == null) {
            return;
        }
        SqlBinaryExpression inExpr = sqlBinaryExpression;
        boolean isNot = inExpr.isNot();
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)inExpr);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(inExpr)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        SqlExpression sqlExpression = inExpr.getLOperand();
        if (!(sqlExpression instanceof SqlReferenceExpression)) {
            sqlExpression = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression subject = sqlReferenceExpression;
        SqlExpression sqlExpression2 = inExpr.getROperand();
        if (!(sqlExpression2 instanceof SqlParenthesizedExpression)) {
            sqlExpression2 = null;
        }
        if ((object = (SqlParenthesizedExpression)sqlExpression2) == null || (object = object.getExpressionList()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(inExpr.rOperand as? Sql\u2026.expressionList ?: return");
        Object values2 = object;
        boolean needsParentheses = inExpr.getParent() instanceof SqlOperatorExpression;
        if (needsParentheses) {
            builder.symbol("(");
        }
        String logicalOp = isNot ? "and" : "or";
        String comparisonOp = isNot ? "<>" : "=";
        boolean bl = false;
        for (SqlExpression value2 : (Iterable)values2) {
            void i2;
            if (i2 > 0) {
                builder.keyword(' ' + logicalOp + ' ');
            }
            builder.plain(subject.getText());
            builder.symbol(' ' + comparisonOp + ' ');
            SqlExpression sqlExpression3 = value2;
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression3, (String)"value");
            builder.plain(sqlExpression3.getText());
            ++i2;
        }
        if (needsParentheses) {
            builder.symbol(")");
        }
        DdlBuilder ddlBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder");
        SqlExpression sqlExpression4 = SqlPsiElementFactory.createExpressionFromText(ddlBuilder.getStatement(), dialect, project, null);
        if (sqlExpression4 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression4, (String)"SqlPsiElementFactory.cre\u2026dialect, project, null)!!");
        SqlExpression eqExpr = sqlExpression4;
        inExpr.replace((PsiElement)eqExpr);
    }
}

