/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlMultipleLimitClausesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlMultipleLimitClausesInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result, manager, dialect, result){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlQueryExpression(@NotNull SqlQueryExpression o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                super.visitSqlQueryExpression(o);
                JBIterable jBIterable = o.getLimitClauses();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"o.limitClauses");
                this.reportClauses((JBIterable<? extends SqlClause>)jBIterable, "Multiple limiting clauses are not allowed");
                JBIterable jBIterable2 = o.getOffsetClauses();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"o.offsetClauses");
                this.reportClauses((JBIterable<? extends SqlClause>)jBIterable2, "Multiple offset clauses are not allowed");
            }

            private final void reportClauses(JBIterable<? extends SqlClause> clauses, String message2) {
                if (clauses.size() <= 1) {
                    return;
                }
                Iterable $this$forEach$iv = (Iterable)clauses;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqlClause it2 = (SqlClause)element$iv;
                    boolean bl = false;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)it2, message2, (LocalQuickFix)DropPsiFix.INSTANCE, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                }
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }
}

