/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.RenamePsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/SqlMissingColumnAliasesInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "IntroduceAliasFix", "intellij.database.sql.impl"})
public final class SqlMissingColumnAliasesInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result, manager, dialect, result){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlSelectClause(@NotNull SqlSelectClause o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                super.visitSqlSelectClause(o);
                for (SqlExpression expression : o.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, "Missing column alias", true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[]{IntroduceAliasFix.INSTANCE}));
                }
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/SqlMissingColumnAliasesInspection$IntroduceAliasFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "startInWriteAction", "", "intellij.database.sql.impl"})
    private static final class IntroduceAliasFix
    implements LocalQuickFix {
        public static final IntroduceAliasFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            return "Introduce alias";
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getStartElement();
            if (!(psiElement instanceof SqlExpression)) {
                psiElement = null;
            }
            SqlExpression sqlExpression = (SqlExpression)psiElement;
            if (sqlExpression == null) {
                return;
            }
            SqlExpression expression = sqlExpression;
            PsiFile file = expression.getContainingFile();
            SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
            SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
            String string = SqlNamesGenerator.suggestAliasName(expression);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SqlNamesGenerator.suggestAliasName(expression)");
            String aliasName = string;
            DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect()).plain(expression.getText()).keyword(" as ").alias(aliasName);
            Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"DdlBuilder()\n        .co\u2026        .alias(aliasName)");
            String string2 = ddlBuilder.getStatement();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DdlBuilder()\n        .co\u2026sName)\n        .statement");
            String aliasExprText = string2;
            boolean $i$f$runWriteAction = false;
            Object object = ApplicationManager.getApplication().runWriteAction(new Computable<T>(expression, aliasExprText, dialect){
                final /* synthetic */ SqlExpression $expression$inlined;
                final /* synthetic */ String $aliasExprText$inlined;
                final /* synthetic */ SqlLanguageDialectEx $dialect$inlined;
                {
                    this.$expression$inlined = sqlExpression;
                    this.$aliasExprText$inlined = string;
                    this.$dialect$inlined = sqlLanguageDialectEx;
                }

                public final T compute() {
                    boolean bl = false;
                    SqlExpression sqlExpression = SqlPsiElementFactory.createColumnAliasFromText(this.$aliasExprText$inlined, this.$dialect$inlined, (PsiElement)this.$expression$inlined);
                    if (sqlExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    return (T)this.$expression$inlined.replace((PsiElement)sqlExpression);
                }
            });
            if (!(object instanceof SqlAsExpression)) {
                object = null;
            }
            SqlAsExpression sqlAsExpression = (SqlAsExpression)object;
            if (sqlAsExpression == null) {
                return;
            }
            SqlAsExpression aliasExpression = sqlAsExpression;
            PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
            Document document = docManager.getDocument(file);
            if (document == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"docManager.getDocument(file) ?: return");
            Document doc2 = document;
            docManager.commitDocument(doc2);
            docManager.doPostponedOperationsAndUnblockDocument(doc2);
            SqlIdentifier sqlIdentifier = aliasExpression.getNameElement();
            if (sqlIdentifier == null) {
                return;
            }
            RenamePsiFix.INSTANCE.applyFix((PsiElement)sqlIdentifier);
        }

        private IntroduceAliasFix() {
        }

        static {
            IntroduceAliasFix introduceAliasFix;
            INSTANCE = introduceAliasFix = new IntroduceAliasFix();
        }
    }
}

