/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlQueryValidatorInspectionBase;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlDeleteDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinWithoutOnInspection
extends SqlQueryValidatorInspectionBase {
    @Override
    @Nullable
    protected SqlQueryValidatorInspectionBase.Visitor createVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly, boolean isQueryValidationPass) {
        if (dialect == null) {
            SqlJoinWithoutOnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlJoinWithoutOnInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlJoinWithoutOnInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isMysql()) {
            return null;
        }
        return new SqlQueryValidatorInspectionBase.Visitor(manager, dialect, result, onTheFly, isQueryValidationPass){

            public void visitSqlDeleteStatement(SqlDeleteStatement o) {
                SqlDeleteDmlInstructionImpl deleteDmlInstruction = (SqlDeleteDmlInstructionImpl)PsiTreeUtil.getChildOfType((PsiElement)o, SqlDeleteDmlInstructionImpl.class);
                SqlReferenceExpression referenceExpression = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)deleteDmlInstruction, SqlReferenceExpression.class);
                if (referenceExpression == null) {
                    return;
                }
                SqlExpression targetExpression = deleteDmlInstruction.getTargetExpression();
                if (!(targetExpression instanceof SqlJoinExpression)) {
                    return;
                }
                PsiElement resolvedElement = referenceExpression.resolve();
                if (resolvedElement == null) {
                    return;
                }
                SqlWhereClause whereClause2 = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)deleteDmlInstruction, SqlWhereClause.class);
                if (whereClause2 != null) {
                    for (SqlReferenceExpression expression : SqlImplUtil.sqlTraverser((PsiElement)whereClause2).filter(SqlReferenceExpression.class)) {
                        if (!expression.getReference().isReferenceTo(resolvedElement)) continue;
                        return;
                    }
                }
                this.checkJoinExpression((SqlJoinExpression)targetExpression);
            }

            private void checkJoinExpression(SqlJoinExpression o) {
                SqlClause onOrUsingClause = (SqlClause)PsiTreeUtil.findChildOfAnyType((PsiElement)o, (Class[])new Class[]{SqlJoinConditionClause.class, SqlUsingClause.class});
                if (onOrUsingClause != null) {
                    return;
                }
                PsiElement joinKeyword = SqlJoinWithoutOnInspection.getJoinKeyword(o);
                if (joinKeyword == null) {
                    return;
                }
                this.reportIssue(joinKeyword, SqlBundle.message("join.without.on", new Object[0]));
            }
        };
    }

    @Nullable
    private static PsiElement getJoinKeyword(@NotNull SqlJoinExpression o) {
        if (o == null) {
            SqlJoinWithoutOnInspection.$$$reportNull$$$0(3);
        }
        for (PsiElement child = o.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof LeafPsiElement)) continue;
            IElementType elementType = ((LeafPsiElement)child).getElementType();
            if (elementType == SqlCommonKeywords.SQL_NATURAL || elementType == SqlCommonKeywords.SQL_CROSS) {
                return null;
            }
            if (elementType != SqlCommonKeywords.SQL_JOIN) continue;
            return child;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/SqlJoinWithoutOnInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getJoinKeyword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

