/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlErrorHandlingInspection;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlConditionDefinition;
import com.intellij.sql.psi.SqlDeclareConditionHandlerStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlErrorSpec;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlConditionErrorSpec;
import com.intellij.sql.psi.impl.SqlErrorCodeSpec;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSignalStatement;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlErrorHandlingInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlErrorHandlingInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, onTheFly, dbms2, dialect, result, manager, dialect, result){
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            private final boolean isGoodSqlState(SqlExpression expression) {
                if (!(expression instanceof SqlStringLiteralExpression)) {
                    return false;
                }
                String string = ((SqlStringLiteralExpression)expression).getValue();
                if (string == null) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.value ?: return false");
                String value2 = string;
                return value2.length() == 5 && !StringsKt.startsWith$default((String)value2, (String)"00", (boolean)false, (int)2, null);
            }

            private final void reportError(PsiElement element2, String message2) {
                this.addDescriptor(this.$manager.createProblemDescriptor(element2, message2, true, ProblemHighlightType.GENERIC_ERROR, this.$onTheFly, new LocalQuickFix[0]));
            }

            private final void checkBadSqlState(SqlExpression sqlStateExpr, PsiElement reportOn) {
                if (!this.isGoodSqlState(sqlStateExpr)) {
                    this.reportError(reportOn, "SQLSTATE value must be a 5-character string literal an may not start with '00'");
                }
            }

            static /* synthetic */ void checkBadSqlState$default(createAnnotationVisitor.1 var0, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
                if ((n & 2) != 0) {
                    psiElement = (PsiElement)sqlExpression;
                }
                var0.checkBadSqlState(sqlExpression, psiElement);
            }

            private final void checkBadErrorCode(SqlExpression errorCodeExpr, PsiElement reportOn) {
                String string = errorCodeExpr.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"errorCodeExpr.text");
                Integer n = StringsKt.toIntOrNull((String)string);
                if (n != null && n == 0) {
                    this.reportError(reportOn, "Error code may not be zero");
                }
            }

            static /* synthetic */ void checkBadErrorCode$default(createAnnotationVisitor.1 var0, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
                if ((n & 2) != 0) {
                    psiElement = (PsiElement)sqlExpression;
                }
                var0.checkBadErrorCode(sqlExpression, psiElement);
            }

            private final void checkErrorCodeExpr(SqlExpression errorCodeExpr, PsiElement reportOn) {
                block1: {
                    SqlExpression sqlExpression;
                    block0: {
                        sqlExpression = errorCodeExpr;
                        if (!(sqlExpression instanceof SqlStringLiteralExpression)) break block0;
                        this.checkBadSqlState(errorCodeExpr, reportOn);
                        break block1;
                    }
                    if (!(sqlExpression instanceof SqlLiteralExpression)) break block1;
                    this.checkBadErrorCode(errorCodeExpr, reportOn);
                }
            }

            static /* synthetic */ void checkErrorCodeExpr$default(createAnnotationVisitor.1 var0, SqlExpression sqlExpression, PsiElement psiElement, int n, Object object) {
                if ((n & 2) != 0) {
                    psiElement = (PsiElement)sqlExpression;
                }
                var0.checkErrorCodeExpr(sqlExpression, psiElement);
            }

            private final JBIterable<PsiElement> getOptionKeywords(SqlRaiseStatement statement) {
                JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)statement.getOptionsClause()).filter(SqlSetAssignment.class).map((Function)createAnnotationVisitor.getOptionKeywords.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil\n          .s\u2026     .first()\n          }");
                return jBIterable;
            }

            private final void checkSignalStatement(SqlSignalStatement o) {
                SqlDeclareConditionHandlerStatement parentHandler;
                SqlErrorSpec errorSpec = o.getErrorSpec();
                SqlErrorSpec sqlErrorSpec = errorSpec;
                if (sqlErrorSpec instanceof SqlErrorCodeSpec) {
                    SqlExpression sqlExpression = ((SqlErrorCodeSpec)errorSpec).getErrorCode();
                    if (sqlExpression != null) {
                        SqlExpression sqlExpression2 = sqlExpression;
                        boolean bl = false;
                        boolean bl2 = false;
                        SqlExpression it2 = sqlExpression2;
                        boolean bl3 = false;
                        SqlExpression sqlExpression3 = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression3, (String)"it");
                        createAnnotationVisitor.1.checkBadSqlState$default(this, sqlExpression3, null, 2, null);
                    }
                } else if (sqlErrorSpec instanceof SqlConditionErrorSpec) {
                    SqlExpression errorCodeExpr;
                    SqlConditionDefinition condition;
                    SqlCompositeElementImpl sqlCompositeElementImpl;
                    PsiElement psiElement = ((SqlConditionErrorSpec)errorSpec).resolve();
                    if (!(psiElement instanceof SqlConditionDefinition)) {
                        psiElement = null;
                    }
                    SqlExpression sqlExpression = (sqlCompositeElementImpl = (condition = (SqlConditionDefinition)psiElement)) != null && (sqlCompositeElementImpl = ((SqlConditionDefinition)sqlCompositeElementImpl).getErrorSpec()) != null ? ((SqlErrorCodeSpec)sqlCompositeElementImpl).getErrorCode() : (errorCodeExpr = null);
                    if (errorCodeExpr != null && !(errorCodeExpr instanceof SqlStringLiteralExpression)) {
                        this.reportError((PsiElement)errorSpec, "Condition used in SIGNAL statement must be associated with SQLSTATE value");
                    }
                }
                if (this.$dbms.isMysql()) {
                    HashSet<PsiElement> visitedNames = new HashSet<PsiElement>();
                    for (PsiElement optionKeyword : this.getOptionKeywords(o)) {
                        Object object = optionKeyword;
                        if (object == null || (object = object.getText()) == null) {
                            continue;
                        }
                        Object optionName = object;
                        if (visitedNames.add((PsiElement)optionName)) continue;
                        this.reportError(optionKeyword, "Duplicate condition information item: " + (String)optionName);
                    }
                }
                if (o.isReraise() && (parentHandler = (SqlDeclareConditionHandlerStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlDeclareConditionHandlerStatement.class, (boolean)true, (Class[])new Class[]{SqlDefinition.class})) == null) {
                    this.reportError((PsiElement)o, "RESIGNAL may not be used outside condition handler context");
                }
            }

            public void visitSqlDefinition(@NotNull SqlDefinition o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (o instanceof SqlConditionDefinition) {
                    SqlErrorCodeSpec sqlErrorCodeSpec = ((SqlConditionDefinition)o).getErrorSpec();
                    if (sqlErrorCodeSpec == null || (sqlErrorCodeSpec = sqlErrorCodeSpec.getErrorCode()) == null) {
                        return;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlErrorCodeSpec), (String)"o.errorSpec?.errorCode ?: return");
                    SqlErrorCodeSpec errorCodeExpr = sqlErrorCodeSpec;
                    createAnnotationVisitor.1.checkErrorCodeExpr$default(this, (SqlExpression)errorCodeExpr, null, 2, null);
                } else {
                    super.visitSqlDefinition(o);
                }
            }

            public void visitSqlDeclareConditionHandlerStatement(@NotNull SqlDeclareConditionHandlerStatement o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                for (SqlErrorSpec errorSpec : o.getErrorSpecs()) {
                    SqlErrorCodeSpec sqlErrorCodeSpec;
                    SqlErrorCodeSpec errorCodeSpec = null;
                    PsiElement reportOn = null;
                    SqlErrorSpec sqlErrorSpec = errorSpec;
                    if (sqlErrorSpec instanceof SqlErrorCodeSpec) {
                        errorCodeSpec = (SqlErrorCodeSpec)errorSpec;
                    } else if (sqlErrorSpec instanceof SqlConditionErrorSpec) {
                        PsiElement psiElement = ((SqlConditionErrorSpec)errorSpec).resolve();
                        if (!(psiElement instanceof SqlConditionDefinition)) {
                            psiElement = null;
                        }
                        SqlConditionDefinition sqlConditionDefinition = (SqlConditionDefinition)psiElement;
                        errorCodeSpec = sqlConditionDefinition != null ? sqlConditionDefinition.getErrorSpec() : null;
                        reportOn = (PsiElement)errorSpec;
                    }
                    if ((sqlErrorCodeSpec = errorCodeSpec) == null || (sqlErrorCodeSpec = sqlErrorCodeSpec.getErrorCode()) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlErrorCodeSpec), (String)"errorCodeSpec?.errorCode ?: continue");
                    SqlErrorCodeSpec errorCodeExpr = sqlErrorCodeSpec;
                    PsiElement psiElement = reportOn;
                    if (psiElement == null) {
                        psiElement = (PsiElement)errorCodeExpr;
                    }
                    this.checkErrorCodeExpr((SqlExpression)errorCodeExpr, psiElement);
                }
                if ((this.$dbms.isMysql() || this.$dbms.isDb2()) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)o.getKindKeyword()), (Object)SqlCommonKeywords.SQL_UNDO)) {
                    PsiElement psiElement = o.getKindKeyword();
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"o.kindKeyword!!");
                    this.reportError(psiElement, "UNDO handlers are not supported");
                }
                JBIterable jBIterable = o.getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"o.body");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqlStatement it2 = (SqlStatement)element$iv;
                    boolean bl = false;
                    it2.accept((SqlVisitor)this);
                }
            }

            public void visitSqlRaiseStatement(@NotNull SqlRaiseStatement o) {
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (o instanceof SqlSignalStatement) {
                    this.checkSignalStatement((SqlSignalStatement)o);
                } else {
                    if (this.$dbms.isOracle() || this.$dbms.isPostgres()) {
                        PsiElement psiElement = o.getFirstChild();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"o.firstChild");
                        if (psiElement.getNextSibling() == null) {
                            JBIterable jBIterable = SqlImplUtil.sqlParents((PsiElement)o).filter(SqlExceptionWhenClause.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"SqlImplUtil.sqlParents(o\u2026onWhenClause::class.java)");
                            if (jBIterable.isEmpty()) {
                                this.reportError((PsiElement)o, "RAISE without arguments may not be used outside exception handler");
                            }
                        }
                    }
                    if (this.$dbms.isPostgres() && o.getErrorSpec() != null) {
                        Object v2;
                        block8: {
                            Iterable $this$firstOrNull$iv = (Iterable)this.getOptionKeywords(o);
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                PsiElement it2 = (PsiElement)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_ERRCODE)) continue;
                                v2 = element$iv;
                                break block8;
                            }
                            v2 = null;
                        }
                        PsiElement errorCodeOption = v2;
                        if (errorCodeOption != null) {
                            PsiElement psiElement = errorCodeOption.getParent();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"errorCodeOption.parent");
                            this.reportError(psiElement, "RAISE error code is already specified");
                        }
                    }
                }
            }
            {
                this.$manager = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
                this.$dbms = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }
}

