/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAddNotNullColumnInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlAddNotNullColumnInspection.$$$reportNull$$$0(2);
        }
        if (dialect.getDbms() == Dbms.UNKNOWN) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlAlterStatement(SqlAlterStatement o) {
                SqlReferenceExpression target = o.getAlterTargetReference();
                if (target == null || target.getReferenceElementType().getTargetKind() != ObjectKind.TABLE) {
                    return;
                }
                for (SqlAlterInstruction instruction2 : o.getAlterInstructions()) {
                    IElementType type = instruction2.getInstructionType();
                    if (type != SqlCommonKeywords.SQL_ADD) {
                        return;
                    }
                    for (PsiElement e = instruction2.getFirstChild(); e != null; e = e.getNextSibling()) {
                        boolean notNullAlone;
                        if (!(e instanceof SqlColumnDefinition)) continue;
                        ASTNode nullConstraint = e.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION);
                        ASTNode notNullConstraint = e.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION);
                        ASTNode defaultConstraint = e.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION);
                        SqlTableKeyDefinition pkDefinition = ((SqlColumnDefinition)e).getPrimaryKey();
                        Dbms dbms = this.myDialect.getDbms();
                        boolean pkExists = pkDefinition != null;
                        boolean autoInc = SqlImplUtil.isAutoVal((SqlColumnDefinition)e);
                        if (autoInc) continue;
                        boolean notNullWithoutDefault = notNullConstraint != null && defaultConstraint == null && !dbms.isMysql() && !dbms.isDb2() && (!dbms.isMicrosoft() || ((SqlColumnDefinition)e).getSqlType().getCategory() != SqlType.Category.TIMESTAMP);
                        boolean bl = notNullAlone = notNullConstraint != null && defaultConstraint == null && nullConstraint == null && dbms.isDb2();
                        if (!notNullWithoutDefault && !notNullAlone && !pkExists) continue;
                        this.addDescriptor(this.myManager.createProblemDescriptor(e, "The column can not be added because it's mandatory (not null) but unknown how to fill it for the existing rows.", (LocalQuickFix)(!pkExists && onTheFly ? new AddDefaultFix((SqlColumnDefinition)e, this.myDialect) : null), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddDefaultFix
    extends SqlEditorAwareFix<SqlColumnDefinition> {
        private final SqlLanguageDialect myLanguage;

        AddDefaultFix(SqlColumnDefinition element2, SqlLanguageDialect language) {
            super(element2);
            this.myLanguage = language;
        }

        @Override
        @NotNull
        public String getText() {
            return "Add default value";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlColumnDefinition element2, @Nullable Editor editor) {
            if (project == null) {
                AddDefaultFix.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                AddDefaultFix.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                return;
            }
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "");
            template.addTextSegment(" default ");
            template.addVariable("value", (Expression)new ConstantNode(""), true);
            template.setToReformat(true);
            Dbms dbms = this.myLanguage.getDbms();
            if (dbms.isHsqldb() || dbms.isSybase() || dbms.isOracle()) {
                ASTNode notNullConstraint = element2.getNode().findChildByType((IElementType)SqlCompositeElementTypes.SQL_NOT_NULL_CONSTRAINT_DEFINITION);
                if (notNullConstraint == null) return;
                editor.getCaretModel().moveToOffset(notNullConstraint.getTextRange().getStartOffset());
                template.addTextSegment(" ");
            } else {
                editor.getCaretModel().moveToOffset(element2.getTextRange().getEndOffset());
            }
            templateManager.startTemplate(editor, template);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/inspections/SqlAddNotNullColumnInspection$AddDefaultFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

