/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/inspections/RenamePsiFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "intellij.database.sql.impl"})
public final class RenamePsiFix
implements LocalQuickFix {
    public static final RenamePsiFix INSTANCE;

    @NotNull
    public String getFamilyName() {
        return "Rename element";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getStartElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"descriptor.startElement");
        this.applyFix(psiElement);
    }

    public final void applyFix(@NotNull PsiElement element2) {
        block2: {
            PsiFile file;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            PsiFile psiFile = file = element2.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            Project project = psiFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            Project project2 = project;
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
            if (document == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"PsiDocumentManager.getIn\u2026tDocument(file) ?: return");
            Document doc2 = document;
            Object[] objectArray = EditorFactory.getInstance().getEditors(doc2);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"EditorFactory.getInstance().getEditors(doc)");
            Editor editor = (Editor)ArraysKt.firstOrNull((Object[])objectArray);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            editor2.getCaretModel().moveToOffset(element2.getTextOffset());
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"DataManager.getInstance(\u2026Context(editor.component)");
            DataContext dataContext2 = dataContext;
            RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(dataContext2);
            if (renameHandler == null) break block2;
            renameHandler.invoke(project2, editor2, file, dataContext2);
        }
    }

    private RenamePsiFix() {
    }

    static {
        RenamePsiFix renamePsiFix;
        INSTANCE = renamePsiFix = new RenamePsiFix();
    }
}

