/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsDefault;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/formatter/settings/SqlPredefinedCodeStyle;", "Lcom/intellij/psi/codeStyle/PredefinedCodeStyle;", "name", "", "(Ljava/lang/String;)V", "apply", "", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "language", "Lcom/intellij/lang/Language;", "getDefaultStyle", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettingsDefault;", "isApplicableToLanguage", "", "setup", "sql", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "intellij.database.sql.impl"})
public abstract class SqlPredefinedCodeStyle
extends PredefinedCodeStyle {
    @Nullable
    protected SqlCodeStyleSettingsDefault getDefaultStyle() {
        return null;
    }

    public boolean isApplicableToLanguage(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)SqlLanguage.INSTANCE) || language instanceof SqlLanguageDialect;
    }

    public void apply(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((CodeStyleSettings)settings, (Language)language);
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCodeStyleSettings, (String)"SqlCodeStyles.getSqlSettings(settings, language)");
        SqlCodeStyleSettings sql = sqlCodeStyleSettings;
        SqlCodeStyleSettingsDefault ds = this.getDefaultStyle();
        if (ds != null) {
            sql.assignDefaults(ds);
        }
        this.setup(sql);
    }

    protected void setup(@NotNull SqlCodeStyleSettings sql) {
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
    }

    public SqlPredefinedCodeStyle(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(name, (Language)SqlLanguage.INSTANCE);
    }
}

