/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0000\"\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0005*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\"\u0018\u0010\b\u001a\u00020\u0005*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0019"}, d2={"SQL_SETTING_FIELDS", "", "Ljava/lang/reflect/Field;", "[Ljava/lang/reflect/Field;", "isDeprecated", "", "(Ljava/lang/reflect/Field;)Z", "isPublic", "isStatic", "copyCodeStyleSettings", "", "source", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "target", "createSqlFileForCodeStyleSettingsPreview", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "settingsActuallyDifferent", "settings1", "settings2", "intellij.database.sql.impl"})
@JvmName(name="SqlCodeStyleSettingsUtil")
public final class SqlCodeStyleSettingsUtil {
    @JvmField
    @NotNull
    public static final Field[] SQL_SETTING_FIELDS;

    @NotNull
    public static final PsiFile createSqlFileForCodeStyleSettingsPreview(@NotNull Project project, @NotNull String text2, @NotNull SqlLanguageDialect dialect) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)dialect, (String)"dialect");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("preview\u22c8style.sql", (Language)dialect, (CharSequence)text2, false, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiFileFactory.getInstan\u2026lect, text, false, false)");
        return psiFile;
    }

    public static final boolean settingsActuallyDifferent(@NotNull SqlCodeStyleSettings settings1, @NotNull SqlCodeStyleSettings settings2) {
        Intrinsics.checkParameterIsNotNull((Object)settings1, (String)"settings1");
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings2");
        if (settings1 == settings2) {
            return false;
        }
        for (Field f : SQL_SETTING_FIELDS) {
            if (!(Intrinsics.areEqual((Object)f.get(settings1), (Object)f.get(settings2)) ^ true)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void copyCodeStyleSettings(@NotNull SqlCodeStyleSettings source, @NotNull SqlCodeStyleSettings target) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (source == target) {
            return;
        }
        CommonCodeStyleSettings commonCodeStyleSettings = source.getCorrespondedCommonSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"source.correspondedCommonSettings");
        CommonCodeStyleSettings sourceCommon = commonCodeStyleSettings;
        CommonCodeStyleSettings commonCodeStyleSettings2 = target.getCorrespondedCommonSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings2, (String)"target.correspondedCommonSettings");
        CommonCodeStyleSettings targetCommon = commonCodeStyleSettings2;
        if (sourceCommon != targetCommon) {
            targetCommon.copyFrom(sourceCommon);
        }
        Field[] $this$filter$iv = SQL_SETTING_FIELDS;
        boolean $i$f$filter = false;
        Field[] fieldArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var10_9 = $this$filterTo$iv$iv;
        int n = ((void)var10_9).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it2 = element$iv$iv = var10_9[j];
            boolean bl = false;
            if (!(!target.isSettingHidden(it2.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Field[] fieldsToCopy = (Field[])UtilKt.toArray((Collection)((List)destination$iv$iv), (Object[])new Field[0]);
        ReflectionUtil.copyFields((Field[])fieldsToCopy, (Object)source, (Object)target);
        target.myVersion = source.myVersion;
    }

    private static final boolean isPublic(@NotNull Field $this$isPublic) {
        return Modifier.isPublic($this$isPublic.getModifiers());
    }

    private static final boolean isStatic(@NotNull Field $this$isStatic) {
        return Modifier.isStatic($this$isStatic.getModifiers());
    }

    private static final boolean isDeprecated(@NotNull Field $this$isDeprecated) {
        return $this$isDeprecated.isAnnotationPresent(Deprecated.class);
    }

    /*
     * Unable to fully structure code
     */
    static {
        v0 = SqlCodeStyleSettings.class.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"SqlCodeStyleSettings::cl\u2026.java\n    .declaredFields");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var2_2 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var5_5 = $this$filterTo$iv$iv;
        var6_6 = ((void)var5_5).length;
        for (var7_7 = 0; var7_7 < var6_6; ++var7_7) {
            it = element$iv$iv = var5_5[var7_7];
            $i$a$-filter-SqlCodeStyleSettingsUtil$SQL_SETTING_FIELDS$1 = false;
            v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!SqlCodeStyleSettingsUtil.isPublic((Field)v1)) ** GOTO lbl-1000
            var11_11 = it.getName().charAt(0);
            var12_12 = false;
            if (Character.isUpperCase(var11_11) && !SqlCodeStyleSettingsUtil.isStatic((Field)it) && !SqlCodeStyleSettingsUtil.isDeprecated((Field)it)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        SqlCodeStyleSettingsUtil.SQL_SETTING_FIELDS = (Field[])UtilKt.toArray((Collection)((List)var3_3), (Object[])new Field[0]);
    }
}

