/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.util.SqlDialects;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.SqlPreFormatter;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        SqlPreFormatter preFormatter;
        if (node == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(1);
        }
        if ((preFormatter = SqlPreFormatProcessor.preparePreFormatter(node)) != null) {
            TextRange textRange = preFormatter.process(range);
            if (textRange == null) {
                SqlPreFormatProcessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    private static SqlPreFormatter preparePreFormatter(@NotNull ASTNode node) {
        Document document;
        PsiElement psiElement;
        PsiFile file;
        if (node == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(4);
        }
        PsiFile psiFile = file = (psiElement = node.getPsi()) == null || !psiElement.isValid() ? null : psiElement.getContainingFile();
        if (!(file instanceof SqlFile)) {
            return null;
        }
        if (SqlPreFormatProcessor.fileIsFrankensteinInjection(file)) {
            return null;
        }
        if (file.getTextLength() < 1024 && SqlImplUtil.sqlTraverser((PsiElement)file).filter(SqlStatement.class).isEmpty()) {
            return null;
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        if (language == SqlDialects.getGenericDialect() || SqlCodeStyles.getSqlSettings((PsiFile)file).DISABLE_FORMATTING) {
            return null;
        }
        Project project = psiElement.getProject();
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((PsiFile)file);
        Document hardRef = (Document)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY);
        Object object = hardRef != null ? hardRef : (document = ApplicationManager.getApplication().isReadAccessAllowed() ? file.getViewProvider().getDocument() : null);
        if (document == null) {
            return null;
        }
        return new SqlPreFormatter(project, document, psiElement, language.getDbms(), settings);
    }

    private static boolean fileIsFrankensteinInjection(@NotNull PsiFile file) {
        Boolean frankenstein;
        if (file == null) {
            SqlPreFormatProcessor.$$$reportNull$$$0(5);
        }
        return (frankenstein = (Boolean)file.getUserData(InjectedLanguageManager.FRANKENSTEIN_INJECTION)) != null && frankenstein != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/SqlPreFormatProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preparePreFormatter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileIsFrankensteinInjection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

