/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.util.SqlDialects;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.editor.SqlColors;
import com.intellij.sql.editor.SqlSyntaxHighlighter;
import gnu.trove.THashMap;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SqlColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor("External command", SqlColors.SQL_EXTERNAL_TOOL), new AttributesDescriptor("Comment", SqlColors.SQL_COMMENT), new AttributesDescriptor("Database object", SqlColors.SQL_DATABASE_OBJECT), new AttributesDescriptor("Schema", SqlColors.SQL_SCHEMA), new AttributesDescriptor("Table", SqlColors.SQL_TABLE), new AttributesDescriptor("Column", SqlColors.SQL_COLUMN), new AttributesDescriptor("Outer query column", SqlColors.SQL_OUTER_QUERY_COLUMN), new AttributesDescriptor("Type", SqlColors.SQL_TYPE), new AttributesDescriptor("Procedure or function", SqlColors.SQL_PROCEDURE), new AttributesDescriptor("Parameter", SqlColors.SQL_PARAMETER), new AttributesDescriptor("Variable", SqlColors.SQL_VARIABLE), new AttributesDescriptor("Label", SqlColors.SQL_LABEL), new AttributesDescriptor("Table or column alias", SqlColors.SQL_LOCAL_ALIAS), new AttributesDescriptor("Synthetic entity", SqlColors.SQL_SYNTHETIC_ENTITY), new AttributesDescriptor("Number token", SqlColors.SQL_NUMBER), new AttributesDescriptor("Keyword", SqlColors.SQL_KEYWORD), new AttributesDescriptor("String token", SqlColors.SQL_STRING), new AttributesDescriptor("Semicolon", SqlColors.SQL_SEMICOLON), new AttributesDescriptor("Comma", SqlColors.SQL_COMMA), new AttributesDescriptor("Dot", SqlColors.SQL_DOT), new AttributesDescriptor("Parentheses", SqlColors.SQL_PARENS), new AttributesDescriptor("Brackets", SqlColors.SQL_BRACKETS), new AttributesDescriptor("Braces", SqlColors.SQL_BRACES), new AttributesDescriptor("Bad token", SqlColors.SQL_BAD_CHARACTER)};

    @NotNull
    public String getDisplayName() {
        String string = SqlBundle.message("sql.color.page.title", new Object[0]);
        if (string == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return DatabaseIcons.Sql;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(1);
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            SqlColorSettingsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new SqlSyntaxHighlighter(SqlDialects.getGenericDialect(), null);
    }

    @NotNull
    public String getDemoText() {
        return "-- DDL section\ncreate table <schema>crm</schema>.<table>product</table> (\n  <column>id</column> numeric primary key,\n  <column>title</column> varchar(255) character set <obj>utf8</obj>\n);\n-- DML section\ninsert into <table>product</table>\n  values (1, 'Product1');\n\nselect <proc>count</proc>(*) from <schema>crm</schema>.<table>product</table>;\nselect <column>id</column> as <alias>ProductID</alias>, <column>title</column> as <alias>ProductName</alias>\n  from <schema>crm</schema>.<table>product</table> where <column>id</column> = :<parameter>id</parameter>;\n\n<tool>\\set content `cat data.txt`</tool>\n";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        THashMap map2 = new THashMap();
        map2.put("obj", SqlColors.SQL_DATABASE_OBJECT);
        map2.put("schema", SqlColors.SQL_SCHEMA);
        map2.put("table", SqlColors.SQL_TABLE);
        map2.put("column", SqlColors.SQL_COLUMN);
        map2.put("outerColumn", SqlColors.SQL_OUTER_QUERY_COLUMN);
        map2.put("alias", SqlColors.SQL_LOCAL_ALIAS);
        map2.put("parameter", SqlColors.SQL_PARAMETER);
        map2.put("proc", SqlColors.SQL_PROCEDURE);
        map2.put("tool", SqlColors.SQL_EXTERNAL_TOOL);
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/editor/SqlColorSettingsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

