/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileActions;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeDialectAction
extends ScratchFileActions.LanguageAction {
    @NotNull
    protected String getLanguageTerm() {
        return "Dialect";
    }

    @NotNull
    protected Condition<VirtualFile> fileFilter(Project project) {
        return ChangeDialectAction.FILE_FILTER(project);
    }

    @NotNull
    public static Condition<VirtualFile> FILE_FILTER(final Project project) {
        return new Condition<VirtualFile>(){
            final PsiManager psiManager;
            {
                this.psiManager = PsiManager.getInstance((Project)project);
            }

            public boolean value(VirtualFile file) {
                if (ScratchRootType.getInstance().containsFile(file)) {
                    return false;
                }
                if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE)) {
                    return true;
                }
                if (JdbcConsoleProvider.getValidConsole(project, file) != null) {
                    return true;
                }
                return this.psiManager.findFile(file) instanceof SqlFile && file.isInLocalFileSystem();
            }
        };
    }

    @NotNull
    protected Function<VirtualFile, Language> fileLanguage(@NotNull Project project) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(0);
        }
        Function function2 = virtualFile -> SqlLanguageSubstitutor.getSqlLanguageDialect(virtualFile, project);
        if (function2 == null) {
            ChangeDialectAction.$$$reportNull$$$0(1);
        }
        return function2;
    }

    protected void actionPerformedImpl(@NotNull AnActionEvent e, @NotNull Project project, @NotNull String title, @NotNull JBIterable<? extends VirtualFile> files) {
        if (e == null) {
            ChangeDialectAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(3);
        }
        if (title == null) {
            ChangeDialectAction.$$$reportNull$$$0(4);
        }
        if (files == null) {
            ChangeDialectAction.$$$reportNull$$$0(5);
        }
        ListPopup popup = ChangeDialectAction.buildDialectsPopup(project, files, this.getTemplatePresentation().getTextWithMnemonic());
        DbUIUtil.showPopup((JBPopup)popup, null, e);
    }

    @NotNull
    public static ListPopup buildDialectsPopup(@NotNull Project project, @NotNull JBIterable<? extends VirtualFile> files) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            ChangeDialectAction.$$$reportNull$$$0(7);
        }
        return ChangeDialectAction.buildDialectsPopup(project, files, "SQL Dialect");
    }

    @NotNull
    public static ListPopup buildDialectsPopup(@NotNull Project project, @NotNull JBIterable<? extends VirtualFile> files, @NotNull String title) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(8);
        }
        if (files == null) {
            ChangeDialectAction.$$$reportNull$$$0(9);
        }
        if (title == null) {
            ChangeDialectAction.$$$reportNull$$$0(10);
        }
        LRUPopupBuilder builder = LRUPopupBuilder.languagePopupBuilder((Project)project, (String)title);
        for (SqlLanguageDialect dialect : SqlDialects.getTopLevelSqlDialects()) {
            builder.withExtra((Object)dialect, dialect.getDisplayName(), dialect.getIcon());
        }
        builder.onChosen(language -> ChangeDialectAction.setDialectImpl(project, files, language));
        if (files.find(ScratchUtil::isScratch) == null) {
            builder.withExtra((Object)Language.ANY, "SQL Dialects...", null);
        }
        ListPopup listPopup = builder.buildPopup();
        if (listPopup == null) {
            ChangeDialectAction.$$$reportNull$$$0(11);
        }
        return listPopup;
    }

    public static void setDialectImpl(@NotNull Project project, @NotNull JBIterable<? extends VirtualFile> files, @Nullable Language language) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(12);
        }
        if (files == null) {
            ChangeDialectAction.$$$reportNull$$$0(13);
        }
        if (language == null || language == Language.ANY) {
            SqlDialectImplUtil.LOG.assertTrue(files.find(file -> ScratchUtil.isScratch((VirtualFile)file)) == null);
            SqlDialectsConfigurable.openDialectsConfigurable(project, (VirtualFile)files.first());
            return;
        }
        for (VirtualFile file2 : files) {
            ChangeDialectAction.setDialectImpl0(project, file2, language, false);
        }
        FileContentUtilCore.reparseFiles((Collection)files.toList());
    }

    public static void setDialectImpl(@NotNull Project project, @NotNull VirtualFile file, @NotNull Language language, boolean fromInjection) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ChangeDialectAction.$$$reportNull$$$0(15);
        }
        if (language == null) {
            ChangeDialectAction.$$$reportNull$$$0(16);
        }
        SqlDialectImplUtil.LOG.assertTrue(language != Language.ANY);
        ChangeDialectAction.setDialectImpl0(project, file, language, fromInjection);
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
    }

    private static void setDialectImpl0(@NotNull Project project, @NotNull VirtualFile file, @NotNull Language language, boolean fromInjection) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(17);
        }
        if (file == null) {
            ChangeDialectAction.$$$reportNull$$$0(18);
        }
        if (language == null) {
            ChangeDialectAction.$$$reportNull$$$0(19);
        }
        ScratchRootType scratchRootType = ScratchRootType.getInstance();
        if (!fromInjection && scratchRootType.containsFile(file)) {
            ScratchFileService.getInstance().getScratchesMapping().setMapping(file, (Object)language);
        } else {
            LocalDataSource dataSource2;
            if (file instanceof DatabaseElementVirtualFileImpl) {
                dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DatabaseElementVirtualFileImpl)file).findDataSource(project));
            } else {
                JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
                LocalDataSource localDataSource = dataSource2 = console == null ? null : (LocalDataSource)console.getTarget();
            }
            if (dataSource2 != null) {
                ChangeDialectAction.askAndSetDriverSqlDialect(project, dataSource2.getDatabaseDriver(), language);
            } else if (file.isInLocalFileSystem()) {
                SqlDialectMappings.getInstance(project).setMapping(file, (SqlLanguageDialect)language);
            } else if (file instanceof LightVirtualFile) {
                ((LightVirtualFile)file).setLanguage(language);
            }
        }
    }

    private static void askAndSetDriverSqlDialect(@NotNull Project project, @Nullable DatabaseDriver driver, @NotNull Language language) {
        if (project == null) {
            ChangeDialectAction.$$$reportNull$$$0(20);
        }
        if (language == null) {
            ChangeDialectAction.$$$reportNull$$$0(21);
        }
        if (driver == null) {
            return;
        }
        int answer = Messages.showYesNoDialog((Project)project, (String)("The change of the default dialect will influence all consoles and data sources\nthat use the " + driver.getName() + " driver. Continue?"), (String)"Change Dialect", (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        ((DatabaseDriverImpl)driver).setSqlDialect(language.getID());
        DataSourceStorage storage = DataSourceStorage.getProjectStorage(project);
        for (LocalDataSource ds : storage.getDataSources()) {
            if (ds.getDatabaseDriver() != driver) continue;
            storage.updateDataSource(ds);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/ChangeDialectAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/ChangeDialectAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDialectsPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fileLanguage";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDialectsPopup";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDialectImpl";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setDialectImpl0";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "askAndSetDriverSqlDialect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

