/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.SqlModelBuilderUtils;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.database.SqlTxModelWrapper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.impl.SqlCommentClauseImpl;
import com.intellij.sql.psi.impl.SqlCommentStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilder {
    private final Project myProject;
    private final BasicModModel myModel;
    private final SqlObjectBuilder myObjectBuilder;
    private final Map<DasObject, BasicElement> mySources;
    private Map<BasicElement, SmartPsiElementPointer<SqlElement>> myMapping;
    private SqlTxModelWrapper myStagingModel;
    private SqlFileProcessor myProcessor;
    private boolean myApplied;

    public SqlModelBuilder(@NotNull Project project, @NotNull SqlObjectBuilder objectBuilder, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(0);
        }
        if (objectBuilder == null) {
            SqlModelBuilder.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(2);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(3);
        }
        this.mySources = new HashMap<DasObject, BasicElement>();
        this.myApplied = false;
        this.myProject = project;
        this.myModel = model;
        this.myMapping = mapping;
        this.myObjectBuilder = objectBuilder;
    }

    public SqlModelBuilder(@NotNull Project project, @NotNull BasicModModel model, @NotNull Map<BasicElement, SmartPsiElementPointer<SqlElement>> mapping) {
        if (project == null) {
            SqlModelBuilder.$$$reportNull$$$0(4);
        }
        if (model == null) {
            SqlModelBuilder.$$$reportNull$$$0(5);
        }
        if (mapping == null) {
            SqlModelBuilder.$$$reportNull$$$0(6);
        }
        this(project, (SqlObjectBuilder)SqlObjectBuilder.EP.forDbms(model.getDbms()), model, mapping);
    }

    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myModel;
        if (basicModModel == null) {
            SqlModelBuilder.$$$reportNull$$$0(7);
        }
        return basicModModel;
    }

    public void begin(boolean saveSources) {
        this.myStagingModel = new SqlTxModelWrapper(this.myModel, this.mySources, saveSources);
        this.myProcessor = new SqlFileProcessor(this.myProject, this.myStagingModel, this.myObjectBuilder);
        this.myApplied = false;
    }

    public int introspect(@NotNull List<SqlFile> files, int start2, boolean clear2, long syncTimeout) {
        if (files == null) {
            SqlModelBuilder.$$$reportNull$$$0(8);
        }
        if (this.mySources.isEmpty() && !this.myMapping.isEmpty()) {
            for (Map.Entry<BasicElement, SmartPsiElementPointer<SqlElement>> entry : this.myMapping.entrySet()) {
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)entry.getValue().getElement(), DasObject.class);
                if (object == null) continue;
                this.mySources.put(object, entry.getKey());
            }
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        long time = System.currentTimeMillis();
        for (int i2 = start2; i2 < files.size(); ++i2) {
            SqlFile file = files.get(i2);
            if (indicator != null) {
                indicator.setFraction(((double)i2 + 0.0) / (double)files.size());
                indicator.setText2(file.getName());
            }
            this.myStagingModel.modify(() -> this.myProcessor.process(file));
            long cur = System.currentTimeMillis();
            if ((syncTimeout == -1L || cur - time <= syncTimeout) && i2 + 1 != files.size()) continue;
            this.myMapping = this.apply(this.myProcessor, clear2);
            this.myApplied = true;
            return i2 + 1;
        }
        return files.size();
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> getMapping() {
        Map<BasicElement, SmartPsiElementPointer<SqlElement>> map2 = this.myMapping;
        if (map2 == null) {
            SqlModelBuilder.$$$reportNull$$$0(9);
        }
        return map2;
    }

    public void end() {
        if (this.myApplied) {
            this.myModel.modify(BasicModRoot.class, r -> this.finish());
        }
        this.myStagingModel = null;
        this.myProcessor = null;
        this.myApplied = false;
        this.mySources.clear();
    }

    @NotNull
    public Map<BasicElement, SmartPsiElementPointer<SqlElement>> apply(SqlFileProcessor processor, boolean clear2) {
        final Map<BasicElement, SmartPsiElementPointer<SqlElement>> tmp = processor.reverseMap();
        this.myModel.modify(BasicModRoot.class, r -> {
            if (clear2) {
                this.prepare();
            }
            processor.apply();
        });
        final HashMap<BasicElement, SmartPsiElementPointer<SqlElement>> result = new HashMap<BasicElement, SmartPsiElementPointer<SqlElement>>(this.myMapping);
        new SqlTxModelWrapper.TwoModelVisitor(){

            @Override
            public void visit(@NotNull BasicElement guide, @NotNull BasicElement guided) {
                if (guide == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (guided == null) {
                    1.$$$reportNull$$$0(1);
                }
                ContainerUtil.putIfNotNull((Object)guide, tmp.get(guided), (Map)result);
                super.visit(guide, guided);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guide";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "guided";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/database/SqlModelBuilder$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visit(this.myModel.getRoot(), processor.getRoot());
        HashMap<BasicElement, SmartPsiElementPointer<SqlElement>> hashMap = result;
        if (hashMap == null) {
            SqlModelBuilder.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    public void prepare() {
        for (BasicModElement element2 : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily modFamily : element2.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void finish() {
        for (BasicModElement element2 : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            for (ModFamily modFamily : element2.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
        this.finalizeObjects();
    }

    public void finalizeObjects() {
        for (BasicModElement element2 : ((JBTreeTraverser)this.myModel.traverser().withRoot((Object)this.myModel.getRoot())).preOrderDfsTraversal().filter(BasicModElement.class)) {
            this.myObjectBuilder.finalize((DasObject)element2);
        }
    }

    public static boolean isIgnored(Dbms dbms, ObjectKind p2, ObjectKind c2) {
        if (c2 == SqlDbElementType.ANY) {
            return true;
        }
        if (p2 == ObjectKind.SCHEMA && c2 == ObjectKind.ROLE) {
            return true;
        }
        if (dbms.isOracle()) {
            if (p2 == ObjectKind.BODY) {
                return true;
            }
            if (p2 == ObjectKind.SCHEMA) {
                return c2 == ObjectKind.OPERATOR || c2 == ObjectKind.EXCEPTION || "library".equals(c2.name()) || "INDEX TYPE".equals(c2.name());
            }
        }
        if (p2 == ObjectKind.OBJECT_TYPE) {
            return c2 == SqlDbElementType.CONSTRAINT;
        }
        return false;
    }

    protected void buildObject(@NotNull BasicModElement target, @NotNull DasObject obj) {
        if (target == null) {
            SqlModelBuilder.$$$reportNull$$$0(11);
        }
        if (obj == null) {
            SqlModelBuilder.$$$reportNull$$$0(12);
        }
        if (obj instanceof BasicElement) {
            BasicMetaUtils.copyMatchedProperties((BasicElement)obj, target, false, true);
        } else {
            this.myObjectBuilder.build((DasObject)target, obj, this.myStagingModel.withSources() ? SqlObjectBuilder.Context.MODEL : SqlObjectBuilder.Context.MODEL_WITHOUT_SOURCE);
        }
    }

    private static DasObject unwrapFake(DasObject obj) {
        SqlDefinition delegate;
        if (obj instanceof SqlFileImpl.FakeDefinition && (delegate = (SqlDefinition)((SqlFileImpl.FakeDefinition)obj).delegates().first()) != null) {
            return delegate;
        }
        if (obj instanceof DbElement) {
            return (DasObject)((DbElement)obj).getDelegate();
        }
        return obj;
    }

    private static boolean isAppendable(BasicModElement target) {
        return target instanceof DasNamespace || target.getKind() == ObjectKind.PACKAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectBuilder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introspect";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SqlFileProcessor {
        private final Project myProject;
        private final Map<ObjectPath, BasicModElement> myObjects;
        private final Map<DasObject, BasicModElement> myProcessed;
        private final Set<DasObject> myDelayed;
        private final SqlTxModelWrapper myModel;
        private SqlLanguageDialectEx myLanguage;
        private final SqlObjectBuilder myObjectBuilder;
        private final Dbms myDbms;
        private final Map<DasObject, PsiElement> myOraPackageRestarter;

        SqlFileProcessor(@NotNull Project project, @NotNull SqlTxModelWrapper model, SqlObjectBuilder objectBuilder) {
            if (project == null) {
                SqlFileProcessor.$$$reportNull$$$0(0);
            }
            if (model == null) {
                SqlFileProcessor.$$$reportNull$$$0(1);
            }
            if (objectBuilder == null) {
                SqlFileProcessor.$$$reportNull$$$0(2);
            }
            this.myObjects = new HashMap<ObjectPath, BasicModElement>();
            this.myProcessed = new LinkedHashMap<DasObject, BasicModElement>();
            this.myDelayed = new LinkedHashSet<DasObject>();
            this.myOraPackageRestarter = new HashMap<DasObject, PsiElement>();
            this.myProject = project;
            this.myModel = model;
            this.myObjectBuilder = objectBuilder;
            this.myDbms = this.myModel.getDbms();
        }

        public void processDelayed() {
            while (!this.myDelayed.isEmpty()) {
                Iterator<DasObject> it2 = this.myDelayed.iterator();
                DasObject d2 = it2.next();
                it2.remove();
                d2.getDasChildren(null).forEach(o -> this.process((DasObject)o));
            }
        }

        public void process(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(3);
            }
            this.myLanguage = (SqlLanguageDialectEx)file.getSqlLanguage();
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            for (DasObject obj : file.traverser().preOrderDfsTraversal()) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                this.process(obj);
            }
            for (SqlAlterStatement stmt : this.getAlterStatements(file)) {
                if (stmt instanceof SqlCommentStatementImpl) {
                    SqlCommentStatementImpl commentStatement = (SqlCommentStatementImpl)stmt;
                    IStubElementType type = commentStatement.getElementType();
                    if (type != SqlCompositeElementTypes.SQL_COMMENT_STATEMENT) continue;
                    this.processCommentStmt(commentStatement);
                    continue;
                }
                SqlReferenceExpression reference = stmt.getAlterTargetReference();
                DasObject resolved = reference == null ? null : (DasObject)ObjectUtils.tryCast((Object)reference.resolve(), DasObject.class);
                BasicModElement element2 = resolved == null ? null : this.process(resolved);
                if (element2 == null) continue;
                this.myObjectBuilder.build((DasObject)element2, (SqlElement)stmt);
            }
            this.processDelayed();
        }

        @NotNull
        protected JBIterable<SqlAlterStatement> getAlterStatements(@NotNull SqlFile file) {
            if (file == null) {
                SqlFileProcessor.$$$reportNull$$$0(4);
            }
            if (((SqlFileImpl)file).getStub() != null) {
                JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)file).filter(SqlAlterStatement.class);
                if (jBIterable == null) {
                    SqlFileProcessor.$$$reportNull$$$0(5);
                }
                return jBIterable;
            }
            JBIterable jBIterable = SqlImplUtil.sqlCompositeElements((PsiElement)file).filter(SqlAlterStatement.class);
            if (jBIterable == null) {
                SqlFileProcessor.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        private void processCommentStmt(@NotNull SqlCommentStatementImpl stmt) {
            if (stmt == null) {
                SqlFileProcessor.$$$reportNull$$$0(7);
            }
            SqlReferenceExpression tgt = stmt.getAlterTargetReference();
            for (SqlCommentClauseImpl clause : SqlImplUtil.childrenIt((PsiElement)stmt).filter(SqlCommentClauseImpl.class)) {
                BasicModNamedElement processed;
                SqlReferenceExpression ref = null;
                if (ref == null) {
                    ref = tgt;
                }
                if (ref == null) continue;
                DasObject target = (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasObject.class);
                BasicModNamedElement basicModNamedElement = processed = target == null ? null : (BasicModNamedElement)ObjectUtils.tryCast((Object)this.process(target), BasicModNamedElement.class);
                if (processed == null) continue;
                this.myObjectBuilder.build((DasObject)processed, (SqlElement)clause);
            }
        }

        @Nullable
        private BasicModElement process(@NotNull DasObject obj) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(8);
            }
            if (obj instanceof SqlRenameToClause || obj instanceof PsiElement && !(obj instanceof FakePsiElement) && !(obj instanceof SqlStubbedElement)) {
                return null;
            }
            obj = SqlModelBuilder.unwrapFake(obj);
            ObjectPath path = ObjectPaths.of(obj);
            if (this.myProcessed.containsKey(obj)) {
                return this.myModel.nullize(this.getProcessed(obj, path));
            }
            BasicModElement parent2 = this.getParent(obj);
            return this.processSingle(obj, path, parent2);
        }

        @Nullable
        private BasicModElement getProcessed(@NotNull DasObject obj, @NotNull ObjectPath path) {
            BasicModElement target;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(9);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(10);
            }
            if ((target = this.myProcessed.get(obj)) != null) {
                return target;
            }
            if (obj instanceof DasConstraint && obj.getName().isEmpty()) {
                return null;
            }
            target = this.myObjects.get(path);
            ContainerUtil.putIfNotNull((Object)obj, (Object)target, this.myProcessed);
            return target;
        }

        private void processSingle(@NotNull DasObject obj, @Nullable BasicModElement parent2) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(11);
            }
            this.processSingle(obj, ObjectPaths.of(SqlModelBuilder.unwrapFake(obj)), parent2);
        }

        @Nullable
        private BasicModElement processSingle(@NotNull DasObject obj, @NotNull ObjectPath path, @Nullable BasicModElement parent2) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(12);
            }
            if (path == null) {
                SqlFileProcessor.$$$reportNull$$$0(13);
            }
            ObjectKind kind = this.getKind(obj);
            if (this.myModel.getMetaModel().findKind(kind.code()) == null) {
                this.markObjectReady(path, obj, null);
                return null;
            }
            this.processOddities(obj, parent2, kind);
            BasicModElement target = this.myModel.createOrGet(obj, parent2, path, kind);
            this.markObjectReady(path, obj, target);
            if (target == null) {
                ObjectKind parentKind;
                boolean ignored = false;
                ObjectPath p2 = path;
                while (p2.parent != null && !ignored) {
                    if (SqlModelBuilder.isIgnored(this.myDbms, p2.parent.kind, p2.kind)) {
                        ignored = true;
                    }
                    p2 = p2.parent;
                }
                ObjectKind objectKind = parentKind = parent2 == null ? ObjectKind.NONE : parent2.getKind();
                if (!ignored && !SqlModelBuilder.isIgnored(this.myDbms, parentKind, obj.getKind())) {
                    boolean ignore;
                    SqlLanguageDialect lang = DbSqlUtil.getSqlDialect((PsiElement)ObjectUtils.tryCast((Object)obj, PsiElement.class));
                    boolean bl = ignore = lang != null && lang.getDbms() != this.myModel.getDbms() || parent2 == null && obj.getDasParent() instanceof SqlRenameToClause;
                    if (!ignore) {
                        SqlModelBuilderUtils.hardWarning("No family " + kind.code() + " in " + parentKind.code());
                    }
                }
            } else {
                if (!SqlModelBuilder.isAppendable(target)) {
                    target.getFamilies().forEach(ModFamily::markChildrenAsSyncPending);
                }
                this.processRequiredChildren(obj, target);
                SqlModelBuilder.this.buildObject(target, obj);
            }
            return target;
        }

        @NotNull
        private ObjectKind getKind(@NotNull DasObject obj) {
            DasObject p2;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(14);
            }
            if (this.myLanguage.getDbms().isOracle() && obj.getKind() == ObjectKind.OBJECT_TYPE && (p2 = obj.getDasParent()) != null && p2.getKind() == ObjectKind.PACKAGE) {
                ObjectKind objectKind = ObjectKind.ALIAS_TYPE;
                if (objectKind == null) {
                    SqlFileProcessor.$$$reportNull$$$0(15);
                }
                return objectKind;
            }
            ObjectKind objectKind = this.myLanguage.unaliased(obj.getKind());
            if (objectKind == null) {
                SqlFileProcessor.$$$reportNull$$$0(16);
            }
            return objectKind;
        }

        private void processRequiredChildren(@NotNull DasObject obj, @NotNull BasicModElement target) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(17);
            }
            if (target == null) {
                SqlFileProcessor.$$$reportNull$$$0(18);
            }
            if (target instanceof BasicTable) {
                for (DasObject column : obj.getDasChildren(ObjectKind.COLUMN)) {
                    this.processSingle(column, target);
                }
            }
            if (target instanceof BasicModRoutine) {
                for (DasObject argument : obj.getDasChildren(ObjectKind.ARGUMENT)) {
                    this.processSingle(argument, target);
                }
            }
        }

        private void markObjectReady(ObjectPath path, @NotNull DasObject obj, @Nullable BasicModElement target) {
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(19);
            }
            BasicModElement nnTarget = this.myModel.notNullize(target);
            this.myObjects.put(path, nnTarget);
            this.myProcessed.put(obj, nnTarget);
        }

        private void processOddities(@NotNull DasObject obj, @Nullable BasicModElement parent2, @NotNull ObjectKind kind) {
            PsiElement element2;
            PsiObject pkg;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(20);
            }
            if (kind == null) {
                SqlFileProcessor.$$$reportNull$$$0(21);
            }
            if (this.myDbms.isOracle() && parent2 != null && parent2.getKind() == ObjectKind.PACKAGE && kind != ObjectKind.BODY && (pkg = (PsiObject)JBIterable.generate((Object)ObjectUtils.tryCast((Object)obj, PsiElement.class), x -> x.getContext()).filter(PsiObject.class).skip(1).first()) != null && pkg.getKind() == ObjectKind.PACKAGE && ((element2 = this.myOraPackageRestarter.get(parent2)) == null || element2 != pkg)) {
                this.myOraPackageRestarter.put(parent2, (PsiElement)pkg);
                JBIterable.from(parent2.getFamilyKinds()).filter(x -> x != ObjectKind.BODY).transform(parent2::familyOf).forEach(ModFamily::markChildrenAsSyncPending);
            }
        }

        @Nullable
        private BasicModElement getParent(@NotNull DasObject obj) {
            ObjectKind kind;
            DasObject parent2;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(22);
            }
            if ((parent2 = SqlModelBuilder.unwrapFake(obj.getDasParent())) != null && !this.isValidParent(parent2, obj)) {
                parent2 = null;
            }
            ObjectKind objectKind = kind = parent2 == null ? ObjectKind.NONE : parent2.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) {
                return this.myModel.getEmptyParent(this.getKind(obj));
            }
            ObjectPath parentPath = ObjectPaths.of(parent2);
            BasicModElement element2 = this.getProcessed(parent2, parentPath);
            if (element2 != null) {
                return this.myModel.nullize(element2);
            }
            if (!(parent2 instanceof BasicElement) && !(parent2 instanceof DasNamespace)) {
                this.myDelayed.add(parent2);
            }
            return this.process(parent2);
        }

        private boolean isValidParent(DasObject parent2, @NotNull DasObject obj) {
            ObjectKind pk;
            if (obj == null) {
                SqlFileProcessor.$$$reportNull$$$0(23);
            }
            if ((pk = this.getKind(parent2)) == ObjectKind.NONE) {
                pk = ObjectKind.ROOT;
            }
            ObjectKind ck = this.getKind(obj);
            if (pk == ObjectKind.BODY) {
                return true;
            }
            return this.myModel.getMetaModel().getChildKinds(pk).contains((Object)ck);
        }

        @NotNull
        public Map<BasicElement, SmartPsiElementPointer<SqlElement>> reverseMap() {
            LinkedHashMap<BasicElement, SmartPsiElementPointer<SqlElement>> res2 = new LinkedHashMap<BasicElement, SmartPsiElementPointer<SqlElement>>();
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            for (Map.Entry<DasObject, BasicModElement> pair : this.myProcessed.entrySet()) {
                BasicModElement target;
                SqlElement object = (SqlElement)ObjectUtils.tryCast((Object)pair.getKey(), SqlElement.class);
                if (object == null || this.myModel.nullize(target = pair.getValue()) == null) continue;
                res2.put(target, (SmartPsiElementPointer<SqlElement>)pointerManager.createSmartPsiElementPointer((PsiElement)object));
            }
            LinkedHashMap<BasicElement, SmartPsiElementPointer<SqlElement>> linkedHashMap = res2;
            if (linkedHashMap == null) {
                SqlFileProcessor.$$$reportNull$$$0(24);
            }
            return linkedHashMap;
        }

        public void apply() {
            this.myModel.getDirty().forEach(arg_0 -> ((SqlObjectBuilder)this.myObjectBuilder).finalize(arg_0));
            this.myModel.apply();
        }

        @NotNull
        public BasicElement getRoot() {
            BasicModElement basicModElement = this.myModel.getRoot();
            if (basicModElement == null) {
                SqlFileProcessor.$$$reportNull$$$0(25);
            }
            return basicModElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 24: 
                case 25: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 24: 
                case 25: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectBuilder";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stmt";
                    break;
                }
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/database/SqlModelBuilder$SqlFileProcessor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlterStatements";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reverseMap";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAlterStatements";
                    break;
                }
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 24: 
                case 25: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processCommentStmt";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getProcessed";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "processSingle";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getKind";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "processRequiredChildren";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "markObjectReady";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "processOddities";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "getParent";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 15: 
                case 16: 
                case 24: 
                case 25: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

