/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionContributor;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.providers.SqlJoinSmartCompletionProvider;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlBinaryExpressionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        SqlExpression topExpression;
        if (parameters == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(2);
        }
        if (SqlJoinSmartCompletionProvider.suggestJoinStuff(parameters, result) || SqlPsiMiscUtil.isJoinUsingColumn(parameters.getPosition())) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiFile file = parameters.getOriginalFile();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        SqlReferenceExpression reference = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class);
        SqlExpression sqlExpression = topExpression = reference == null ? (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlStringLiteralExpression.class) : (SqlExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)position, SqlReferenceExpression.class);
        if (topExpression == null || topExpression instanceof SqlReferenceExpression && ((SqlReferenceExpression)topExpression).getQualifierExpression() != null) {
            return;
        }
        PsiElement parent2 = topExpression.getParent();
        if (parent2 instanceof SqlSetAssignment) {
            SqlElement lValue = ((SqlSetAssignment)parent2).getLValue();
            if (!(lValue instanceof SqlExpression)) {
                return;
            }
            SqlType expectedType = ((SqlExpression)lValue).getSqlType();
            SqlCompletionUtil.addItemsFromExpectedColumnType((Consumer<? super LookupElement>)result, (PsiElement)topExpression, expectedType, dialect);
            return;
        }
        if (!(parent2 instanceof SqlBinaryExpression)) {
            return;
        }
        SqlBinaryExpression binary = (SqlBinaryExpression)parent2;
        IElementType sign = binary.getOpSign();
        if (sign == SqlCommonKeywords.SQL_OR || sign == SqlCommonKeywords.SQL_AND) {
            return;
        }
        Object leftOperand = binary.getLOperand() == topExpression ? binary.getROperand() : (binary.getROperand() == topExpression ? binary.getLOperand() : null);
        if (leftOperand == null) {
            return;
        }
        boolean isEq = sign == SqlCommonTokens.SQL_OP_EQ || sign == SqlCommonTokens.SQL_OP_EQEQ;
        SqlExpression qualifier = reference != null ? reference.getQualifierExpression() : null;
        SqlType expectedType = leftOperand.getSqlType();
        SqlType.Category expectedCategory = expectedType.getCategory();
        PsiElement leftResolved = leftOperand instanceof SqlReferenceExpression ? ((SqlReferenceExpression)leftOperand).resolve() : null;
        DasColumn leftColumn = leftResolved instanceof DasColumn ? (DasColumn)leftResolved : null;
        ArrayList asExpressions = new ArrayList();
        if (reference != null) {
            SqlCompletionUtil.addReferenceCompletionVariants((SqlReferenceImpl)reference.getReference(), result.getPrefixMatcher(), (Consumer<LookupElement>)((Consumer)lookupElement -> {
                PsiElement object = CompletionUtil.getTargetElement((LookupElement)lookupElement);
                if (object instanceof SqlAsExpression) {
                    asExpressions.add((SqlAsExpression)object);
                    return;
                }
                if (!(object instanceof DasColumn)) {
                    return;
                }
                DasColumn columnInfo = (DasColumn)object;
                DataType dataType = columnInfo.getDataType();
                SqlType byJdbc = SqlTypeFactory.findByJdbcType(dataType.jdbcType, dialect);
                SqlType byName = SqlTypeFactory.of(dataType, dialect);
                if (!(expectedCategory.is(byJdbc) || byJdbc != byName && expectedCategory.is(byName))) {
                    return;
                }
                DasTable table = columnInfo.getTable();
                if (table == null) {
                    return;
                }
                if (parameters.getInvocationCount() <= 1 && isEq && (leftColumn == null || !SqlBinaryExpressionCompletionProvider.areColumnsConnected(position.getProject(), leftColumn, columnInfo))) {
                    return;
                }
                LookupElementDecorator<LookupElement> element2 = qualifier == null ? SqlBinaryExpressionCompletionProvider.prefix((LookupElement)lookupElement, SqlBinaryExpressionCompletionProvider.calcQualifier(table, asExpressions, SqlImplUtil.getDbms((PsiElement)file), SqlPsiMiscUtil.settings(file)) + ".") : lookupElement;
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)element2, (double)90.0));
            }), parameters, null);
        }
        SqlCompletionUtil.addItemsFromExpectedColumnType((Consumer<? super LookupElement>)result, (PsiElement)topExpression, expectedType, dialect);
    }

    private static boolean areColumnsConnected(@NotNull Project project, @NotNull DasColumn c1, @NotNull DasColumn c2) {
        String n2;
        String n1;
        DasTable t2;
        DasTable t1;
        if (project == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(3);
        }
        if (c1 == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(4);
        }
        if (c2 == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(5);
        }
        return SqlBinaryExpressionCompletionProvider.isInFk(project, t1 = c1.getTable(), t2 = c2.getTable(), n1 = c1.getName(), n2 = c2.getName()) || SqlBinaryExpressionCompletionProvider.isInFk(project, t2, t1, n2, n1);
    }

    private static boolean isInFk(@NotNull Project project, @Nullable DasTable t1, @Nullable DasTable t2, @Nullable String n1, @Nullable String n2) {
        if (project == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(6);
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        for (DasForeignKey fk : ModelRelationManager.getForeignKeys(project, t1, t2)) {
            Iterator it1 = fk.getColumnsRef().names().iterator();
            Iterator it2 = fk.getRefColumns().names().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (!Comparing.equal((String)n2, (String)((String)it2.next()), (boolean)false) || !Comparing.equal((String)n1, (String)((String)it1.next()), (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    private static LookupElementDecorator<LookupElement> prefix(LookupElement lookupElement, final String prefix) {
        return LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElement> item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                context.getDocument().insertString(context.getStartOffset(), (CharSequence)prefix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/providers/SqlBinaryExpressionCompletionProvider$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static String calcQualifier(@NotNull DasTable table, @NotNull List<SqlAsExpression> asExpressions, @NotNull Dbms dbms, @NotNull SqlCodeStyleSettings settings) {
        if (table == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(7);
        }
        if (asExpressions == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(10);
        }
        for (SqlAsExpression asExpression : asExpressions) {
            SqlExpression expression = asExpression.getExpression();
            DasTable element2 = SqlCompletionContributor.retrieveTable((PsiElement)expression);
            if (element2 == null || !SqlBinaryExpressionCompletionProvider.areTablesEqual(table, element2)) continue;
            String name = asExpression.getName();
            if (name == null) break;
            String string = name;
            if (string == null) {
                SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = NamingServices.getNamingService(dbms).nameToScript(table.getName(), !DbSqlUtil.isQuoted((DasObject)table), settings.getQuotesPriority());
        if (string == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean areTablesEqual(@NotNull DasTable t1, @NotNull DasTable t2) {
        if (t1 == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(13);
        }
        if (t2 == null) {
            SqlBinaryExpressionCompletionProvider.$$$reportNull$$$0(14);
        }
        return Comparing.equal((String)t1.getName(), (String)t2.getName(), (boolean)false) && Comparing.equal((String)DasUtil.getSchema((DasObject)t1), (String)DasUtil.getSchema((DasObject)t2), (boolean)false) && Comparing.equal((String)DasUtil.getCatalog((DasObject)t1), (String)DasUtil.getCatalog((DasObject)t2), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asExpressions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlBinaryExpressionCompletionProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlBinaryExpressionCompletionProvider";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areColumnsConnected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInFk";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcQualifier";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areTablesEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

