/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlProcedureParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<SqlExpressionList, SqlFunctionsUtil.ExpressionList, PsiElement> {
    private static final Set<Class<?>> ourStopSearch = Collections.singleton(SqlStatement.class);
    private static final Set<Class<?>> ourAllowedParents = Collections.singleton(SqlFunctionCallExpression.class);

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public SqlExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        SqlExpressionList result;
        if (context == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((result = SqlProcedureParameterInfoHandler.findExpressions((ParameterInfoContext)context)) != null) {
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)result.getParent();
            context.setItemsToShow((Object[])SqlFunctionsUtil.getOverloads(callExpression));
        }
        return result;
    }

    public void showParameterInfo(@NotNull SqlExpressionList element2, @NotNull CreateParameterInfoContext context) {
        if (element2 == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element2, element2.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public SqlExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return SqlProcedureParameterInfoHandler.findExpressions((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull SqlExpressionList element2, @NotNull UpdateParameterInfoContext context) {
        SqlFunctionCallExpression callExpression;
        SqlFunctionDefinition definition;
        if (element2 == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(5);
        }
        if ((definition = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)(callExpression = (SqlFunctionCallExpression)element2.getParent()).getFunctionDefinition(), SqlFunctionDefinition.class))) == null) {
            context.setCurrentParameter(ParameterInfoUtils.getCurrentParameterIndex((ASTNode)element2.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType()));
        } else {
            int curOffset;
            ASTNode argList = element2.getNode();
            int offset = context.getEditor().getCaretModel().getOffset();
            if (offset < (curOffset = argList.getTextRange().getStartOffset())) {
                context.setCurrentParameter(-1);
            } else {
                ASTNode[] children2 = argList.getChildren(null);
                boolean nonInfo = true;
                int index2 = 0;
                for (ASTNode child : children2) {
                    if (offset < (curOffset += child.getTextLength())) break;
                    if (SqlInfoElementType.getValue(child, SqlFunctionDefinition.Parameter.class) != null) {
                        if (nonInfo && offset != curOffset) {
                            ++index2;
                        }
                        nonInfo = false;
                        continue;
                    }
                    nonInfo = true;
                }
                context.setCurrentParameter(index2);
            }
        }
    }

    public void updateUI(SqlFunctionsUtil.ExpressionList proto, @NotNull ParameterInfoUIContext context) {
        PsiElement element2;
        if (context == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (!(element2 = context.getParameterOwner()).isValid() || !proto.isValid()) {
            return;
        }
        boolean deprecated = false;
        StringBuilder sb = new StringBuilder();
        int[] highlight = new int[]{-1, -1};
        boolean applicable = proto.buildText(sb, context.getCurrentParameterIndex(), highlight);
        if (sb.length() == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        context.setupUIComponentPresentation(sb.toString(), highlight[0], highlight[1], !applicable, false, false, context.getDefaultParameterColor());
    }

    public SqlExpression @NotNull [] getActualParameters(@NotNull SqlExpressionList o) {
        if (o == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(7);
        }
        List list = o.getExpressionList();
        SqlExpression[] sqlExpressionArray = list.toArray(new SqlExpression[0]);
        if (sqlExpressionArray == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return sqlExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
        if (sqlTokenType == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return sqlTokenType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_RIGHT_PAREN;
        if (sqlTokenType == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return sqlTokenType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = ourAllowedParents;
        if (set == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set<Class<?>> set = ourStopSearch;
        if (set == null) {
            SqlProcedureParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Class<SqlExpressionList> getArgumentListClass() {
        return SqlExpressionList.class;
    }

    @Nullable
    private static SqlExpressionList findExpressions(ParameterInfoContext context) {
        SqlExpressionList list;
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return null;
        }
        int offset = context.getOffset();
        PsiElement elementAt = file.findElementAt(offset - 1);
        while (elementAt != null && StringUtil.isEmptyOrSpaces((String)elementAt.getText())) {
            elementAt = PsiTreeUtil.prevVisibleLeaf((PsiElement)elementAt);
        }
        SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, SqlFunctionCallExpression.class);
        SqlExpressionList sqlExpressionList = list = callExpression == null ? null : callExpression.getParameterList();
        if (list == null) {
            return null;
        }
        return SqlProcedureParameterInfoHandler.getExpandedTextRange((PsiElement)list).containsOffset(offset) ? list : null;
    }

    private static TextRange getExpandedTextRange(PsiElement element2) {
        PsiElement end2 = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.nextVisibleLeaf((PsiElement)element2), (Object)PsiTreeUtil.getDeepestLast((PsiElement)element2.getContainingFile()));
        int endOffset = PsiTreeUtil.isAncestor((PsiElement)element2, (PsiElement)end2, (boolean)false) || StringUtil.isEmptyOrSpaces((String)end2.getText()) ? end2.getTextRange().getEndOffset() : end2.getTextRange().getStartOffset();
        PsiElement start2 = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.prevVisibleLeaf((PsiElement)element2), (Object)element2);
        int startOffset = start2 == element2 ? element2.getTextRange().getStartOffset() : start2.getTextRange().getEndOffset();
        return TextRange.create((int)startOffset, (int)endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlProcedureParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlProcedureParameterInfoHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

