/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class ClassInheritorsScanner
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ClassInheritorsScanner.class);
    private final Class<?> myTargetClass;
    private final Project myProject;
    private final ConcurrentLinkedQueue<ProgressIndicator> myIndicators;

    public ClassInheritorsScanner(@Nullable Project project, @NotNull Class<?> targetClass) {
        if (targetClass == null) {
            ClassInheritorsScanner.$$$reportNull$$$0(0);
        }
        this.myIndicators = new ConcurrentLinkedQueue();
        this.myTargetClass = targetClass;
        this.myProject = project;
    }

    public ActionCallback scanClasses(List<VirtualFile> files, Consumer<String> consumer2) {
        return this.scanClassesInner(false, files, consumer2);
    }

    public ActionCallback scanClassesInner(boolean sync, List<VirtualFile> files, Consumer<String> consumer2) {
        this.clearQueue();
        ProgressManager progressManager = ProgressManager.getInstance();
        final MyProcessor runnable = new MyProcessor(files, consumer2, progressManager);
        String progressTitle = DatabaseBundle.message((String)"progress.scan.for.drivers.title", (Object[])new Object[0]);
        if (sync) {
            progressManager.runProcessWithProgressSynchronously((Runnable)runnable, progressTitle, true, this.myProject);
        } else {
            progressManager.run((Task)new Task.Backgroundable(this.myProject, progressTitle, false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    runnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/util/ClassInheritorsScanner$1", "run"));
                }
            });
        }
        return runnable.myCallback;
    }

    @Nullable
    private static InputStream getResourceAsStream(String url, Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            VirtualFile child;
            Object root2 = file.isDirectory() ? file : (file.getFileType() instanceof ArchiveFileType ? JarFileSystem.getInstance().getJarRootForLocalFile(file) : null);
            if (root2 == null || (child = root2.findFileByRelativePath(url)) == null) continue;
            try {
                return child.getInputStream();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public void dispose() {
        this.clearQueue();
    }

    private void clearQueue() {
        ProgressIndicator indicator;
        while ((indicator = this.myIndicators.poll()) != null) {
            indicator.cancel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/database/util/ClassInheritorsScanner", "<init>"));
    }

    private class MyProcessor
    extends VirtualFileVisitor<Void>
    implements Runnable {
        final ProgressManager myProgressManager;
        final List<VirtualFile> myFiles;
        final TObjectIntHashMap<String> myCache;
        final Consumer<String> myConsumer;
        final StringBuilder myPackage;
        final ActionCallback myCallback;
        ProgressIndicator myIndicator;

        MyProcessor(List<VirtualFile> files, Consumer<String> consumer2, ProgressManager progressManager) {
            super(new VirtualFileVisitor.Option[0]);
            this.myCache = new TObjectIntHashMap();
            this.myPackage = new StringBuilder();
            this.myCallback = new ActionCallback();
            this.myProgressManager = progressManager;
            this.myFiles = files;
            this.myConsumer = consumer2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myIndicator = this.myProgressManager.getProgressIndicator();
                ClassInheritorsScanner.this.myIndicators.add(this.myIndicator);
                this.myIndicator.setIndeterminate(true);
                JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                for (VirtualFile root2 : this.myFiles) {
                    this.myIndicator.checkCanceled();
                    VirtualFile jarRoot = root2.isInLocalFileSystem() ? jarFileSystem.getJarRootForLocalFile(root2) : root2;
                    this.myPackage.setLength(0);
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)((VirtualFile)ObjectUtils.chooseNotNull((Object)jarRoot, (Object)root2)), (VirtualFileVisitor)this, RuntimeException.class);
                }
                this.myCallback.setDone();
            }
            finally {
                if (!this.myCallback.isDone()) {
                    this.myCallback.setRejected();
                }
            }
        }

        private InputStream getInputStream(String resource) {
            return ClassInheritorsScanner.getResourceAsStream(resource, this.myFiles);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isInheritor(final String className, final String baseClassName, final boolean isInterface) {
            boolean inheritor = false;
            int flag = this.myCache.get((Object)className);
            if (flag != 0) {
                inheritor = flag == 1;
            } else {
                String classResource = className + ".class";
                InputStream inputStream = this.getInputStream(classResource);
                if (inputStream == null) {
                    return false;
                }
                try {
                    final Ref result = new Ref((Object)Boolean.FALSE);
                    ClassReader reader = new ClassReader(inputStream);
                    reader.accept(new ClassVisitor(458752){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            return null;
                        }

                        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value2) {
                            return null;
                        }

                        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                            return null;
                        }

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            boolean isIntf;
                            if (!name.equals(className)) {
                                return;
                            }
                            boolean bl = isIntf = (access & 0x200) != 0;
                            if (isIntf && !isInterface) {
                                return;
                            }
                            if (superName != null && (isIntf == isInterface && superName.equals(baseClassName) || MyProcessor.this.isInheritor(superName, baseClassName, isInterface))) {
                                result.set((Object)Boolean.TRUE);
                                return;
                            }
                            if (isInterface) {
                                for (String anInterface : interfaces) {
                                    if (!anInterface.equals(baseClassName) && !MyProcessor.this.isInheritor(anInterface, baseClassName, isInterface)) continue;
                                    result.set((Object)Boolean.TRUE);
                                    return;
                                }
                            }
                        }
                    }, 2);
                    inheritor = (Boolean)result.get();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
                this.myCache.put((Object)className, inheritor ? 1 : -1);
            }
            return inheritor;
        }

        public void afterChildrenVisited(@NotNull VirtualFile file) {
            if (file == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (this.myPackage.length() > 0) {
                this.myPackage.setLength(Math.max(0, this.myPackage.lastIndexOf(".", this.myPackage.length() - 2) + 1));
            }
        }

        public boolean visitFile(@NotNull VirtualFile child) {
            if (child == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            this.myIndicator.checkCanceled();
            if (child.getParent() == null) {
                return true;
            }
            if (child.isDirectory()) {
                this.myIndicator.setText(DatabaseBundle.message((String)"progress.scan.for.drivers.text", (Object[])new Object[]{child.getPath()}));
                this.myIndicator.setText2("");
                String name = child.getName();
                if (!StringUtil.isJavaIdentifier((String)name)) {
                    return false;
                }
                this.myPackage.append(name).append(".");
                return true;
            }
            if ("class".equals(child.getExtension())) {
                this.myIndicator.setText2(DatabaseBundle.message((String)"progress.scan.for.drivers.text2", (Object[])new Object[]{child.getPresentableName()}));
                String className = this.myPackage + child.getNameWithoutExtension();
                if (this.isInheritor(className.replace('.', '/'), ClassInheritorsScanner.this.myTargetClass.getName().replace('.', '/'), ClassInheritorsScanner.this.myTargetClass.isInterface())) {
                    this.myIndicator.checkCanceled();
                    this.myConsumer.consume((Object)className);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/util/ClassInheritorsScanner$MyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterChildrenVisited";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

