/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseUsagesCollectors {
    private static final String MANAGERS_GROUP = "db.managers";
    private static final String CONFIG_GROUP = "db.datasource.config";

    @NotNull
    private static Set<MetricEvent> configImpl(@Nullable Project p2) {
        DataSourceStorage storage = p2 == null ? DataSourceStorage.getStorage() : DataSourceStorage.getProjectStorage(p2);
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        for (LocalDataSource o : storage.getOwnDataSources()) {
            FeatureUsageData data = new FeatureUsageData();
            data.addData("version", o.getVersion().toString());
            data.addData("read-only", o.isReadOnly());
            data.addData("auto-sync", o.isAutoSynchronize());
            data.addData("auto-commit", o.isAutoCommit());
            data.addData("ssh", o.getSshConfiguration() != null && o.getSshConfiguration().isEnabled());
            data.addData("ssl", o.getSslCfg() != null && o.getSslCfg().myEnabled);
            data.addData("legacy-introspector", o.useLegacyIntrospector());
            data.addData("schema-control", StringUtil.toLowerCase((String)o.getSchemaControl().name()));
            data.addData("introspect", StringUtil.toLowerCase((String)o.getSourceLoading().name()));
            data.addData("dbms", o.getDbms().getName());
            result.add(MetricEventFactoryKt.newMetric((String)"datasource", (FeatureUsageData)data));
        }
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            DatabaseUsagesCollectors.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/DatabaseUsagesCollectors", "configImpl"));
    }

    public static class ConfigPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            return DatabaseUsagesCollectors.CONFIG_GROUP;
        }

        public int getVersion() {
            return 4;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project p2) {
            if (p2 == null) {
                ConfigPrj.$$$reportNull$$$0(0);
            }
            Set set = DatabaseUsagesCollectors.configImpl(p2);
            if (set == null) {
                ConfigPrj.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigPrj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigPrj";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConfigApp
    extends ApplicationUsagesCollector {
        @NotNull
        public String getGroupId() {
            return DatabaseUsagesCollectors.CONFIG_GROUP;
        }

        public int getVersion() {
            return 4;
        }

        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set set = DatabaseUsagesCollectors.configImpl(null);
            if (set == null) {
                ConfigApp.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigApp", "getMetrics"));
        }
    }

    public static class ManagersPrj
    extends ProjectUsagesCollector {
        @NotNull
        public String getGroupId() {
            return DatabaseUsagesCollectors.MANAGERS_GROUP;
        }

        public int getVersion() {
            return 3;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project p2) {
            if (p2 == null) {
                ManagersPrj.$$$reportNull$$$0(0);
            }
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)p2);
            HashSet<MetricEvent> result = new HashSet<MetricEvent>();
            for (DbDataSource ds : facade.getDataSources()) {
                Class<?> aClass = facade.getDataSourceManager(ds).getClass();
                String managerName = StringUtil.toLowerCase((String)StringUtil.trimEnd((String)aClass.getSimpleName(), (String)"DataSourceManager"));
                FeatureUsageData data = new FeatureUsageData();
                if ("sql".equals(managerName)) {
                    data.addLanguage(((DbDataSourceImpl)ds).getQueryLanguage());
                }
                data.addData("name", managerName);
                result.add(MetricEventFactoryKt.newMetric((String)"manager", (FeatureUsageData)data));
            }
            HashSet<MetricEvent> hashSet = result;
            if (hashSet == null) {
                ManagersPrj.$$$reportNull$$$0(1);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ManagersPrj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ManagersPrj";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

