/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003J\t\u0010)\u001a\u00020\u000eH\u00c6\u0003J\t\u0010*\u001a\u00020\u0010H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u00c6\u0003Ji\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u00d6\u0003J\t\u00101\u001a\u000202H\u00d6\u0001J\t\u00103\u001a\u000204H\u00d6\u0001R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lcom/intellij/database/script/generator/ScriptingSingleModelTask;", "Lcom/intellij/database/script/generator/ScriptingTask;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "currentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "version", "Lcom/intellij/database/util/Version;", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "(Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;Lcom/intellij/database/model/basic/BasicDatabase;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/script/generator/ScriptCategory;Lcom/intellij/database/script/generator/ScriptingOptions;Lcom/intellij/database/util/Version;Lcom/intellij/database/script/generator/ScriptConsumer;)V", "getCategory", "()Lcom/intellij/database/script/generator/ScriptCategory;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "getElements", "()Ljava/util/Collection;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "getVersion", "()Lcom/intellij/database/util/Version;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.database.impl"})
public final class ScriptingSingleModelTask
extends ScriptingTask {
    @NotNull
    private final BasicModel model;
    @NotNull
    private final Collection<BasicElement> elements;
    @Nullable
    private final BasicDatabase currentDatabase;
    @Nullable
    private final BasicSchema currentSchema;
    @NotNull
    private final ScriptCategory category;
    @NotNull
    private final ScriptingOptions options;
    @NotNull
    private final Version version;
    @Nullable
    private final ScriptConsumer<?> consumer;

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @NotNull
    public final Collection<BasicElement> getElements() {
        return this.elements;
    }

    @Override
    @Nullable
    public BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    @Override
    @Nullable
    public BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    @Override
    @NotNull
    public ScriptCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public ScriptConsumer<?> getConsumer() {
        return this.consumer;
    }

    public ScriptingSingleModelTask(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptCategory category, @NotNull ScriptingOptions options, @NotNull Version version, @Nullable ScriptConsumer<?> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        super(null);
        this.model = model;
        this.elements = elements;
        this.currentDatabase = currentDatabase;
        this.currentSchema = currentSchema;
        this.category = category;
        this.options = options;
        this.version = version;
        this.consumer = consumer2;
        boolean bl = this.getCurrentDatabase() == null || this.model.contains(this.getCurrentDatabase());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.getCurrentSchema() == null || this.model.contains(this.getCurrentSchema()) && Intrinsics.areEqual((Object)this.getCurrentSchema().getDatabase(), (Object)this.getCurrentDatabase());
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.getCategory() != ScriptCategory.ALTER && this.getCategory() != ScriptCategory.NATIVE_DEFINITION;
        bl2 = false;
        bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ ScriptingSingleModelTask(BasicModel basicModel, Collection collection, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptCategory scriptCategory, ScriptingOptions scriptingOptions, Version version, ScriptConsumer scriptConsumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            BasicRoot basicRoot = basicModel.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"model.root");
            basicDatabase = basicRoot.getCurrentDatabase();
        }
        if ((n & 8) != 0) {
            BasicDatabase basicDatabase2 = basicDatabase;
            BasicSchema basicSchema2 = basicSchema = basicDatabase2 != null ? ModelFun.getCurrentSchema(basicDatabase2) : null;
        }
        if ((n & 0x20) != 0) {
            scriptingOptions = ScriptingTaskKt.defaultScriptingOptions(basicModel);
        }
        if ((n & 0x40) != 0) {
            BasicRoot basicRoot = basicModel.getRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicRoot, (String)"model.root");
            Version version2 = basicRoot.getServerVersion();
            if (version2 == null) {
                Version version3 = Version.ZERO;
                version2 = version3;
                Intrinsics.checkExpressionValueIsNotNull((Object)version3, (String)"Version.ZERO");
            }
            version = version2;
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = null;
        }
        this(basicModel, collection, basicDatabase, basicSchema, scriptCategory, scriptingOptions, version, scriptConsumer);
    }

    @NotNull
    public final BasicModel component1() {
        return this.model;
    }

    @NotNull
    public final Collection<BasicElement> component2() {
        return this.elements;
    }

    @Nullable
    public final BasicDatabase component3() {
        return this.getCurrentDatabase();
    }

    @Nullable
    public final BasicSchema component4() {
        return this.getCurrentSchema();
    }

    @NotNull
    public final ScriptCategory component5() {
        return this.getCategory();
    }

    @NotNull
    public final ScriptingOptions component6() {
        return this.getOptions();
    }

    @NotNull
    public final Version component7() {
        return this.getVersion();
    }

    @Nullable
    public final ScriptConsumer<?> component8() {
        return this.getConsumer();
    }

    @NotNull
    public final ScriptingSingleModelTask copy(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptCategory category, @NotNull ScriptingOptions options, @NotNull Version version, @Nullable ScriptConsumer<?> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return new ScriptingSingleModelTask(model, elements, currentDatabase, currentSchema, category, options, version, consumer2);
    }

    public static /* synthetic */ ScriptingSingleModelTask copy$default(ScriptingSingleModelTask scriptingSingleModelTask, BasicModel basicModel, Collection collection, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptCategory scriptCategory, ScriptingOptions scriptingOptions, Version version, ScriptConsumer scriptConsumer, int n, Object object) {
        if ((n & 1) != 0) {
            basicModel = scriptingSingleModelTask.model;
        }
        if ((n & 2) != 0) {
            collection = scriptingSingleModelTask.elements;
        }
        if ((n & 4) != 0) {
            basicDatabase = scriptingSingleModelTask.getCurrentDatabase();
        }
        if ((n & 8) != 0) {
            basicSchema = scriptingSingleModelTask.getCurrentSchema();
        }
        if ((n & 0x10) != 0) {
            scriptCategory = scriptingSingleModelTask.getCategory();
        }
        if ((n & 0x20) != 0) {
            scriptingOptions = scriptingSingleModelTask.getOptions();
        }
        if ((n & 0x40) != 0) {
            version = scriptingSingleModelTask.getVersion();
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = scriptingSingleModelTask.getConsumer();
        }
        return scriptingSingleModelTask.copy(basicModel, collection, basicDatabase, basicSchema, scriptCategory, scriptingOptions, version, scriptConsumer);
    }

    @NotNull
    public String toString() {
        return "ScriptingSingleModelTask(model=" + this.model + ", elements=" + this.elements + ", currentDatabase=" + this.getCurrentDatabase() + ", currentSchema=" + this.getCurrentSchema() + ", category=" + (Object)((Object)this.getCategory()) + ", options=" + this.getOptions() + ", version=" + this.getVersion() + ", consumer=" + this.getConsumer() + ")";
    }

    public int hashCode() {
        BasicModel basicModel = this.model;
        Collection<BasicElement> collection = this.elements;
        BasicDatabase basicDatabase = this.getCurrentDatabase();
        BasicSchema basicSchema = this.getCurrentSchema();
        ScriptCategory scriptCategory = this.getCategory();
        ScriptingOptions scriptingOptions = this.getOptions();
        Version version = this.getVersion();
        ScriptConsumer<?> scriptConsumer = this.getConsumer();
        return (((((((basicModel != null ? basicModel.hashCode() : 0) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (basicDatabase != null ? basicDatabase.hashCode() : 0)) * 31 + (basicSchema != null ? basicSchema.hashCode() : 0)) * 31 + (scriptCategory != null ? ((Object)((Object)scriptCategory)).hashCode() : 0)) * 31 + (scriptingOptions != null ? scriptingOptions.hashCode() : 0)) * 31 + (version != null ? version.hashCode() : 0)) * 31 + (scriptConsumer != null ? scriptConsumer.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ScriptingSingleModelTask)) break block3;
                ScriptingSingleModelTask scriptingSingleModelTask = (ScriptingSingleModelTask)object;
                if (!Intrinsics.areEqual((Object)this.model, (Object)scriptingSingleModelTask.model) || !Intrinsics.areEqual(this.elements, scriptingSingleModelTask.elements) || !Intrinsics.areEqual((Object)this.getCurrentDatabase(), (Object)scriptingSingleModelTask.getCurrentDatabase()) || !Intrinsics.areEqual((Object)this.getCurrentSchema(), (Object)scriptingSingleModelTask.getCurrentSchema()) || !Intrinsics.areEqual((Object)((Object)this.getCategory()), (Object)((Object)scriptingSingleModelTask.getCategory())) || !Intrinsics.areEqual((Object)this.getOptions(), (Object)scriptingSingleModelTask.getOptions()) || !Intrinsics.areEqual((Object)this.getVersion(), (Object)scriptingSingleModelTask.getVersion()) || !Intrinsics.areEqual(this.getConsumer(), scriptingSingleModelTask.getConsumer())) break block3;
            }
            return true;
        }
        return false;
    }
}

