/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemaExportHelperImpl<Ed>
implements SchemaExportHelper {
    protected final Map<Ed, DeObject> myCache;
    protected final DatabaseEditorContext myContext;
    protected final DeModel myModel;
    private final Set<Ed> myLocked;

    protected SchemaExportHelperImpl(@NotNull DatabaseEditorContext context, @NotNull DeModel model) {
        if (context == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(0);
        }
        if (model == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(1);
        }
        this.myCache = new HashMap<Ed, DeObject>();
        this.myLocked = new HashSet<Ed>();
        this.myContext = context;
        this.myModel = model;
    }

    @Override
    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(2);
        }
        return databaseEditorContext;
    }

    @NotNull
    public static SchemaExportHelper createChained(@NotNull DeModel model) {
        if (model == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(3);
        }
        return new DeSchemaExportHelper(model);
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(4);
        }
        return deModel;
    }

    public boolean contains(@NotNull Ed obj) {
        if (obj == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(5);
        }
        return this.myCache.containsKey(obj);
    }

    public boolean canExport(@NotNull Ed object) {
        if (object == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(6);
        }
        return this.getExporter(object) != null;
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    public <De extends DeObject> De export(@Nullable Ed object, boolean withChildren) {
        if (object == null) {
            return null;
        }
        assert (object instanceof BasicElement || object instanceof DeObject) : "Unsupported object passed: " + object.getClass().getSimpleName();
        assert (!(object instanceof BasicRoot)) : "Root is not exportable";
        DeObject res2 = this.myCache.get(object);
        if (!(res2 == null || withChildren && res2.lightExported)) {
            return (De)res2;
        }
        BaseExporter<DeObject, Ed, ?> exporter = this.getExporter(object);
        assert (exporter != null) : "No exporter for " + object.getClass().getName();
        if (res2 == null) {
            boolean wasFree = this.myLocked.add(object);
            assert (wasFree);
            assert (!(object instanceof DeObject) || ((DeObject)object).model != this.myModel);
            res2 = exporter.create(this, object);
            this.myLocked.remove(object);
            this.created(object, res2);
            res2.lightExported = true;
            exporter.lightExport(this, res2, object);
            if (res2.getParent() != null && res2.getParent().lightExported) {
                res2.getParent().addLightChild(res2);
            }
        }
        if (withChildren && res2.lightExported) {
            res2.lightChildren = null;
            res2.lightExported = false;
            exporter.exportChildren(this, res2, object);
        }
        return (De)res2;
    }

    protected abstract BaseExporter<? extends DeObject, Ed, ?> getExporter(@NotNull Ed var1);

    protected void created(@NotNull Ed object, @NotNull DeObject res2) {
        if (object == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(7);
        }
        if (res2 == null) {
            SchemaExportHelperImpl.$$$reportNull$$$0(8);
        }
        this.myCache.put(object, res2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaExportHelperImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaExportHelperImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChained";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canExport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "created";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeSchemaExportHelper
    extends SchemaExportHelperImpl<DeObject>
    implements DeObject.DeCopier {
        private static final BaseExporter<DeObject, DeObject, DeSchemaExportHelper> CLONER = new BaseExporter<DeObject, DeObject, DeSchemaExportHelper>(){

            @Override
            public void lightExport(@NotNull DeSchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
                if (helper == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (to == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (from == null) {
                    1.$$$reportNull$$$0(2);
                }
                to.copyFrom(from, false, helper);
                DeObject parent2 = to.getParent();
                if (parent2 instanceof DeTable) {
                    helper.export(parent2.getEditedDeObject(), true);
                }
                to.setEditedObject(from);
            }

            @Override
            public void exportChildren(@NotNull DeSchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
                if (helper == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (to == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (from == null) {
                    1.$$$reportNull$$$0(5);
                }
                to.copyChildrenFrom(from, helper);
            }

            @Override
            @NotNull
            public DeObject create(@NotNull DeSchemaExportHelper helper, @NotNull DeObject from) {
                if (helper == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (from == null) {
                    1.$$$reportNull$$$0(7);
                }
                DeObject object = from.emptyClone(helper.getModel());
                if (from.getParent() == null && Iterables.contains(from.model.getModelRoots(), (Object)from)) {
                    object.model.addRoot(object);
                }
                DeObject deObject = object;
                if (deObject == null) {
                    1.$$$reportNull$$$0(8);
                }
                return deObject;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 8: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 8: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "helper";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "to";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "from";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/schemaEditor/SchemaExportHelperImpl$DeSchemaExportHelper$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/schemaEditor/SchemaExportHelperImpl$DeSchemaExportHelper$1";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "lightExport";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "exportChildren";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 8: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 8: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        private DeSchemaExportHelper(@NotNull DeModel model) {
            if (model == null) {
                DeSchemaExportHelper.$$$reportNull$$$0(0);
            }
            super(model.getDeModel().getExportHelper().getContext(), model);
        }

        @Override
        public <De extends DeObject> De exportDeep(@Nullable DasModel model, @NotNull BasicElement object, boolean withChildren) {
            DeModel subModel;
            if (object == null) {
                DeSchemaExportHelper.$$$reportNull$$$0(1);
            }
            Object unexported = (subModel = this.myModel.getDeModel()) == null ? null : (Object)subModel.getExportHelper().exportDeep(model, object, withChildren);
            return this.export(unexported, withChildren);
        }

        @Override
        protected BaseExporter<? extends DeObject, DeObject, ?> getExporter(@NotNull DeObject object) {
            if (object == null) {
                DeSchemaExportHelper.$$$reportNull$$$0(2);
            }
            return CLONER;
        }

        @Override
        public <De extends DeObject> De copy(De object, boolean child) {
            return this.export(object, child);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/SchemaExportHelperImpl$DeSchemaExportHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportDeep";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getExporter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface BaseExporter<De extends DeObject, Das, H extends SchemaExportHelperImpl<?>> {
        @NotNull
        public De create(@NotNull H var1, @NotNull Das var2);

        public void lightExport(@NotNull H var1, @NotNull De var2, @NotNull Das var3);

        public void exportChildren(@NotNull H var1, @NotNull De var2, @NotNull Das var3);
    }
}

