/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSelectionImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelWithViewColumns;
import com.intellij.database.datagrid.SelectionModelWithViewRows;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.database.run.ui.treetable.ColumnNode;
import com.intellij.database.run.ui.treetable.RowNode;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeTableSelectionModel
implements SelectionModel<DataConsumer.Row, DataConsumer.Column>,
SelectionModelWithViewRows,
SelectionModelWithViewColumns {
    private final TableResultPanel myGrid;
    private final TreeTableResultView myView;
    private final GridSelectionTracker myTracker;

    TreeTableSelectionModel(@NotNull TableResultPanel grid, @NotNull TreeTableResultView view2) {
        if (grid == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(0);
        }
        if (view2 == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        this.myView = view2;
        this.myTracker = new GridSelectionTracker(grid, grid.getResultView());
        this.myView.getComponent().putClientProperty("SelectionModel", this);
    }

    @Override
    @NotNull
    public GridSelection<DataConsumer.Row, DataConsumer.Column> store() {
        int[] viewRows = this.myView.getComponent().getTable().getSelectedRows();
        int[] modelRows = new int[viewRows.length];
        int[] modelColumns = new int[viewRows.length];
        for (int i2 = 0; i2 < viewRows.length; ++i2) {
            Pair<Integer, Integer> rowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2Model().fun(viewRows[i2], 0);
            modelRows[i2] = (Integer)rowAndColumn.first;
            modelColumns[i2] = (Integer)rowAndColumn.second;
        }
        return new GridSelectionImpl(ModelIndexSet.forRows(this.myGrid, modelRows), ModelIndexSet.forColumns(this.myGrid, modelColumns));
    }

    @Override
    public void restore(@NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(2);
        }
        RawIndexConverter converter = this.myGrid.getRawIndexConverter();
        for (ModelIndex modelRow : selection.getSelectedRows().asIterable()) {
            for (ModelIndex modelColumn : selection.getSelectedColumns().asIterable()) {
                Pair<Integer, Integer> rowAndColumn = converter.rowAndColumn2View().fun(modelRow.asInteger(), modelColumn.asInteger());
                int rowIdx = (Integer)rowAndColumn.first;
                if (!converter.isValidViewRowIdx(rowIdx)) continue;
                this.myView.getComponent().getTree().setSelectionRow(rowIdx);
            }
        }
    }

    @Override
    @NotNull
    public GridSelection<DataConsumer.Row, DataConsumer.Column> fit(@NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(3);
        }
        return new GridSelectionImpl(selection.getSelectedRows(), selection.getSelectedColumns());
    }

    @Override
    @NotNull
    public GridSelectionTracker getTracker() {
        GridSelectionTracker gridSelectionTracker = this.myTracker;
        if (gridSelectionTracker == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(4);
        }
        return gridSelectionTracker;
    }

    @Override
    public void setRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(5);
        }
        this.myView.getComponent().getTree().clearSelection();
        this.addRowSelection(selection);
    }

    @Override
    public void setSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (rows == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(6);
        }
        if (columns == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(7);
        }
        this.myView.getComponent().getTree().clearSelection();
        for (ModelIndex rowIdx : rows.asIterable()) {
            for (ModelIndex columnIdx : columns.asIterable()) {
                this.setSelection(rowIdx, columnIdx, true);
            }
        }
    }

    @Override
    public void setSelection(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(8);
        }
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(9);
        }
        this.setSelection(row, column, false);
    }

    private void setSelection(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, boolean add) {
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(10);
        }
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(11);
        }
        if (!add) {
            this.myView.getComponent().getTree().clearSelection();
        }
        RawIndexConverter converter = this.myGrid.getRawIndexConverter();
        Pair<Integer, Integer> rowAndColumn = converter.rowAndColumn2View().fun(row.asInteger(), column.asInteger());
        int viewRow = (Integer)rowAndColumn.first;
        if (!converter.isValidViewRowIdx(viewRow)) {
            return;
        }
        this.myView.getComponent().getTree().addSelectionRow(viewRow);
    }

    @Override
    public void setRowSelection(@NotNull ModelIndex<DataConsumer.Row> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(12);
        }
        this.setRowSelection(ModelIndexSet.forRows(this.myGrid, selection.value), selectAtLeastOneCell);
    }

    @Override
    public void addRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> selection) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(13);
        }
        for (ModelIndex rowIdx : selection.asIterable()) {
            ViewIndex viewIdx = rowIdx.toView(this.myGrid);
            this.myView.getComponent().getTree().addSelectionRow(viewIdx.asInteger());
        }
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndexSet<DataConsumer.Column> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(14);
        }
        this.myView.getComponent().getTree().clearSelection();
        ModelIndexSet<DataConsumer.Row> rows = this.getSelectedRows();
        if (rows.size() == 0 && selectAtLeastOneCell) {
            rows = ModelIndexSet.forRows(this.myGrid, 0);
        }
        this.setSelection(rows, selection);
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndex<DataConsumer.Column> selection, boolean selectAtLeastOneCell) {
        if (selection == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(15);
        }
        this.setColumnSelection(ModelIndexSet.forColumns(this.myGrid, selection.value), selectAtLeastOneCell);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.myView.getComponent().getTree().isSelectionEmpty();
    }

    @Override
    public boolean isSelected(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(16);
        }
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(17);
        }
        Pair<Integer, Integer> rowAndColumn = this.myView.getRawIndexConverter().rowAndColumn2View().fun(row.asInteger(), column.asInteger());
        return this.myView.getComponent().getTable().isRowSelected(((Integer)rowAndColumn.first).intValue());
    }

    @Override
    public boolean isSelected(@NotNull ViewIndex<DataConsumer.Row> row, @NotNull ViewIndex<DataConsumer.Column> column) {
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(18);
        }
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(19);
        }
        return this.myView.getComponent().getTable().isRowSelected(row.asInteger());
    }

    @Override
    public boolean isSelectedColumn(@NotNull ModelIndex<DataConsumer.Column> column) {
        if (column == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(20);
        }
        int viewColumn = this.myView.getRawIndexConverter().column2View().fun(column.asInteger());
        return this.myView.getComponent().getTable().isColumnSelected(viewColumn);
    }

    @Override
    public boolean isSelectedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        Object[] paths;
        if (row == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(21);
        }
        if ((paths = this.myView.getComponent().getTree().getSelectionPaths()) == null) {
            return false;
        }
        return ContainerUtil.find((Object[])paths, path -> ContainerUtil.find((Object[])path.getPath(), element2 -> element2 instanceof RowNode && ((RowNode)element2).getRowIdx().equals(row)) != null) != null;
    }

    @Override
    public int getSelectedRowCount() {
        return this.getSelectedRows().size();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.getSelectedColumns().size();
    }

    @Override
    public void selectWholeRow() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> this.setRowSelection(this.getSelectedRows(), true));
    }

    @Override
    public void selectWholeColumn() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> {
            ModelIndexSet<DataConsumer.Row> rows = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowIndices();
            this.setSelection(rows, this.getSelectedColumns());
        });
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> getSelectedRow() {
        TreePath path = this.myView.getComponent().getTree().getSelectionPath();
        RowNode rowNode = TreeTableSelectionModel.findNode(path, RowNode.class);
        ModelIndex<DataConsumer.Row> modelIndex = rowNode == null ? ModelIndex.forRow(this.myGrid, -1) : rowNode.getRowIdx();
        if (modelIndex == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(22);
        }
        return modelIndex;
    }

    @Override
    public int selectedViewRowsCount() {
        return this.getSelectedRowCount();
    }

    @Override
    public int selectedViewColumnsCount() {
        return this.getSelectedColumnCount();
    }

    @Nullable
    private static <T> T findNode(@Nullable TreePath path, Class<? super T> aClass) {
        if (path == null) {
            return null;
        }
        return (T)ContainerUtil.find((Object[])path.getPath(), element2 -> Conditions.instanceOf((Class)aClass).value(element2));
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getSelectedRows() {
        Object[] paths = this.myView.getComponent().getTree().getSelectionPaths();
        if (paths == null) {
            ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myGrid, new int[0]);
            if (modelIndexSet == null) {
                TreeTableSelectionModel.$$$reportNull$$$0(23);
            }
            return modelIndexSet;
        }
        List rowNodes = ContainerUtil.mapNotNull((Object[])paths, path -> TreeTableSelectionModel.findNode(path, RowNode.class));
        List rowIndices = ContainerUtil.map((Collection)rowNodes, rowNode -> rowNode.getRowIdx().asInteger());
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(this.myGrid, ArrayUtil.toIntArray((Collection)rowIndices));
        if (modelIndexSet == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(24);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getSelectedColumn() {
        TreePath path = this.myView.getComponent().getTree().getSelectionPath();
        ColumnNode columnNode = TreeTableSelectionModel.findNode(path, ColumnNode.class);
        ModelIndex<DataConsumer.Column> modelIndex = columnNode == null ? ModelIndex.forColumn(this.myGrid, -1) : columnNode.getColumnIdx();
        if (modelIndex == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(25);
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getSelectedColumns() {
        Object[] paths = this.myView.getComponent().getTree().getSelectionPaths();
        if (paths == null) {
            ModelIndexSet<DataConsumer.Column> modelIndexSet = ModelIndexSet.forColumns(this.myGrid, new int[0]);
            if (modelIndexSet == null) {
                TreeTableSelectionModel.$$$reportNull$$$0(26);
            }
            return modelIndexSet;
        }
        List columnNodes = ContainerUtil.mapNotNull((Object[])paths, path -> TreeTableSelectionModel.findNode(path, ColumnNode.class));
        List columnIndices = ContainerUtil.map((Collection)columnNodes, rowNode -> rowNode.getColumnIdx().asInteger());
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ModelIndexSet.forColumns(this.myGrid, ArrayUtil.toIntArray((Collection)columnIndices));
        if (modelIndexSet == null) {
            TreeTableSelectionModel.$$$reportNull$$$0(27);
        }
        return modelIndexSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/treetable/TreeTableSelectionModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 9: 
            case 11: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/treetable/TreeTableSelectionModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRow";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumn";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fit";
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 5: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setRowSelection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRowSelection";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setColumnSelection";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedColumn";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedRow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

