/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPositionWidget;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.table.TableGoToRowHelper;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class TablePositionWidgetHelper
implements GridPositionWidget.PositionWidgetHelper {
    private final TableResultView myTable;
    private final DataGrid myGrid;

    public TablePositionWidgetHelper(@NotNull TableResultView table, @NotNull DataGrid grid) {
        if (table == null) {
            TablePositionWidgetHelper.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TablePositionWidgetHelper.$$$reportNull$$$0(1);
        }
        this.myTable = table;
        this.myGrid = grid;
        table.putClientProperty("ResultViewPositionWidgetHelper", this);
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        SelectionModel model = this.myGrid.getSelectionModel();
        int colNum = model.getSelectedColumnCount();
        int rowNum = model.getSelectedRowCount();
        if (colNum == 0 || rowNum == 0) {
            return "";
        }
        boolean editing = this.myGrid.isEditing();
        if (colNum > 1 || rowNum > 1) {
            int cellCount = colNum * rowNum;
            sb.append(cellCount).append(" ").append(StringUtil.pluralize((String)"cell", (int)cellCount)).append(", ").append(rowNum).append(" ").append(StringUtil.pluralize((String)"row", (int)rowNum));
            if (editing) {
                return sb.toString();
            }
            sb.append("     ");
        }
        if (editing) {
            return "";
        }
        TableGoToRowHelper.Counter counter = TableGoToRowHelper.Counter.get(this.myTable);
        int minRow = counter.verticalUnit(this.myGrid);
        int minColumn = counter.horizontalUnit(this.myGrid);
        if (minColumn == -1 || minRow == -1) {
            return sb.toString();
        }
        sb.append(minRow + 1).append(":").append(minColumn + 1);
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/table/TablePositionWidgetHelper";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

