/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellRenderers
implements Disposable {
    public final DataGrid grid;
    public final Ref<GridCellRendererFactories> myFactories;

    public GridCellRenderers(@NotNull DataGrid grid) {
        if (grid == null) {
            GridCellRenderers.$$$reportNull$$$0(0);
        }
        this.grid = grid;
        this.myFactories = new Ref((Object)new GridCellRendererFactories(grid));
    }

    @Nullable
    public GridCellRenderer getRenderer(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            GridCellRenderers.$$$reportNull$$$0(1);
        }
        if (column == null) {
            GridCellRenderers.$$$reportNull$$$0(2);
        }
        if (this.myFactories.isNull()) {
            return null;
        }
        DataConsumer.Column c2 = this.grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column);
        if (c2 == null) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this.grid);
        GridCellRenderer bestRenderer = null;
        int bestSuitability = 0;
        for (GridCellRendererFactory factory : ((GridCellRendererFactories)this.myFactories.get()).getFactoriesFor(dialect, c2)) {
            GridCellRenderer renderer = factory.getOrCreateRenderer(column);
            int suitability = renderer.getSuitability(row, column);
            if (suitability <= bestSuitability) continue;
            bestRenderer = renderer;
            bestSuitability = suitability;
        }
        return bestRenderer;
    }

    public void dispose() {
        this.myFactories.set(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/GridCellRenderers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

