/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.LoadFileAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridTextCellEditorBase;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultTextEditorFactory
implements GridCellEditorFactory {
    private static final Set<String> PG_EDITABLE = ContainerUtil.set((Object[])new String[]{"uuid", "inet", "cidr", "macaddr", "interval", "money", "citext"});
    private static final Set<String> CASS_EDITABLE = ContainerUtil.set((Object[])new String[]{"set", "map", "list", "tuple", "udt", "uuid", "timeuuid", "inet"});

    DefaultTextEditorFactory() {
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(2);
        }
        DataConsumer.Column c2 = Objects.requireNonNull(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        int suitability = 0;
        if (DataGridUtil.getDbms(grid).isPostgres()) {
            suitability = DefaultTextEditorFactory.getPostgresSuitability(c2);
        } else if (DataGridUtil.getDbms(grid).isCassandra()) {
            suitability = DefaultTextEditorFactory.getCassandraSuitability(c2);
        }
        if (suitability == 0) {
            suitability = DefaultTextEditorFactory.getCommonSuitability(c2);
        }
        return suitability;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(3);
        }
        if (row == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(5);
        }
        DataConsumer.Column c2 = Objects.requireNonNull(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column));
        Dbms dbms = DataGridUtil.getDbms(grid);
        if (dbms.isPostgres() && DefaultTextEditorFactory.getPostgresSuitability(c2) > 0) {
            return new GridTextCellEditor(grid, column, object, initiator){

                @Override
                protected boolean isValueEditable() {
                    return super.isValueEditable() || this.myValue instanceof Object[];
                }
            };
        }
        if (dbms.isCassandra() && DefaultTextEditorFactory.getCassandraSuitability(c2) > 0) {
            return new GridTextCellEditor(grid, column, object, initiator){

                @Override
                protected boolean isValueEditable() {
                    return super.isValueEditable() || this.myValue instanceof Map || this.myValue instanceof Set || this.myValue instanceof List;
                }
            };
        }
        return new GridTextCellEditor(grid, column, object, initiator);
    }

    private static int getCommonSuitability(DataConsumer.Column c2) {
        switch (ExtractorsUtil.guessJdbcType(c2)) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 239: 
            case 2005: 
            case 2009: 
            case 2011: {
                return 1;
            }
        }
        return 0;
    }

    private static int getPostgresSuitability(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(6);
        }
        switch (c2.type) {
            case 0: 
            case 1111: {
                if (!PG_EDITABLE.contains(c2.typeName) && !PgBaseJdbcHelper.isEditableType((String)c2.typeName, (int)c2.type)) break;
                return 1;
            }
            case 2002: 
            case 2003: {
                return 1;
            }
        }
        return 0;
    }

    private static int getCassandraSuitability(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(7);
        }
        return CASS_EDITABLE.contains(StringUtil.toLowerCase((String)c2.typeName)) ? 1 : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPostgresSuitability";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCassandraSuitability";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GridTextCellEditor
    extends GridTextCellEditorBase
    implements LoadFileAction.LoadFileActionHandler {
        private GridTextCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object value2, EventObject initiator) {
            if (grid == null) {
                GridTextCellEditor.$$$reportNull$$$0(0);
            }
            if (column == null) {
                GridTextCellEditor.$$$reportNull$$$0(1);
            }
            super(grid, column, value2, initiator);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                GridTextCellEditor.$$$reportNull$$$0(2);
            }
            if (LoadFileAction.LOAD_FILE_ACTION_HANDLER_KEY.is(dataId)) {
                return this;
            }
            return null;
        }

        @Override
        @Nullable
        protected String getInitialText() {
            if (this.myValue == null || this.myValue instanceof ReservedCellValue) {
                return null;
            }
            if (this.isValueEditable() && this.myValue instanceof LobInfo) {
                return this.myValue instanceof LobInfo.ClobInfo ? ((LobInfo.ClobInfo)this.myValue).data : "";
            }
            return StringUtil.notNullize((String)super.getInitialText());
        }

        @Override
        protected boolean isValueEditable() {
            return this.myValue == null || this.myValue instanceof String || this.myValue instanceof ReservedCellValue || this.myValue instanceof LobInfo && !((LobInfo)this.myValue).isTruncated() && (this.myValue instanceof LobInfo.ClobInfo || ((LobInfo)this.myValue).length == 0L);
        }

        @Override
        public void fileChosen(@NotNull VirtualFile file) {
            if (file == null) {
                GridTextCellEditor.$$$reportNull$$$0(3);
            }
            this.myValue = GridTextCellEditor.loadValueFromFile(file);
            if (this.myValue == null || this.myValue instanceof LobInfo.FileClobInfo) {
                this.myGrid.stopEditing();
            } else {
                this.myTextField.setText(this.getInitialText());
            }
        }

        @Nullable
        private static Object loadValueFromFile(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                GridTextCellEditor.$$$reportNull$$$0(4);
            }
            if (virtualFile.getLength() > (long)DatabaseSettings.getSettings().getMaxLobLength()) {
                return DbImplUtil.clobFromFile(virtualFile);
            }
            try {
                return StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)virtualFile));
            }
            catch (IOException e) {
                String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)DataGridUtil.LOG).replace("\n", "<br>\n");
                String title = "Cannot read file: " + virtualFile.getName();
                Notifications.Bus.notify((Notification)new Notification("Update Table", title, trace, NotificationType.ERROR));
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileChosen";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValueFromFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

