/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractZonedTimeDelegate
extends DateAndTimeFormatterDelegate<TimeZonedTime, TemporalAccessor> {
    private static final ZoneOffset MAX_ZONE_OFFSET = ZoneOffset.of("+14:00");
    private static final ZoneOffset MIN_ZONE_OFFSET = ZoneOffset.of("-12:00");

    public AbstractZonedTimeDelegate() {
        super(AbstractZonedTimeDelegate::extractOffsetTime, AbstractZonedTimeDelegate::extractWithLocalOffset);
    }

    @Override
    protected TimeZonedTime createFromTemporal(@NotNull TemporalAccessor value2) {
        if (value2 == null) {
            AbstractZonedTimeDelegate.$$$reportNull$$$0(0);
        }
        return new TimeZonedTime(OffsetTime.from(value2));
    }

    private static TemporalAccessor extractOffsetTime(TemporalAccessor temporal) {
        OffsetTime offsetTime = OffsetTime.from(temporal);
        ZoneOffset offset = offsetTime.getOffset();
        if (MAX_ZONE_OFFSET.compareTo(offset) > 0 || MIN_ZONE_OFFSET.compareTo(offset) < 0) {
            throw new DateTimeException(DatabaseBundle.message((String)"zoned.time.out.of.range", (Object[])new Object[0]));
        }
        return offsetTime;
    }

    private static TemporalAccessor extractWithLocalOffset(TemporalAccessor temporal) {
        if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
            throw new DateTimeException(DatabaseBundle.message((String)"zoned.time.out.of.range", (Object[])new Object[0]));
        }
        return LocalTime.from(temporal).atOffset(DataGridFormattersUtil.getDefaultOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/AbstractZonedTimeDelegate", "createFromTemporal"));
    }
}

