/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.EditorHeaderToggleAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridSearchSession
implements GridSearchSession<DataConsumer.Row, DataConsumer.Column>,
DataProvider,
SearchReplaceComponent.Listener,
FindModel.FindModelObserver {
    private static final String FILTERING_ENABLED_PROPERTY = "grid.search.filter.rows";
    private final Project myProject;
    private final DataGrid myGrid;
    private final FindModel myFindModel;
    private final SearchReplaceComponent mySearchComponent;
    private final Component myPreviousFilterComponent;
    private final EventDispatcher<GridSearchSession.Listener> myDispatcher;
    private boolean myFilteringEnabled;

    public DataGridSearchSession(@Nullable Project project, @NotNull DataGrid grid, @Nullable FindModel findModel) {
        if (grid == null) {
            DataGridSearchSession.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(GridSearchSession.Listener.class);
        this.myProject = project;
        this.myGrid = grid;
        this.myFindModel = findModel != null ? findModel : this.createFindModel();
        this.myPreviousFilterComponent = grid.getFilterComponent();
        this.myFindModel.addObserver((FindModel.FindModelObserver)this);
        this.mySearchComponent = this.createSearchComponent();
        DataGridSearchSession.applyFindModel(this.mySearchComponent, this.myFindModel);
        if (this.myProject != null) {
            this.myFilteringEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(FILTERING_ENABLED_PROPERTY);
        }
        this.myGrid.setFilterComponent((Component)this.mySearchComponent);
        this.myGrid.searchSessionStarted(this);
        ComponentUtil.putClientProperty((JComponent)this.mySearchComponent, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<Component>(){

            @Override
            @NotNull
            public Iterator<Component> iterator() {
                Component component = DataGridSearchSession.this.myPreviousFilterComponent;
                if (component != null && component.getParent() == null) {
                    Iterator<Component> iterator = Collections.singleton(component).iterator();
                    if (iterator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }
                Iterator<Component> iterator = Collections.emptyIterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/DataGridSearchSession$1", "iterator"));
            }
        });
    }

    private static void applyFindModel(@NotNull SearchReplaceComponent component, @NotNull FindModel findModel) {
        if (component == null) {
            DataGridSearchSession.$$$reportNull$$$0(1);
        }
        if (findModel == null) {
            DataGridSearchSession.$$$reportNull$$$0(2);
        }
        component.getSearchTextComponent().setText(findModel.getStringToFind());
    }

    @NotNull
    private FindModel createFindModel() {
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)this.myProject).getFindInFileModel());
        FindModel findModel2 = findModel;
        if (findModel2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(3);
        }
        return findModel2;
    }

    @NotNull
    private SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent = SearchReplaceComponent.buildFor((Project)this.myProject, (JComponent)((Object)this.myGrid.getComponent())).addPrimarySearchActions(new AnAction[]{new PrevOccurrenceAction(), new NextOccurrenceAction()}).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleRegex(), new ToggleWholeWordsOnlyAction(), new ToggleFilteringAction(), new StatusTextAction()}).withCloseAction(this::close).withDataProvider((DataProvider)this).build();
        searchReplaceComponent.addListener((SearchReplaceComponent.Listener)this);
        SearchReplaceComponent searchReplaceComponent2 = searchReplaceComponent;
        if (searchReplaceComponent2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(4);
        }
        return searchReplaceComponent2;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.mySearchComponent;
        if (searchReplaceComponent == null) {
            DataGridSearchSession.$$$reportNull$$$0(5);
        }
        return searchReplaceComponent;
    }

    @Override
    public boolean isMatchedCell(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        GridModel<DataConsumer.Row, DataConsumer.Column> model;
        if (rowIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(6);
        }
        if (columnIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(7);
        }
        if (!(model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).isValidColumnIdx(columnIdx) || !model.isValidRowIdx(rowIdx)) {
            return false;
        }
        return FindManager.getInstance((Project)this.myProject).findString((CharSequence)this.getText(rowIdx, columnIdx), 0, this.myFindModel).isStringFound();
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myFilteringEnabled && this.isFilteringAvailable();
    }

    @Override
    public void addListener(@NotNull GridSearchSession.Listener listener2, @NotNull Disposable parent2) {
        if (listener2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(8);
        }
        if (parent2 == null) {
            DataGridSearchSession.$$$reportNull$$$0(9);
        }
        this.myDispatcher.addListener((EventListener)listener2, parent2);
    }

    public void searchFieldDocumentChanged() {
        String textToFind = this.mySearchComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(textToFind);
        this.myFindModel.setMultiline(textToFind.contains("\n"));
        this.fireSessionUpdated();
    }

    public void replaceFieldDocumentChanged() {
    }

    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.mySearchComponent.isMultiline());
    }

    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            DataGridSearchSession.$$$reportNull$$$0(10);
        }
        return findModel;
    }

    public boolean hasMatches() {
        return this.findOccurrence(true, true) != null;
    }

    public void searchForward() {
        this.selectOccurrence(false, true);
    }

    public void searchBackward() {
        this.selectOccurrence(false, false);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DataGridSearchSession.$$$reportNull$$$0(11);
        }
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    public void findModelChanged(FindModel findModel) {
        String stringToFind = this.myFindModel.getStringToFind();
        boolean incorrectRegex = this.myFindModel.isRegularExpressions() && this.myFindModel.compileRegExp() == null;
        boolean hasMatches = this.hasMatches();
        if (incorrectRegex || StringUtil.isNotEmpty((String)stringToFind) && !hasMatches) {
            this.mySearchComponent.setNotFoundBackground();
        } else {
            this.mySearchComponent.setRegularBackground();
        }
        this.mySearchComponent.setStatusText(incorrectRegex ? INCORRECT_REGEX_MESSAGE : "");
        this.mySearchComponent.update(stringToFind, "", false, this.myFindModel.isMultiline());
        if (hasMatches) {
            this.selectOccurrence(true, true);
        }
        FindUtil.updateFindInFileModel((Project)this.myProject, (FindModel)this.myFindModel, (boolean)true);
        this.fireSessionUpdated();
    }

    public void close() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myGrid.getPreferredFocusedComponent(), false);
        this.myGrid.setFilterComponent(this.myPreviousFilterComponent);
        this.myGrid.searchSessionStopped(this);
    }

    private void fireSessionUpdated() {
        ((GridSearchSession.Listener)this.myDispatcher.getMulticaster()).searchSessionUpdated();
    }

    private boolean isFilteringAvailable() {
        return this.myGrid.getPresentationMode() == GridPresentationMode.TABLE && !this.myGrid.getResultView().isTransposed();
    }

    private void selectOccurrence(boolean selectCurrent, boolean next) {
        Pair.NonNull<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> cell = this.findOccurrence(selectCurrent, next);
        if (cell != null) {
            SelectionModel selectionModel = this.myGrid.getSelectionModel();
            selectionModel.setSelection((ModelIndex)cell.first, (ModelIndex)cell.second);
        }
    }

    @Nullable
    private Pair.NonNull<ModelIndex<DataConsumer.Row>, ModelIndex<DataConsumer.Column>> findOccurrence(boolean includeStart, boolean forward) {
        List rows = this.myGrid.getVisibleRows().asList();
        List columns = this.myGrid.getVisibleColumns().asList();
        if (rows.isEmpty() || columns.isEmpty()) {
            return null;
        }
        ModelIndex startRow = this.myGrid.getSelectionModel().getSelectedRow();
        ModelIndex startColumn = this.myGrid.getSelectionModel().getSelectedColumn();
        int startRowIdx = rows.indexOf(startRow);
        int startColumnIdx = columns.indexOf(startColumn);
        if (startRowIdx == -1 || startColumnIdx == -1) {
            startRowIdx = 0;
            startColumnIdx = 0;
        }
        GridIt it2 = new GridIt(startRowIdx, startColumnIdx, rows.size(), columns.size(), forward, includeStart);
        while (it2.hasNext()) {
            ModelIndex column;
            ModelIndex row = (ModelIndex)rows.get(it2.row());
            if (this.isMatchedCell(row, column = (ModelIndex)columns.get(it2.column()))) {
                return new Pair.NonNull((Object)row, (Object)column);
            }
            it2.advance();
        }
        return null;
    }

    @NotNull
    private String getText(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (rowIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(12);
        }
        if (columnIdx == null) {
            DataGridSearchSession.$$$reportNull$$$0(13);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        DataConsumer.Row row = Objects.requireNonNull(model.getRow(rowIdx));
        DataConsumer.Column column = Objects.requireNonNull(model.getColumn(columnIdx));
        return this.getText(row, column);
    }

    @NotNull
    private String getText(DataConsumer.Row row, DataConsumer.Column column) {
        Dbms dbms = DataGridUtil.getDbms(this.myGrid);
        String string = this.myGrid.getObjectFormatter().getPlainValue(column, row, dbms);
        if (string == null) {
            DataGridSearchSession.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/DataGridSearchSession";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/DataGridSearchSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFindModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMatchedCell";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GridIt {
        private final ModuloIt myRowIt;
        private final ModuloIt myColumnIt;
        private final boolean myForward;

        GridIt(int startRow, int startColumn, int rowCount, int columnCount, boolean forward, boolean includeStart) {
            this.myRowIt = new ModuloIt(startRow, rowCount);
            this.myColumnIt = new ModuloIt(startColumn, columnCount);
            this.myForward = forward;
            if (!includeStart) {
                this.advance();
            }
        }

        boolean hasNext() {
            this.advance();
            boolean result = !this.myRowIt.atTheStart() || !this.myColumnIt.atTheStart();
            this.advance(!this.myForward);
            return result;
        }

        void advance() {
            this.advance(this.myForward);
        }

        void advance(boolean forward) {
            if (this.myColumnIt.atTheEnd(forward)) {
                this.myRowIt.advance(forward);
                this.myColumnIt.advance(forward);
                return;
            }
            this.myColumnIt.advance(forward);
        }

        int row() {
            return this.myRowIt.value();
        }

        int column() {
            return this.myColumnIt.value();
        }

        private static class ModuloIt {
            private final int myMax;
            private final int myStart;
            private int myCurrent;

            ModuloIt(int start2, int max) {
                this.myCurrent = start2;
                this.myStart = start2;
                this.myMax = max;
            }

            int value() {
                return this.myCurrent;
            }

            void advance(boolean forward) {
                this.myCurrent = this.nextValue(forward);
            }

            boolean atTheEnd(boolean forward) {
                return forward ? this.myCurrent == this.myMax - 1 : this.myCurrent == 0;
            }

            boolean atTheStart() {
                return this.myCurrent == this.myStart;
            }

            int nextValue(boolean forward) {
                int delta = forward ? 1 : -1;
                int byModulo = (this.myCurrent + delta) % this.myMax;
                return byModulo < 0 ? byModulo + this.myMax : byModulo;
            }
        }
    }

    private class ToggleFilteringAction
    extends EditorHeaderToggleAction {
        protected ToggleFilteringAction() {
            super("&Filter rows");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleFilteringAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(DataGridSearchSession.this.isFilteringAvailable());
            super.update(e);
        }

        protected boolean isSelected(@NotNull SearchSession session2) {
            if (session2 == null) {
                ToggleFilteringAction.$$$reportNull$$$0(1);
            }
            return DataGridSearchSession.this.myFilteringEnabled && DataGridSearchSession.this.isFilteringAvailable();
        }

        protected void setSelected(@NotNull SearchSession session2, boolean selected) {
            if (session2 == null) {
                ToggleFilteringAction.$$$reportNull$$$0(2);
            }
            boolean wasEnabled = DataGridSearchSession.this.myFilteringEnabled;
            DataGridSearchSession.this.myFilteringEnabled = selected;
            if (wasEnabled != selected) {
                DataGridSearchSession.this.fireSessionUpdated();
            }
            if (DataGridSearchSession.this.myProject != null) {
                PropertiesComponent.getInstance((Project)DataGridSearchSession.this.myProject).setValue(DataGridSearchSession.FILTERING_ENABLED_PROPERTY, DataGridSearchSession.this.myFilteringEnabled);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/DataGridSearchSession$ToggleFilteringAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

