/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.run.actions.ChangePageSizeAction;
import com.intellij.database.run.ui.CustomPageSizeForm;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetCustomPageSizeAction
extends DumbAwareAction {
    public SetCustomPageSizeAction() {
        super(ApplicationBundle.messagePointer((String)"custom.option", (Object[])new Object[0]), ApplicationBundle.messagePointer((String)"custom.option.description", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SetCustomPageSizeAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            SetCustomPageSizeAction.$$$reportNull$$$0(1);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = grid.getDataHookup().getPageModel();
        new MyDialogWrapper(SetCustomPageSizeAction.getEventProject((AnActionEvent)e), pageModel, grid).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/run/actions/SetCustomPageSizeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDialogWrapper
    extends DialogWrapper {
        private final GridPagingModel<DataConsumer.Row, DataConsumer.Column> myPagingModel;
        private final DataGrid myGrid;
        private final CustomPageSizeForm myForm;

        protected MyDialogWrapper(@Nullable Project project, @NotNull GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel, @NotNull DataGrid grid) {
            if (pageModel == null) {
                MyDialogWrapper.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                MyDialogWrapper.$$$reportNull$$$0(1);
            }
            super(project);
            this.myForm = new CustomPageSizeForm();
            this.myPagingModel = pageModel;
            this.myGrid = grid;
            this.setTitle("Change Page Size");
            this.initListeners();
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myForm.getResultPageSizeTextField();
        }

        private void initListeners() {
            this.myForm.getResultPageSizeTextField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateOk();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateOk();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateOk();
                }
            });
        }

        private void updateOk() {
            this.getOKAction().setEnabled(this.isOKActionEnabled());
        }

        public boolean isOKActionEnabled() {
            try {
                this.myForm.getResultPageSizeTextField().validateContent();
                return true;
            }
            catch (ConfigurationException ignored) {
                return false;
            }
        }

        @NotNull
        protected JComponent createCenterPanel() {
            boolean unlimited = DbImplUtil.isPageSizeUnlimited(this.myPagingModel.getPageSize());
            this.myForm.reset(unlimited ? DbImplUtil.getPageSize() : this.myPagingModel.getPageSize());
            JPanel jPanel = this.myForm.getPanel();
            if (jPanel == null) {
                MyDialogWrapper.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        protected void doOKAction() {
            super.doOKAction();
            ChangePageSizeAction.setPageSize(this.myForm.getPageSize(), this.myGrid);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pageModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/SetCustomPageSizeAction$MyDialogWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/SetCustomPageSizeAction$MyDialogWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCenterPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

