/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveLobAsAction
extends DeleteAction
implements DumbAware,
GridAction {
    private static final Logger LOG = Logger.getInstance(SaveLobAsAction.class);
    private static final String ERROR_MASK = "Cannot save LOB data: %s";

    public SaveLobAsAction() {
        super(null, null, null);
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            SaveLobAsAction.$$$reportNull$$$0(0);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(e.isFromActionToolbar());
            return;
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        ModelIndex lobColumnIdx = dataGrid.getSelectionModel().getSelectedColumn();
        DataConsumer.Column lobColumn = (DataConsumer.Column)model.getColumn(lobColumnIdx);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        if (dbms.isMongo()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        Object cellObject = model.getValueAt(dataGrid.getSelectionModel().getSelectedRow(), lobColumnIdx);
        List whereClauseColumns = lobColumn == null ? Collections.emptyList() : SaveLobAsAction.getWhereClauseColumns(lobColumn, dbms, table, model.getColumns());
        boolean enabled = dataGrid.isReady() && (whereClauseColumns.size() > 0 || model.getRowCount() == 1) && (cellObject instanceof LobInfo && ((LobInfo)cellObject).length >= 0L || cellObject instanceof byte[] && ((byte[])cellObject).length > 0 || cellObject instanceof ObjectFormatter.ImageInfo && ((ObjectFormatter.ImageInfo)cellObject).bytes != null || cellObject instanceof ObjectFormatter.TextInfo || cellObject instanceof String && ((String)cellObject).length() > 64);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<DataConsumer.Column> columns;
        if (e == null) {
            SaveLobAsAction.$$$reportNull$$$0(1);
        }
        final Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (project == null || dataGrid == null) {
            return;
        }
        ModelIndex rowIndex = dataGrid.getSelectionModel().getSelectedRow();
        ModelIndex colIndex = dataGrid.getSelectionModel().getSelectedColumn();
        if (!rowIndex.isValid(dataGrid) || !colIndex.isValid(dataGrid)) {
            return;
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        Object cellObject = model.getValueAt(rowIndex, colIndex);
        if (cellObject == null) {
            return;
        }
        DataConsumer.Row originalRow = (DataConsumer.Row)model.getRow(rowIndex);
        final DataConsumer.Column column = (DataConsumer.Column)model.getColumn(colIndex);
        if (originalRow == null || column == null) {
            return;
        }
        final VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Data As...", "Save data in a local file.", new String[0]), project).save(null, FileUtil.sanitizeFileName((String)column.name) + "_" + (rowIndex.toView(dataGrid).asInteger() + 1));
        if (wrapper == null) {
            return;
        }
        final DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(dataGrid);
        if (hookup == null) {
            return;
        }
        final String name = DataGridUtil.getResultSetName(e);
        String queryText2 = hookup.getUnlimitedQueryText(true);
        final DbDataSource system = DataGridUtil.getDatabaseSystem(dataGrid);
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        if (name == null || queryText2 == null) {
            return;
        }
        DasTable table = DataGridUtil.getDatabaseTable(dataGrid);
        List<DataConsumer.Column> filtered2 = SaveLobAsAction.getWhereClauseColumns(column, dbms, table, columns = model.getColumns());
        if (filtered2.size() == 0 && model.getRowCount() == 1) {
            DataRequest.Constraints constraints = DataRequest.newConstraints(originalRow.rowNum, 1, 0, hookup.getResultSetIndex());
            hookup.getMessageBus().getDataProducer().processRequest(new DataRequest.RawQueryRequest(hookup, hookup.getQueryText(), constraints){

                @Override
                public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (columns == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    hookup.setCurrentTx(context.txMarker);
                }

                @Override
                public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
                    if (context == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (rows.isEmpty()) {
                        SaveLobAsAction.errorNotification((DasDataSource)system, project, rows.size());
                    }
                    DataConsumer.Row item = (DataConsumer.Row)ContainerUtil.getFirstItem(rows);
                    SaveLobAsAction.saveObject(Objects.requireNonNull(item), name, column, (DasDataSource)system, wrapper, project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "columns";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setColumns";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "addRows";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return;
        }
        List data = ContainerUtil.map(filtered2, col -> new ColumnQueryData((DataConsumer.Column)col, col.getValue(originalRow)));
        RowQueryData rowQueryData = new RowQueryData(data, ArrayUtilRt.EMPTY_INT_ARRAY, queryText2);
        DataProducer producer = hookup.getMessageBus().getDataProducer();
        producer.processRequest(new MyTestRowCountRequest(hookup, rowQueryData, (DasDataSource)system, name, column, wrapper, project, table));
    }

    @NotNull
    private static List<DataConsumer.Column> getWhereClauseColumns(@NotNull DataConsumer.Column lobColumn, @NotNull Dbms dbms, @Nullable DasTable table, @NotNull List<DataConsumer.Column> columns) {
        if (lobColumn == null) {
            SaveLobAsAction.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            SaveLobAsAction.$$$reportNull$$$0(3);
        }
        if (columns == null) {
            SaveLobAsAction.$$$reportNull$$$0(4);
        }
        List list = ContainerUtil.filter(DbImplUtil.getWhereClauseColumns(table, columns, dbms), col -> col != lobColumn && (table != null || !DbImplUtil.isRowId(lobColumn)));
        if (list == null) {
            SaveLobAsAction.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void saveObject(final @NotNull DataConsumer.Row row, @NotNull String resultSetName, final @NotNull DataConsumer.Column column, final @NotNull DasDataSource system, final @NotNull VirtualFileWrapper wrapper, final @NotNull Project project) {
        if (row == null) {
            SaveLobAsAction.$$$reportNull$$$0(6);
        }
        if (resultSetName == null) {
            SaveLobAsAction.$$$reportNull$$$0(7);
        }
        if (column == null) {
            SaveLobAsAction.$$$reportNull$$$0(8);
        }
        if (system == null) {
            SaveLobAsAction.$$$reportNull$$$0(9);
        }
        if (wrapper == null) {
            SaveLobAsAction.$$$reportNull$$$0(10);
        }
        if (project == null) {
            SaveLobAsAction.$$$reportNull$$$0(11);
        }
        if (row.values.length < column.columnNum) {
            DbUIUtil.createNotification(system, String.format(ERROR_MASK, "Table structure has been changed"), NotificationType.ERROR).notify(project);
            return;
        }
        final AsyncFutureResult result = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        final AtomicBoolean error2 = new AtomicBoolean(false);
        final AtomicReference unitsRef = new AtomicReference();
        ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Saving LOB Data", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean exists = wrapper.exists();
                try {
                    indicator.setText("Saving " + wrapper.getFile().getPath() + "...");
                    unitsRef.set(SaveLobAsAction.saveObjectInner(system, column.getValue(row), wrapper, indicator, project));
                }
                catch (ProcessCanceledException ex) {
                    error2.set(true);
                    if (!exists) {
                        wrapper.getFile().delete();
                    }
                    throw ex;
                }
                catch (Exception e) {
                    error2.set(true);
                }
                finally {
                    result.set((Object)true);
                }
            }

            public boolean shouldStartInBackground() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/run/actions/SaveLobAsAction$2", "run"));
            }
        }));
        try {
            result.get();
            Units units = (Units)unitsRef.get();
            if (error2.get() || units == null) {
                return;
            }
            SaveLobAsAction.endNotification(resultSetName, system, wrapper, project, units);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void endNotification(@NotNull String resultSetName, @NotNull DasDataSource system, @NotNull VirtualFileWrapper wrapper, @NotNull Project project, @NotNull Units units) {
        if (resultSetName == null) {
            SaveLobAsAction.$$$reportNull$$$0(12);
        }
        if (system == null) {
            SaveLobAsAction.$$$reportNull$$$0(13);
        }
        if (wrapper == null) {
            SaveLobAsAction.$$$reportNull$$$0(14);
        }
        if (project == null) {
            SaveLobAsAction.$$$reportNull$$$0(15);
        }
        if (units == null) {
            SaveLobAsAction.$$$reportNull$$$0(16);
        }
        DbUIUtil.createFileLinkNotification(project, system, String.format("%s %s saved from %s to", ExtractorsUtil.getPresentableSize(units.count), StringUtil.pluralize((String)units.name, (int)units.count), resultSetName), NotificationType.INFORMATION, wrapper.getFile().getPath()).notify(project);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static Units saveObjectInner(@NotNull DasDataSource system, @Nullable Object value, @NotNull VirtualFileWrapper wrapper, @NotNull ProgressIndicator indicator, @NotNull Project project) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 65[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void errorNotification(@NotNull DasDataSource system, @NotNull Project project, int size) {
        if (system == null) {
            SaveLobAsAction.$$$reportNull$$$0(21);
        }
        if (project == null) {
            SaveLobAsAction.$$$reportNull$$$0(22);
        }
        String text2 = SaveLobAsAction.getErrorText(size);
        DbUIUtil.createNotification(system, text2, NotificationType.ERROR).notify(project);
    }

    @NotNull
    private static String getErrorText(int size) {
        String string = String.format(ERROR_MASK, size == 0 ? "table has been changed" : "ambiguous query result (" + size + " rows received)");
        if (string == null) {
            SaveLobAsAction.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lobColumn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/SaveLobAsAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSetName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 11: 
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "units";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhereClauseColumns";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWhereClauseColumns";
                break;
            }
            case 5: 
            case 23: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveObject";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "endNotification";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveObjectInner";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "errorNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Units {
        private final int count;
        private final String name;

        private Units(@NotNull String name, int count2) {
            if (name == null) {
                Units.$$$reportNull$$$0(0);
            }
            this.count = count2;
            this.name = name;
        }

        @NotNull
        static Units bytes(int count2) {
            return new Units("byte", count2);
        }

        @NotNull
        static Units chars(int count2) {
            return new Units("char", count2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/run/actions/SaveLobAsAction$Units", "<init>"));
        }
    }

    private static abstract class MyAbstractRequest
    extends DataRequest.ConditionQueryRequest {
        protected final DasDataSource mySystem;
        protected final Project myProject;
        protected final DataBusGridDataHookUp myHookUp;

        protected MyAbstractRequest(@NotNull DataBusGridDataHookUp hookUp, @NotNull RowQueryData rowQueryData, @NotNull DasDataSource system, @NotNull Project project, @Nullable DasTable table, int limit) {
            if (hookUp == null) {
                MyAbstractRequest.$$$reportNull$$$0(0);
            }
            if (rowQueryData == null) {
                MyAbstractRequest.$$$reportNull$$$0(1);
            }
            if (system == null) {
                MyAbstractRequest.$$$reportNull$$$0(2);
            }
            if (project == null) {
                MyAbstractRequest.$$$reportNull$$$0(3);
            }
            super(hookUp, rowQueryData, DataRequest.newConstraints(0, limit, 0, hookUp.getResultSetIndex()), table);
            this.myHookUp = hookUp;
            this.mySystem = system;
            this.myProject = project;
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                MyAbstractRequest.$$$reportNull$$$0(4);
            }
            if (columns == null) {
                MyAbstractRequest.$$$reportNull$$$0(5);
            }
            this.myHookUp.setCurrentTx(context.txMarker);
        }

        void checkRowCount(@NotNull List<DataConsumer.Row> rows) {
            if (rows == null) {
                MyAbstractRequest.$$$reportNull$$$0(6);
            }
            if (rows.size() != 1) {
                SaveLobAsAction.errorNotification(this.mySystem, this.myProject, rows.size());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowQueryData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$MyAbstractRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRowCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRequest
    extends MyAbstractRequest {
        private final String myResultSetName;
        private final DataConsumer.Column myColumn;
        private final VirtualFileWrapper myWrapper;

        protected MyRequest(@NotNull DataBusGridDataHookUp hookUp, @NotNull DasDataSource system, @NotNull String resultSetName, @NotNull RowQueryData rowQueryData, @NotNull DataConsumer.Column column, @NotNull VirtualFileWrapper wrapper, @NotNull Project project, @Nullable DasTable table) {
            if (hookUp == null) {
                MyRequest.$$$reportNull$$$0(0);
            }
            if (system == null) {
                MyRequest.$$$reportNull$$$0(1);
            }
            if (resultSetName == null) {
                MyRequest.$$$reportNull$$$0(2);
            }
            if (rowQueryData == null) {
                MyRequest.$$$reportNull$$$0(3);
            }
            if (column == null) {
                MyRequest.$$$reportNull$$$0(4);
            }
            if (wrapper == null) {
                MyRequest.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyRequest.$$$reportNull$$$0(6);
            }
            super(hookUp, rowQueryData, system, project, table, 1);
            this.myResultSetName = resultSetName;
            this.myColumn = column;
            this.myWrapper = wrapper;
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                MyRequest.$$$reportNull$$$0(7);
            }
            this.checkRowCount(rows);
            DataConsumer.Row row = (DataConsumer.Row)ContainerUtil.getFirstItem(rows);
            if (row == null || rows.size() != 1) {
                return;
            }
            SaveLobAsAction.saveObject(row, this.myResultSetName, this.myColumn, this.mySystem, this.myWrapper, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultSetName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowQueryData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$MyRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTestRowCountRequest
    extends MyAbstractRequest {
        private final List<DataConsumer.Row> myRows;
        private final String myResultSetName;
        private final DataConsumer.Column myColumn;
        private final VirtualFileWrapper myWrapper;

        protected MyTestRowCountRequest(@NotNull DataBusGridDataHookUp hookUp, @NotNull RowQueryData rowQueryData, @NotNull DasDataSource system, @NotNull String resultSetName, @NotNull DataConsumer.Column column, @NotNull VirtualFileWrapper wrapper, @NotNull Project project, @Nullable DasTable table) {
            if (hookUp == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(0);
            }
            if (rowQueryData == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(1);
            }
            if (system == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(2);
            }
            if (resultSetName == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(3);
            }
            if (column == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(4);
            }
            if (wrapper == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(5);
            }
            if (project == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(6);
            }
            super(hookUp, rowQueryData, system, project, table, 2);
            this.myResultSetName = resultSetName;
            this.myColumn = column;
            this.myWrapper = wrapper;
            this.myRows = new ArrayList<DataConsumer.Row>();
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(7);
            }
            this.myRows.addAll(rows);
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                MyTestRowCountRequest.$$$reportNull$$$0(8);
            }
            this.checkRowCount(this.myRows);
            if (this.myRows.size() != 1) {
                return;
            }
            MyRequest request = new MyRequest(this.myHookUp, this.mySystem, this.myResultSetName, this.rowQueryData, this.myColumn, this.myWrapper, this.myProject, this.table);
            this.myHookUp.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowQueryData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultSetName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/SaveLobAsAction$MyTestRowCountRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

